/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public class BaseImplementation {

    @KeepForSdk
    public static abstract class ApiMethodImpl<R extends Result, A extends Api.AnyClient>
    extends BasePendingResult<R>
    implements ResultHolder<R> {
        @KeepForSdk
        private final Api.AnyClientKey<A> mClientKey;
        @KeepForSdk
        @Nullable
        private final Api<?> mApi;

        @Deprecated
        @KeepForSdk
        protected ApiMethodImpl(@RecentlyNonNull Api.AnyClientKey<A> anyClientKey, @RecentlyNonNull GoogleApiClient googleApiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
            this.mClientKey = (Api.AnyClientKey)Preconditions.checkNotNull(anyClientKey);
            this.mApi = null;
        }

        @KeepForSdk
        protected ApiMethodImpl(@RecentlyNonNull Api<?> api, @RecentlyNonNull GoogleApiClient googleApiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            this.mClientKey = api.zac();
            this.mApi = api;
        }

        @VisibleForTesting
        @KeepForSdk
        protected ApiMethodImpl(@RecentlyNonNull BasePendingResult.CallbackHandler<R> object) {
            super(object);
            super();
            this.mClientKey = object;
            this.mApi = null;
        }

        @KeepForSdk
        @RecentlyNonNull
        public final Api.AnyClientKey<A> getClientKey() {
            return this.mClientKey;
        }

        @KeepForSdk
        @RecentlyNullable
        public final Api<?> getApi() {
            return this.mApi;
        }

        @KeepForSdk
        public final void run(@RecentlyNonNull A a) throws DeadObjectException {
            try {
                this.doExecute(a);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.setFailedResult((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.setFailedResult(remoteException);
                return;
            }
        }

        @Override
        @KeepForSdk
        public final void setFailedResult(@RecentlyNonNull Status object) {
            Preconditions.checkArgument((boolean)(object.isSuccess() ^ true), (Object)"Failed result must not be success");
            object = this.createFailedResult((Status)object);
            ((BasePendingResult)this).setResult(object);
            this.onSetFailedResult(object);
        }

        @KeepForSdk
        protected void onSetFailedResult(@RecentlyNonNull R r) {
        }

        @KeepForSdk
        protected abstract void doExecute(@RecentlyNonNull A var1) throws RemoteException;

        @KeepForSdk
        private void setFailedResult(@NonNull RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.setFailedResult(status);
        }
    }

    @KeepForSdk
    public static interface ResultHolder<R> {
        @KeepForSdk
        public void setResult(@RecentlyNonNull R var1);

        @KeepForSdk
        public void setFailedResult(@RecentlyNonNull Status var1);
    }
}

