/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.BasePendingResult;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public final class OptionalPendingResultImpl<R extends Result>
extends OptionalPendingResult<R> {
    private final BasePendingResult<R> zaa;

    public OptionalPendingResultImpl(@RecentlyNonNull PendingResult<R> pendingResult) {
        this.zaa = (BasePendingResult)pendingResult;
    }

    @Override
    public final boolean isDone() {
        return this.zaa.isReady();
    }

    @Override
    @RecentlyNonNull
    public final R get() {
        if (!((OptionalPendingResultImpl)object).zaa.isReady()) {
            Object object = new IllegalStateException("Result is not available. Check that isDone() returns true before calling get().");
            throw object;
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        return ((OptionalPendingResultImpl)object).zaa.await(0L, timeUnit);
    }

    @Override
    @RecentlyNonNull
    public final R await() {
        return this.zaa.await();
    }

    @Override
    @RecentlyNonNull
    public final R await(long l, @RecentlyNonNull TimeUnit timeUnit) {
        return this.zaa.await(l, timeUnit);
    }

    @Override
    public final void cancel() {
        this.zaa.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return this.zaa.isCanceled();
    }

    @Override
    public final void setResultCallback(@RecentlyNonNull ResultCallback<? super R> resultCallback) {
        this.zaa.setResultCallback(resultCallback);
    }

    @Override
    public final void setResultCallback(@RecentlyNonNull ResultCallback<? super R> resultCallback, long l, @RecentlyNonNull TimeUnit timeUnit) {
        this.zaa.setResultCallback(resultCallback, l, timeUnit);
    }

    @Override
    public final void addStatusListener(@RecentlyNonNull PendingResult.StatusListener statusListener) {
        ((PendingResult)this.zaa).addStatusListener(statusListener);
    }

    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@RecentlyNonNull ResultTransform<? super R, ? extends S> resultTransform) {
        return ((PendingResult)this.zaa).then(resultTransform);
    }
}

