/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zacj;
import com.google.android.gms.common.api.internal.zact;
import com.google.android.gms.common.api.internal.zacu;
import com.google.android.gms.common.internal.Preconditions;
import java.lang.ref.WeakReference;
import javax.annotation.concurrent.GuardedBy;

public final class zacv<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    @Nullable
    private ResultTransform<? super R, ? extends Result> zaa = null;
    @Nullable
    private zacv<? extends Result> zab = null;
    @Nullable
    private volatile ResultCallbacks<? super R> zac = null;
    @Nullable
    private PendingResult<R> zad = null;
    private final Object zae;
    @Nullable
    private Status zaf;
    private final WeakReference<GoogleApiClient> zag;
    private final zacu zah;
    private boolean zai;

    /*
     * Enabled aggressive block sorting
     */
    public zacv(WeakReference<GoogleApiClient> object) {
        zacu zacu2;
        Object object2;
        this.zae = object2 = new Object();
        this.zaf = null;
        this.zai = false;
        Preconditions.checkNotNull((Object)object, (Object)"GoogleApiClient reference must not be null");
        this.zag = object;
        object = (GoogleApiClient)this.zag.get();
        object = object != null ? ((GoogleApiClient)object).getLooper() : Looper.getMainLooper();
        this.zah = zacu2 = new zacu(this, (Looper)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> zacv2) {
        Object object = this.zae;
        synchronized (object) {
            ResultTransform<? super R, ? extends Result> resultTransform = this.zaa;
            boolean bl = resultTransform == null;
            String string2 = "Cannot call then() twice.";
            Preconditions.checkState((boolean)bl, (Object)string2);
            ResultCallbacks<? super R> resultCallbacks = this.zac;
            boolean bl2 = resultCallbacks == null;
            Preconditions.checkState((boolean)bl2, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zaa = zacv2;
            zacv2 = new zacv<R>(this.zag);
            this.zab = zacv2;
            this.zaj();
            return zacv2;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zae;
        synchronized (object) {
            ResultCallbacks<? super R> resultCallbacks2 = this.zac;
            boolean bl = resultCallbacks2 == null;
            String string2 = "Cannot call andFinally() twice.";
            Preconditions.checkState((boolean)bl, (Object)string2);
            ResultTransform<? super R, ? extends Result> resultTransform = this.zaa;
            boolean bl2 = resultTransform == null;
            Preconditions.checkState((boolean)bl2, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zac = resultCallbacks;
            this.zaj();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onResult(R r) {
        Object object = resultCallbacks.zae;
        synchronized (object) {
            boolean bl = r.getStatus().isSuccess();
            if (bl) {
                ResultTransform<? super R, ? extends Result> resultTransform = resultCallbacks.zaa;
                if (resultTransform != null) {
                    resultTransform = zacj.zaa();
                    zact zact2 = new zact((zacv)resultCallbacks, (Result)r);
                    resultTransform.submit(zact2);
                } else {
                    boolean bl2 = resultCallbacks.zam();
                    if (!bl2) return;
                    ResultCallbacks<R> resultCallbacks = resultCallbacks.zac;
                    ((ResultCallbacks)Preconditions.checkNotNull(resultCallbacks)).onSuccess(r);
                }
            } else {
                resultCallbacks.zak(r.getStatus());
                zacv.zan(r);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zaa(PendingResult<?> pendingResult) {
        Object object = this.zae;
        synchronized (object) {
            this.zad = pendingResult;
            this.zaj();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="mSyncToken")
    private final void zaj() {
        if (this.zaa != null || this.zac != null) {
            PendingResult<R> pendingResult = (GoogleApiClient)this.zag.get();
            if (!this.zai && this.zaa != null && pendingResult != null) {
                ((GoogleApiClient)((Object)pendingResult)).zao(this);
                this.zai = true;
            }
            if ((pendingResult = this.zaf) != null) {
                this.zal((Status)pendingResult);
                return;
            }
            pendingResult = this.zad;
            if (pendingResult != null) {
                pendingResult.setResultCallback(this);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zak(Status status) {
        Object object = this.zae;
        synchronized (object) {
            this.zaf = status;
            this.zal(this.zaf);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zal(Status object) {
        Object object2 = resultCallbacks.zae;
        synchronized (object2) {
            Object object3 = resultCallbacks.zaa;
            if (object3 != null) {
                object = ((ResultTransform)object3).onFailure((Status)object);
                object3 = "onFailure must not return null";
                object = Preconditions.checkNotNull((Object)object, (Object)object3);
                ((zacv)Preconditions.checkNotNull(resultCallbacks.zab)).zak((Status)object);
            } else {
                boolean bl = resultCallbacks.zam();
                if (!bl) return;
                ResultCallbacks<R> resultCallbacks = resultCallbacks.zac;
                ((ResultCallbacks)Preconditions.checkNotNull(resultCallbacks)).onFailure(object);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    final void zab() {
        this.zac = null;
    }

    @GuardedBy(value="mSyncToken")
    private final boolean zam() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zag.get();
        return this.zac != null && googleApiClient != null;
    }

    static /* synthetic */ ResultTransform zac(zacv zacv2) {
        return zacv2.zaa;
    }

    static /* synthetic */ zacu zad(zacv zacv2) {
        return zacv2.zah;
    }

    static /* synthetic */ void zae(zacv zacv2, Result result) {
        zacv.zan(result);
    }

    static /* synthetic */ WeakReference zaf(zacv zacv2) {
        return zacv2.zag;
    }

    static /* synthetic */ Object zag(zacv zacv2) {
        return zacv2.zae;
    }

    static /* synthetic */ zacv zah(zacv zacv2) {
        return zacv2.zab;
    }

    static /* synthetic */ void zai(zacv zacv2, Status status) {
        zacv2.zak(status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void zan(Result object) {
        if (!(object instanceof Releasable)) return;
        try {
            ((Releasable)object).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(object);
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 18);
            stringBuilder.append("Unable to release ");
            stringBuilder.append(string2);
            Log.w((String)"TransformedResultImpl", (String)stringBuilder.toString(), (Throwable)runtimeException);
            return;
        }
    }
}

