/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public abstract class DataBufferRef {
    @KeepForSdk
    @RecentlyNonNull
    protected final DataHolder mDataHolder;
    @KeepForSdk
    protected int mDataRow;
    private int zaa;

    @KeepForSdk
    public DataBufferRef(@RecentlyNonNull DataHolder dataHolder, int n) {
        this.mDataHolder = (DataHolder)Preconditions.checkNotNull((Object)dataHolder);
        this.zaa(n);
    }

    @KeepForSdk
    protected int getDataRow() {
        return this.mDataRow;
    }

    @KeepForSdk
    public boolean isDataValid() {
        return !this.mDataHolder.isClosed();
    }

    @KeepForSdk
    public boolean hasColumn(@RecentlyNonNull String string2) {
        return this.mDataHolder.hasColumn(string2);
    }

    @KeepForSdk
    protected long getLong(@RecentlyNonNull String string2) {
        return this.mDataHolder.getLong(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    protected int getInteger(@RecentlyNonNull String string2) {
        return this.mDataHolder.getInteger(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    protected boolean getBoolean(@RecentlyNonNull String string2) {
        return this.mDataHolder.getBoolean(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected String getString(@RecentlyNonNull String string2) {
        return this.mDataHolder.getString(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    protected float getFloat(@RecentlyNonNull String string2) {
        return this.mDataHolder.zab(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    protected double getDouble(@RecentlyNonNull String string2) {
        return this.mDataHolder.zac(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNonNull
    protected byte[] getByteArray(@RecentlyNonNull String string2) {
        return this.mDataHolder.getByteArray(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    @RecentlyNullable
    protected Uri parseUri(@RecentlyNonNull String string2) {
        String string3 = ((DataBufferRef)((Object)string3)).mDataHolder.getString(string2, ((DataBufferRef)((Object)string3)).mDataRow, ((DataBufferRef)((Object)string3)).zaa);
        if (string3 == null) {
            return null;
        }
        return Uri.parse((String)string3);
    }

    @KeepForSdk
    protected void copyToBuffer(@RecentlyNonNull String string2, @RecentlyNonNull CharArrayBuffer charArrayBuffer) {
        this.mDataHolder.zad(string2, this.mDataRow, this.zaa, charArrayBuffer);
    }

    @KeepForSdk
    protected boolean hasNull(@RecentlyNonNull String string2) {
        return this.mDataHolder.hasNull(string2, this.mDataRow, this.zaa);
    }

    @KeepForSdk
    public int hashCode() {
        Object[] objectArray = new Object[]{this.mDataRow, this.zaa, this.mDataHolder};
        return Objects.hashCode((Object[])objectArray);
    }

    @KeepForSdk
    public boolean equals(@Nullable Object object) {
        if (object instanceof DataBufferRef) {
            object = (DataBufferRef)object;
            return Objects.equal((Object)((DataBufferRef)object).mDataRow, (Object)this.mDataRow) && Objects.equal((Object)((DataBufferRef)object).zaa, (Object)this.zaa) && ((DataBufferRef)object).mDataHolder == this.mDataHolder;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void zaa(int n) {
        boolean bl = n >= 0 ? n < this.mDataHolder.getCount() : false;
        Preconditions.checkState((boolean)bl);
        this.mDataRow = n;
        this.zaa = this.mDataHolder.getWindowIndex(n);
    }
}

