/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;
import java.util.Iterator;

public final class DataBufferUtils {
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_NEXT_PAGE_TOKEN = "next_page_token";
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_PREV_PAGE_TOKEN = "prev_page_token";

    private DataBufferUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNonNull
    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(@RecentlyNonNull DataBuffer<E> dataBuffer) {
        ArrayList arrayList = new ArrayList(dataBuffer.getCount());
        try {
            boolean bl;
            Iterator<E> iterator = dataBuffer.iterator();
            while (bl = iterator.hasNext()) {
                arrayList.add(((Freezable)iterator.next()).freeze());
            }
            return arrayList;
        }
        finally {
            dataBuffer.close();
        }
    }

    public static boolean hasNextPage(@RecentlyNonNull DataBuffer<?> bundle) {
        return (bundle = bundle.getMetadata()) != null && bundle.getString(KEY_NEXT_PAGE_TOKEN) != null;
    }

    public static boolean hasPrevPage(@RecentlyNonNull DataBuffer<?> bundle) {
        return (bundle = bundle.getMetadata()) != null && bundle.getString(KEY_PREV_PAGE_TOKEN) != null;
    }

    public static boolean hasData(@RecentlyNonNull DataBuffer<?> dataBuffer) {
        return dataBuffer != null && dataBuffer.getCount() > 0;
    }
}

