/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zac;
import com.google.android.gms.common.data.zad;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    @RecentlyNonNull
    public static final Parcelable.Creator<DataHolder> CREATOR;
    @SafeParcelable.VersionField(id=1000)
    final int zaa;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zaf;
    Bundle zab;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zag;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zah;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    @Nullable
    private final Bundle zai;
    int[] zac;
    int zad;
    boolean zae;
    private boolean zaj;
    private static final Builder zak;

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) @Nullable Bundle bundle) {
        this.zae = false;
        this.zaj = true;
        this.zaa = n;
        this.zaf = stringArray;
        this.zag = cursorWindowArray;
        this.zah = n2;
        this.zai = bundle;
    }

    @KeepForSdk
    public DataHolder(@RecentlyNonNull String[] stringArray, @RecentlyNonNull CursorWindow[] cursorWindowArray, int n, @Nullable Bundle bundle) {
        this.zae = false;
        this.zaj = true;
        this.zaa = 1;
        this.zaf = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zag = (CursorWindow[])Preconditions.checkNotNull((Object)cursorWindowArray);
        this.zah = n;
        this.zai = bundle;
        this.zaa();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public DataHolder(@RecentlyNonNull Cursor cursor, int n, @Nullable Bundle bundle) {
        CursorWrapper cursorWrapper = new CursorWrapper(cursor);
        String[] stringArray = cursorWrapper.getColumnNames();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            int n2;
            int n3;
            int n4 = cursorWrapper.getCount();
            cursor = cursorWrapper.getWindow();
            if (cursor != null) {
                n3 = cursor.getStartPosition();
                if (n3 == 0) {
                    cursor.acquireReference();
                    cursorWrapper.setWindow(null);
                    arrayList.add(cursor);
                    n2 = cursor.getNumRows();
                } else {
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            while (n2 < n4 && (n3 = (int)(cursorWrapper.moveToPosition(n2) ? 1 : 0)) != 0) {
                CursorWindow cursorWindow;
                CursorWindow cursorWindow2 = cursorWrapper.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    cursorWrapper.setWindow(null);
                    cursorWindow = cursorWindow2;
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n2);
                    cursorWrapper.fillWindow(n2, cursorWindow2);
                    cursorWindow = cursorWindow2;
                }
                if ((n3 = cursorWindow.getNumRows()) != 0) {
                    arrayList.add(cursorWindow);
                    n3 = cursorWindow.getStartPosition();
                    n2 = cursorWindow.getNumRows();
                    n2 = n3 + n2;
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        this(stringArray, arrayList.toArray(new CursorWindow[arrayList.size()]), n, bundle);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle) {
        this(builder.zaa, DataHolder.zae(builder, -1), n, null);
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringArray((Parcel)parcel, (int)1, (String[])this.zaf, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.zag, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)4, (Bundle)this.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1000, (int)this.zaa);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        if ((n & 1) != 0) {
            this.close();
            return;
        }
    }

    @KeepForSdk
    public int getStatusCode() {
        return this.zah;
    }

    @KeepForSdk
    @RecentlyNullable
    public Bundle getMetadata() {
        return this.zai;
    }

    @KeepForSdk
    public boolean hasColumn(@RecentlyNonNull String string2) {
        return this.zab.containsKey(string2);
    }

    @KeepForSdk
    public long getLong(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getLong(n, this.zab.getInt(string2));
    }

    @KeepForSdk
    public int getInteger(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getInt(n, this.zab.getInt(string2));
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getString(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getString(n, this.zab.getInt(string2));
    }

    @KeepForSdk
    public boolean getBoolean(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return Long.valueOf(this.zag[n2].getLong(n, this.zab.getInt(string2))) == 1L;
    }

    @KeepForSdk
    @RecentlyNonNull
    public byte[] getByteArray(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getBlob(n, this.zab.getInt(string2));
    }

    @KeepForSdk
    public boolean hasNull(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].isNull(n, this.zab.getInt(string2));
    }

    @KeepForSdk
    public int getCount() {
        return this.zad;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public int getWindowIndex(int n) {
        int n2;
        int n3;
        block2: {
            int[] nArray;
            int n4 = n >= 0 ? (n < this.zad ? 1 : 0) : 0;
            Preconditions.checkState(n4 != 0);
            for (n4 = 0; n4 < (n3 = (nArray = this.zac).length); ++n4) {
                if (n >= nArray[n4]) continue;
                n2 = n4 + -1;
                break block2;
            }
            n2 = n4;
        }
        if (n2 == n3) {
            return n2 + -1;
        }
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isClosed() {
        synchronized (this) {
            return this.zae;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void close() {
        synchronized (this) {
            CursorWindow[] cursorWindowArray;
            int n;
            int n2 = this.zae;
            if (n2 != 0) return;
            this.zae = true;
            for (n2 = 0; n2 < (n = (cursorWindowArray = this.zag).length); ++n2) {
                cursorWindowArray[n2].close();
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        block7: {
            int n = this.zaj;
            if (n == 0) break block7;
            n = this.zag.length;
            if (n <= 0) break block7;
            n = this.isClosed() ? 1 : 0;
            if (n != 0) break block7;
            try {
                this.close();
                String string2 = "DataBuffer";
                String string3 = this.toString();
                int n2 = String.valueOf(string3).length();
                StringBuilder stringBuilder = new StringBuilder(n2 += 178);
                stringBuilder.append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ");
                stringBuilder.append(string3);
                stringBuilder.append(")");
                Log.e((String)string2, (String)stringBuilder.toString());
            }
            finally {
                super.finalize();
            }
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static Builder builder(@RecentlyNonNull String[] stringArray) {
        Builder builder = new Builder(stringArray, null, null);
        return builder;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static DataHolder empty(int n) {
        DataHolder dataHolder = new DataHolder(zak, n, null);
        return dataHolder;
    }

    static {
        Object object = new zad();
        CREATOR = object;
        zak = object = new zab(new String[0], null);
    }

    public final void zaa() {
        CursorWindow cursorWindow;
        String[] stringArray;
        int n;
        Bundle bundle;
        this.zab = bundle = new Bundle();
        for (n = 0; n < (stringArray = this.zaf).length; ++n) {
            this.zab.putInt(stringArray[n], n);
        }
        this.zac = new int[this.zag.length];
        n = 0;
        for (int i = 0; i < ((CursorWindow[])(cursorWindow = this.zag)).length; ++i) {
            this.zac[i] = n;
            cursorWindow = cursorWindow[i];
            int n2 = cursorWindow.getStartPosition();
            n += this.zag[i].getNumRows() - (n - n2);
        }
        this.zad = n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static CursorWindow[] zae(Builder var0, int var1_2) {
        if (Builder.zab((Builder)var0 /* !! */ ).length == 0) {
            return new CursorWindow[0];
        }
        var8_5 = Builder.zac((Builder)var0 /* !! */ );
        var9_6 = var8_5.size();
        var1_3 = new CursorWindow(false);
        var10_7 = new ArrayList<Object>();
        var10_7.add(var1_3);
        var1_3.setNumColumns(Builder.zab((Builder)var0 /* !! */ ).length);
        var2_8 = 0;
        var3_10 = 0;
        while (var3_10 < var9_6) {
            var4_12 = var1_3.allocRow();
            if (var4_12 == 0) {
                var1_3 = new StringBuilder(72);
                var1_3.append("Allocating additional cursor window for large data set (row ");
                var1_3.append(var3_10);
                var1_3.append(")");
                Log.d((String)"DataHolder", (String)var1_3.toString());
                var1_3 = new CursorWindow(false);
                var1_3.setStartPosition(var3_10);
                var1_3.setNumColumns(Builder.zab((Builder)var0 /* !! */ ).length);
                var10_7.add(var1_3);
                var4_12 = (int)var1_3.allocRow();
                if (var4_12 == 0) {
                    Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                    var10_7.remove(var1_3);
                    return var10_7.toArray(new CursorWindow[var10_7.size()]);
                }
            }
            var11_20 = (Map)var8_5.get(var3_10);
            var4_12 = 1;
            for (var5_15 = 0; var5_15 < (var6_16 = Builder.zab((Builder)var0 /* !! */ ).length); ++var5_15) {
                if (var4_12 != 0) {
                    var4_13 = Builder.zab((Builder)var0 /* !! */ )[var5_15];
                    var6_17 = var11_20.get(var4_13);
                    if (var6_17 == null) {
                        var4_12 = (int)var1_3.putNull(var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof String;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putString((String)var6_17, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Long;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putLong(((Long)var6_17).longValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Integer;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putLong((long)((Integer)var6_17).intValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Boolean;
                    if (var7_19) {
                        var4_12 = (int)((Boolean)var6_17).booleanValue();
                        var6_18 = 1 != var4_12 ? 0L : 1L;
                        var4_12 = (int)var1_3.putLong(var6_18, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof byte[];
                    if (var7_19) {
                        var4_12 = (int)var1_3.putBlob((byte[])var6_17, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Double;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putDouble(((Double)var6_17).doubleValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Float;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putDouble((double)((Float)var6_17).floatValue(), var3_10, var5_15);
                        continue;
                    }
                    ** break block24
                }
                ** GOTO lbl-1000
            }
            if (var4_12 != 0) {
                var2_8 = 0;
                var4_12 = var3_10;
            } else lbl-1000:
            // 2 sources

            {
                if (var2_8 != 0) {
                    var0 /* !! */  = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                    var1_3 = new zac((String)var0 /* !! */ );
                    throw var1_3;
                }
                var2_9 = new StringBuilder(74);
                var2_9.append("Couldn't populate window data for row ");
                var2_9.append(var3_10);
                var2_9.append(" - allocating new window.");
                Log.d((String)"DataHolder", (String)var2_9.toString());
                var1_3.freeLastRow();
                var1_3 = new CursorWindow(false);
                var1_3.setStartPosition(var3_10);
                var1_3.setNumColumns(Builder.zab((Builder)var0 /* !! */ ).length);
                var10_7.add(var1_3);
                var4_12 = var3_10 + -1;
                var2_8 = 1;
            }
            var3_10 = var4_12 + 1;
        }
        return var10_7.toArray(new CursorWindow[var10_7.size()]);
lbl-1000:
        // 1 sources

        {
            var1_3 = String.valueOf(var6_17);
            var2_8 = String.valueOf(var4_13).length();
            var2_8 += 32;
        }
        try {
            var3_10 = String.valueOf(var1_3).length();
            var2_8 += var3_10;
        }
        catch (RuntimeException var1_4) {
            var2_8 = var10_7.size();
            var0_1 = 0;
            while (var0_1 < var2_8) {
                ((CursorWindow)var10_7.get(var0_1)).close();
                ++var0_1;
            }
            throw var1_4;
        }
        var3_11 = new StringBuilder(var2_8);
        var3_11.append("Unsupported object for column ");
        var3_11.append(var4_13);
        var3_11.append(": ");
        var3_11.append((String)var1_3);
        var0 /* !! */  = new IllegalArgumentException(var3_11.toString());
        throw var0 /* !! */ ;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zaf(String string2, int n) {
        Object object;
        Bundle bundle = ((DataHolder)object).zab;
        if (bundle == null || !bundle.containsKey(string2)) {
            object = String.valueOf(string2);
            string2 = "No such column: ";
            object = ((String)object).length() != 0 ? string2.concat((String)object) : new String(string2);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object);
            throw illegalArgumentException;
        }
        if (((DataHolder)object).isClosed()) {
            object = new IllegalArgumentException("Buffer is closed.");
            throw object;
        }
        if (n >= 0 && n < ((DataHolder)object).zad) {
            return;
        }
        string2 = new CursorIndexOutOfBoundsException(n, ((DataHolder)object).zad);
        throw string2;
    }

    public final float zab(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getFloat(n, this.zab.getInt(string2));
    }

    public final double zac(@RecentlyNonNull String string2, int n, int n2) {
        this.zaf(string2, n);
        return this.zag[n2].getDouble(n, this.zab.getInt(string2));
    }

    public final void zad(@RecentlyNonNull String string2, int n, int n2, @RecentlyNonNull CharArrayBuffer charArrayBuffer) {
        this.zaf(string2, n);
        this.zag[n2].copyStringToBuffer(n, this.zab.getInt(string2), charArrayBuffer);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, zab zab2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, zab zab2) {
        this(builder.zaa, DataHolder.zae(builder, -1), n, bundle);
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zaa;
        private final ArrayList<HashMap<String, Object>> zab;
        private final HashMap<Object, Integer> zac;

        @KeepForSdk
        @RecentlyNonNull
        public Builder withRow(@RecentlyNonNull ContentValues object) {
            Asserts.checkNotNull((Object)object);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(object.size());
            for (Map.Entry entry : object.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        @KeepForSdk
        @RecentlyNonNull
        public DataHolder build(int n) {
            DataHolder dataHolder = new DataHolder(this, n, null, null);
            return dataHolder;
        }

        @KeepForSdk
        @RecentlyNonNull
        public DataHolder build(int n, @RecentlyNonNull Bundle bundle) {
            DataHolder dataHolder = new DataHolder(this, n, bundle, -1, null);
            return dataHolder;
        }

        @RecentlyNonNull
        public Builder zaa(@RecentlyNonNull HashMap<String, Object> hashMap) {
            Asserts.checkNotNull(hashMap);
            this.zab.add(hashMap);
            return this;
        }

        static /* synthetic */ ArrayList zac(Builder builder) {
            return builder.zab;
        }

        /* synthetic */ Builder(String[] object, String string2, zab zab2) {
            this.zaa = (String[])Preconditions.checkNotNull((Object)object);
            this.zab = object;
            super();
            this.zac = object;
        }
    }
}

