/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.images.zah;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="WebImageCreator")
public final class WebImage
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<WebImage> CREATOR;
    @SafeParcelable.VersionField(id=1)
    final int zaa;
    @SafeParcelable.Field(id=2, getter="getUrl")
    private final Uri zab;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private final int zac;
    @SafeParcelable.Field(id=4, getter="getHeight")
    private final int zad;

    @SafeParcelable.Constructor
    WebImage(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) int n3) {
        this.zaa = n;
        this.zab = uri;
        this.zac = n2;
        this.zad = n3;
    }

    /*
     * WARNING - void declaration
     */
    public WebImage(@RecentlyNonNull Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, (Uri)var1_3, (int)var2_4, (int)var3_5);
        void var3_5;
        void var2_4;
        void var1_3;
        if (var1_3 == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("url cannot be null");
            throw illegalArgumentException;
        }
        if (var2_4 < 0 || var3_5 < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("width and height must not be negative");
            throw illegalArgumentException;
        }
    }

    public WebImage(@RecentlyNonNull Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public WebImage(@RecentlyNonNull JSONObject jSONObject) throws IllegalArgumentException {
        Uri uri = Uri.EMPTY;
        if (jSONObject.has("url")) {
            try {
                Uri uri2;
                uri = uri2 = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        this(uri, jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    @RecentlyNonNull
    public Uri getUrl() {
        return this.zab;
    }

    public int getWidth() {
        return this.zac;
    }

    public int getHeight() {
        return this.zad;
    }

    @RecentlyNonNull
    public String toString() {
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{this.zac, this.zad, this.zab.toString()};
        return String.format(locale, "Image %dx%d %s", objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @RecentlyNonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zab.toString());
            jSONObject.put("width", this.zac);
            jSONObject.put("height", this.zad);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        object = (WebImage)((Object)object);
        return Objects.equal((Object)this.zab, (Object)((WebImage)((Object)object)).zab) && this.zac == ((WebImage)((Object)object)).zac && this.zad == ((WebImage)((Object)object)).zad;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zab, this.zac, this.zad};
        return Objects.hashCode((Object[])objectArray);
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zaa);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.getUrl(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getWidth());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.getHeight());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    static {
        zah zah2;
        CREATOR = zah2 = new zah();
    }
}

