/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zab;
import com.google.android.gms.common.data.zac;
import com.google.android.gms.common.data.zad;
import com.google.android.gms.common.data.zae;
import com.google.android.gms.common.data.zaf;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.sqlite.CursorWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@KeepName
@SafeParcelable.Class(creator="DataHolderCreator", validate=true)
@KeepForSdk
public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<DataHolder> CREATOR;
    private static final Builder zaf;
    @SafeParcelable.VersionField(id=1000)
    final int zaa;
    @SafeParcelable.Field(id=1, getter="getColumns")
    private final String[] zag;
    Bundle zab;
    @SafeParcelable.Field(id=2, getter="getWindows")
    private final CursorWindow[] zah;
    @SafeParcelable.Field(id=3, getter="getStatusCode")
    private final int zai;
    @SafeParcelable.Field(id=4, getter="getMetadata")
    @Nullable
    private final Bundle zaj;
    int[] zac;
    int zad;
    boolean zae;
    private boolean zak;

    @KeepForSdk
    public int getCount() {
        return this.zad;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int getInteger(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getInt((int)var2_2, this.zab.getInt((String)var1_1));
    }

    @KeepForSdk
    public int getStatusCode() {
        return this.zai;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public int getWindowIndex(int row) {
        int n;
        int n2;
        block2: {
            int[] nArray;
            void var1_2;
            int n3 = row >= 0 ? (var1_2 < this.zad ? 1 : 0) : 0;
            Preconditions.checkState(n3 != 0);
            for (n3 = 0; n3 < (n2 = (nArray = this.zac).length); ++n3) {
                if (var1_2 >= nArray[n3]) continue;
                n = n3 + -1;
                break block2;
            }
            n = n3;
        }
        if (n == n2) {
            return n + -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public long getLong(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1));
    }

    @KeepForSdk
    @Nullable
    public Bundle getMetadata() {
        return this.zaj;
    }

    @KeepForSdk
    @NonNull
    public static Builder builder(@NonNull String[] columns) {
        String[] stringArray;
        Builder builder = new Builder(stringArray, null, null);
        return builder;
    }

    @KeepForSdk
    @NonNull
    public static DataHolder empty(int statusCode) {
        int n;
        DataHolder dataHolder = new DataHolder(zaf, n, null);
        return dataHolder;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public String getString(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getString((int)var2_2, this.zab.getInt((String)var1_1));
    }

    static {
        Object object = new zaf();
        CREATOR = object;
        zaf = object = new zab(new String[0], null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public DataHolder(@NonNull Cursor cursor, int statusCode, @Nullable Bundle metadata) {
        void var3_6;
        void var2_5;
        CursorWindow cursorWindow;
        CursorWrapper cursorWrapper = new CursorWrapper((Cursor)cursorWindow);
        String[] stringArray = cursorWrapper.getColumnNames();
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n;
            int n2;
            int n3 = cursorWrapper.getCount();
            cursorWindow = cursorWrapper.getWindow();
            if (cursorWindow != null) {
                n2 = cursorWindow.getStartPosition();
                if (n2 == 0) {
                    cursorWindow.acquireReference();
                    cursorWrapper.setWindow(null);
                    arrayList.add(cursorWindow);
                    n = cursorWindow.getNumRows();
                } else {
                    n = 0;
                }
            } else {
                n = 0;
            }
            while (n < n3 && (n2 = (int)(cursorWrapper.moveToPosition(n) ? 1 : 0)) != 0) {
                CursorWindow cursorWindow2;
                CursorWindow cursorWindow3 = cursorWrapper.getWindow();
                if (cursorWindow3 != null) {
                    cursorWindow3.acquireReference();
                    cursorWrapper.setWindow(null);
                    cursorWindow2 = cursorWindow3;
                } else {
                    cursorWindow3 = new CursorWindow(false);
                    cursorWindow3.setStartPosition(n);
                    cursorWrapper.fillWindow(n, cursorWindow3);
                    cursorWindow2 = cursorWindow3;
                }
                if ((n2 = cursorWindow2.getNumRows()) != 0) {
                    arrayList.add(cursorWindow2);
                    n2 = cursorWindow2.getStartPosition();
                    n = cursorWindow2.getNumRows();
                    n = n2 + n;
                    continue;
                }
                break;
            }
        }
        finally {
            cursorWrapper.close();
        }
        this(stringArray, arrayList.toArray(new CursorWindow[arrayList.size()]), (int)var2_5, (Bundle)var3_6);
    }

    private DataHolder(Builder builder, int n, @Nullable Bundle bundle) {
        this(builder.zaa, DataHolder.zaf(builder, -1), n, null);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public DataHolder(@NonNull String[] columns, @NonNull CursorWindow[] windows, int statusCode, @Nullable Bundle metadata) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae = false;
        this.zak = true;
        this.zaa = 1;
        this.zag = (String[])Preconditions.checkNotNull((Object)var1_1);
        this.zah = (CursorWindow[])Preconditions.checkNotNull((Object)var2_2);
        this.zai = var3_3;
        this.zaj = var4_4;
        this.zad();
    }

    @SafeParcelable.Constructor
    DataHolder(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String[] stringArray, @SafeParcelable.Param(id=2) CursorWindow[] cursorWindowArray, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) @Nullable Bundle bundle) {
        this.zae = false;
        this.zak = true;
        this.zaa = n;
        this.zag = stringArray;
        this.zah = cursorWindowArray;
        this.zai = n2;
        this.zaj = bundle;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @KeepForSdk
    public void close() {
        synchronized (this) {
            CursorWindow[] cursorWindowArray;
            int n;
            int n2 = this.zae;
            if (n2 != 0) return;
            this.zae = true;
            for (n2 = 0; n2 < (n = (cursorWindowArray = this.zah).length); ++n2) {
                cursorWindowArray[n2].close();
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        block7: {
            int n = this.zak;
            if (n == 0) break block7;
            n = this.zah.length;
            if (n <= 0) break block7;
            n = this.isClosed() ? 1 : 0;
            if (n != 0) break block7;
            try {
                this.close();
                String string2 = "DataBuffer";
                String string3 = this.toString();
                int n2 = String.valueOf(string3).length();
                StringBuilder stringBuilder = new StringBuilder(n2 += 178);
                stringBuilder.append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ");
                stringBuilder.append(string3);
                stringBuilder.append(")");
                Log.e((String)string2, (String)stringBuilder.toString());
            }
            finally {
                super.finalize();
            }
        }
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringArray((Parcel)parcel, (int)1, (String[])this.zag, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.zah, (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getStatusCode());
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)4, (Bundle)this.getMetadata(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1000, (int)this.zaa);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        if ((n & 1) != 0) {
            this.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean getBoolean(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return Long.valueOf(this.zah[var3_3].getLong((int)var2_2, this.zab.getInt((String)var1_1))) == 1L;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasColumn(@NonNull String column) {
        void var1_1;
        return this.zab.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean hasNull(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].isNull((int)var2_2, this.zab.getInt((String)var1_1));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isClosed() {
        synchronized (this) {
            return this.zae;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public byte[] getByteArray(@NonNull String column, int row, int windowIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zae((String)var1_1, (int)var2_2);
        return this.zah[var3_3].getBlob((int)var2_2, this.zab.getInt((String)var1_1));
    }

    public final double zaa(@NonNull String string2, int n, int n2) {
        this.zae(string2, n);
        return this.zah[n2].getDouble(n, this.zab.getInt(string2));
    }

    public final float zab(@NonNull String string2, int n, int n2) {
        this.zae(string2, n);
        return this.zah[n2].getFloat(n, this.zab.getInt(string2));
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, zae zae2) {
        this(builder, n, null);
    }

    /* synthetic */ DataHolder(Builder builder, int n, Bundle bundle, int n2, zae zae2) {
        this(builder.zaa, DataHolder.zaf(builder, -1), n, bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zae(String string2, int n) {
        Object object;
        Bundle bundle = ((DataHolder)object).zab;
        if (bundle == null || !bundle.containsKey(string2)) {
            object = String.valueOf(string2);
            string2 = "No such column: ";
            object = ((String)object).length() != 0 ? string2.concat((String)object) : new String(string2);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object);
            throw illegalArgumentException;
        }
        if (((DataHolder)object).isClosed()) {
            object = new IllegalArgumentException("Buffer is closed.");
            throw object;
        }
        if (n >= 0 && n < ((DataHolder)object).zad) {
            return;
        }
        string2 = new CursorIndexOutOfBoundsException(n, ((DataHolder)object).zad);
        throw string2;
    }

    public final void zac(@NonNull String string2, int n, int n2, @NonNull CharArrayBuffer charArrayBuffer) {
        this.zae(string2, n);
        this.zah[n2].copyStringToBuffer(n, this.zab.getInt(string2), charArrayBuffer);
    }

    public final void zad() {
        CursorWindow cursorWindow;
        String[] stringArray;
        int n;
        Bundle bundle;
        this.zab = bundle = new Bundle();
        for (n = 0; n < (stringArray = this.zag).length; ++n) {
            this.zab.putInt(stringArray[n], n);
        }
        this.zac = new int[this.zah.length];
        n = 0;
        for (int i = 0; i < ((CursorWindow[])(cursorWindow = this.zah)).length; ++i) {
            this.zac[i] = n;
            cursorWindow = cursorWindow[i];
            int n2 = cursorWindow.getStartPosition();
            n += this.zah[i].getNumRows() - (n - n2);
        }
        this.zad = n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static CursorWindow[] zaf(Builder var0, int var1_2) {
        if (Builder.zac((Builder)var0 /* !! */ ).length == 0) {
            return new CursorWindow[0];
        }
        var8_5 = Builder.zab((Builder)var0 /* !! */ );
        var9_6 = var8_5.size();
        var1_3 = new CursorWindow(false);
        var10_7 = new ArrayList<Object>();
        var10_7.add(var1_3);
        var1_3.setNumColumns(Builder.zac((Builder)var0 /* !! */ ).length);
        var2_8 = 0;
        var3_10 = 0;
        while (var3_10 < var9_6) {
            var4_12 = var1_3.allocRow();
            if (var4_12 == 0) {
                var1_3 = new StringBuilder(72);
                var1_3.append("Allocating additional cursor window for large data set (row ");
                var1_3.append(var3_10);
                var1_3.append(")");
                Log.d((String)"DataHolder", (String)var1_3.toString());
                var1_3 = new CursorWindow(false);
                var1_3.setStartPosition(var3_10);
                var1_3.setNumColumns(Builder.zac((Builder)var0 /* !! */ ).length);
                var10_7.add(var1_3);
                var4_12 = (int)var1_3.allocRow();
                if (var4_12 == 0) {
                    Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                    var10_7.remove(var1_3);
                    return var10_7.toArray(new CursorWindow[var10_7.size()]);
                }
            }
            var11_20 = (Map)var8_5.get(var3_10);
            var4_12 = 1;
            for (var5_15 = 0; var5_15 < (var6_16 = Builder.zac((Builder)var0 /* !! */ ).length); ++var5_15) {
                if (var4_12 != 0) {
                    var4_13 = Builder.zac((Builder)var0 /* !! */ )[var5_15];
                    var6_17 = var11_20.get(var4_13);
                    if (var6_17 == null) {
                        var4_12 = (int)var1_3.putNull(var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof String;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putString((String)var6_17, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Long;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putLong(((Long)var6_17).longValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Integer;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putLong((long)((Integer)var6_17).intValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Boolean;
                    if (var7_19) {
                        var4_12 = (int)((Boolean)var6_17).booleanValue();
                        var6_18 = 1 != var4_12 ? 0L : 1L;
                        var4_12 = (int)var1_3.putLong(var6_18, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof byte[];
                    if (var7_19) {
                        var4_12 = (int)var1_3.putBlob((byte[])var6_17, var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Double;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putDouble(((Double)var6_17).doubleValue(), var3_10, var5_15);
                        continue;
                    }
                    var7_19 = var6_17 instanceof Float;
                    if (var7_19) {
                        var4_12 = (int)var1_3.putDouble((double)((Float)var6_17).floatValue(), var3_10, var5_15);
                        continue;
                    }
                    ** break block24
                }
                ** GOTO lbl-1000
            }
            if (var4_12 != 0) {
                var2_8 = 0;
                var4_12 = var3_10;
            } else lbl-1000:
            // 2 sources

            {
                if (var2_8 != 0) {
                    var0 /* !! */  = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                    var1_3 = new zad((String)var0 /* !! */ );
                    throw var1_3;
                }
                var2_9 = new StringBuilder(74);
                var2_9.append("Couldn't populate window data for row ");
                var2_9.append(var3_10);
                var2_9.append(" - allocating new window.");
                Log.d((String)"DataHolder", (String)var2_9.toString());
                var1_3.freeLastRow();
                var1_3 = new CursorWindow(false);
                var1_3.setStartPosition(var3_10);
                var1_3.setNumColumns(Builder.zac((Builder)var0 /* !! */ ).length);
                var10_7.add(var1_3);
                var4_12 = var3_10 + -1;
                var2_8 = 1;
            }
            var3_10 = var4_12 + 1;
        }
        return var10_7.toArray(new CursorWindow[var10_7.size()]);
lbl-1000:
        // 1 sources

        {
            var1_3 = var6_17.toString();
            var2_8 = String.valueOf(var4_13).length();
            var2_8 += 32;
        }
        try {
            var3_10 = var1_3.length();
            var2_8 += var3_10;
        }
        catch (RuntimeException var1_4) {
            var2_8 = var10_7.size();
            var0_1 = 0;
            while (var0_1 < var2_8) {
                ((CursorWindow)var10_7.get(var0_1)).close();
                ++var0_1;
            }
            throw var1_4;
        }
        var3_11 = new StringBuilder(var2_8);
        var3_11.append("Unsupported object for column ");
        var3_11.append(var4_13);
        var3_11.append(": ");
        var3_11.append((String)var1_3);
        var0 /* !! */  = new IllegalArgumentException(var3_11.toString());
        throw var0 /* !! */ ;
    }

    @KeepForSdk
    public static class Builder {
        private final String[] zaa;
        private final ArrayList<HashMap<String, Object>> zab;
        private final HashMap<Object, Integer> zac;

        @KeepForSdk
        @NonNull
        public Builder withRow(@NonNull ContentValues values) {
            Iterator iterator;
            Asserts.checkNotNull((Object)values);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(iterator.size());
            for (Map.Entry entry : iterator.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zaa(hashMap);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode) {
            void var1_1;
            DataHolder dataHolder = new DataHolder(this, (int)var1_1, null, null);
            return dataHolder;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public DataHolder build(int statusCode, @NonNull Bundle metadata) {
            void var2_2;
            void var1_1;
            DataHolder dataHolder = new DataHolder(this, (int)var1_1, (Bundle)var2_2, -1, null);
            return dataHolder;
        }

        @NonNull
        public Builder zaa(@NonNull HashMap<String, Object> hashMap) {
            Asserts.checkNotNull(hashMap);
            this.zab.add(hashMap);
            return this;
        }

        static /* bridge */ /* synthetic */ ArrayList zab(Builder builder) {
            return builder.zab;
        }

        /* synthetic */ Builder(String[] object, String string2, zac zac2) {
            this.zaa = (String[])Preconditions.checkNotNull((Object)object);
            this.zab = object;
            super();
            this.zac = object;
        }
    }
}

