/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;

@KeepName
public class GoogleApiActivity
extends Activity
implements DialogInterface.OnCancelListener {
    @VisibleForTesting
    protected int zaa = 0;

    /*
     * Enabled aggressive block sorting
     */
    protected final void onActivityResult(int n, int n2, @NonNull Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 1) {
            Intent intent2 = this.getIntent();
            boolean bl = intent2.getBooleanExtra("notify_manager", true);
            this.zaa = 0;
            this.setResult(n2, intent);
            if (bl) {
                GoogleApiManager googleApiManager = GoogleApiManager.zam((Context)this);
                switch (n2) {
                    case 0: {
                        ConnectionResult connectionResult = new ConnectionResult(13, null);
                        googleApiManager.zaz(connectionResult, this.getIntent().getIntExtra("failing_client_id", -1));
                    }
                    default: {
                        break;
                    }
                    case -1: {
                        googleApiManager.zaA();
                        break;
                    }
                }
            }
        } else if (n == 2) {
            this.zaa = 0;
            this.setResult(n2, intent);
        }
        this.finish();
    }

    public final void onCancel(@NonNull DialogInterface dialogInterface) {
        this.zaa = 0;
        this.setResult(0);
        this.finish();
    }

    protected final void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zaa = bundle.getInt("resolution");
        }
        if (this.zaa != 1) {
            this.zab();
            return;
        }
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        bundle.putInt("resolution", this.zaa);
        super.onSaveInstanceState(bundle);
    }

    @NonNull
    public static Intent zaa(@NonNull Context context, @NonNull PendingIntent pendingIntent, int n, boolean bl) {
        Intent intent = new Intent(context, GoogleApiActivity.class);
        intent.putExtra("pending_intent", (Parcelable)pendingIntent);
        intent.putExtra("failing_client_id", n);
        intent.putExtra("notify_manager", bl);
        return intent;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zab() {
        Object object = this.getIntent().getExtras();
        if (object == null) {
            Log.e((String)"GoogleApiActivity", (String)"Activity started without extras");
            this.finish();
            return;
        }
        Object object2 = (PendingIntent)object.get("pending_intent");
        Integer n = (Integer)object.get("error_code");
        if (object2 == null && n == null) {
            Log.e((String)"GoogleApiActivity", (String)"Activity started without resolution");
            this.finish();
            return;
        }
        if (object2 == null) {
            object = Preconditions.checkNotNull((Object)n);
            object = (Integer)object;
            int n2 = (Integer)object;
            GoogleApiAvailability.getInstance().showErrorDialogFragment(this, n2, 2, this);
            this.zaa = 1;
            return;
        }
        try {
            this.startIntentSenderForResult(object2.getIntentSender(), 1, null, 0, 0, 0);
            this.zaa = 1;
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            block8: {
                block7: {
                    if (!object.getBoolean("notify_manager", true)) break block7;
                    object = GoogleApiManager.zam((Context)this);
                    object2 = new ConnectionResult(22, null);
                    ((GoogleApiManager)object).zaz((ConnectionResult)object2, this.getIntent().getIntExtra("failing_client_id", -1));
                    break block8;
                    catch (IntentSender.SendIntentException sendIntentException) {
                        Log.e((String)"GoogleApiActivity", (String)"Failed to launch pendingIntent", (Throwable)sendIntentException);
                        this.finish();
                        return;
                    }
                }
                object = object2.toString();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Activity not found while launching ");
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(".");
                object = ((StringBuilder)object2).toString();
                if (Build.FINGERPRINT.contains("generic")) {
                    object = ((String)object).concat(" This may occur when resolving Google Play services connection issues on emulators with Google APIs but not Google Play Store.");
                }
                Log.e((String)"GoogleApiActivity", (String)object, (Throwable)activityNotFoundException);
            }
            this.zaa = 1;
            this.finish();
            return;
        }
    }
}

