/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zaa;
import com.google.android.gms.common.images.zab;
import com.google.android.gms.common.images.zae;
import com.google.android.gms.common.images.zaf;
import com.google.android.gms.common.images.zag;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.internal.base.zam;
import com.google.android.gms.internal.base.zat;
import com.google.android.gms.internal.base.zau;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ImageManager {
    private static final Object zaa = new Object();
    private static final HashSet zab = new HashSet();
    private static ImageManager zac;
    private final Context zad;
    private final Handler zae;
    private final ExecutorService zaf;
    private final zam zag;
    private final Map zah;
    private final Map zai;
    private final Map zaj;

    @NonNull
    public static ImageManager create(@NonNull Context context) {
        if (zac == null) {
            Context context2;
            zac = new ImageManager(context2, false);
        }
        return zac;
    }

    private ImageManager(Context context, boolean bl) {
        this.zad = context.getApplicationContext();
        this.zae = new zau(Looper.getMainLooper());
        this.zaf = zat.zaa().zab(4, 2);
        this.zag = new zam();
        this.zah = new HashMap();
        this.zai = new HashMap();
        this.zaj = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, int resId) {
        void var2_2;
        void var1_1;
        this.zaj(new zae((ImageView)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        this.zaj(new zae((ImageView)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener, @NonNull Uri uri) {
        void var2_2;
        void var1_1;
        this.zaj(new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull ImageView imageView, @NonNull Uri uri, int defaultResId) {
        void var2_2;
        void var1_1;
        void var3_3;
        new zae((ImageView)var1_1, (Uri)var2_2).zab = var3_3;
        this.zaj(new zae((ImageView)var1_1, (Uri)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void loadImage(@NonNull OnImageLoadedListener listener, @NonNull Uri uri, int defaultResId) {
        void var2_2;
        void var1_1;
        void var3_3;
        new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2).zab = var3_3;
        this.zaj(new zaf((OnImageLoadedListener)var1_1, (Uri)var2_2));
    }

    static /* bridge */ /* synthetic */ Handler zab(ImageManager imageManager) {
        return imageManager.zae;
    }

    static /* bridge */ /* synthetic */ zam zac(ImageManager imageManager) {
        return imageManager.zag;
    }

    static /* bridge */ /* synthetic */ Object zad() {
        return zaa;
    }

    static /* bridge */ /* synthetic */ HashSet zae() {
        return zab;
    }

    static /* bridge */ /* synthetic */ Map zaf(ImageManager imageManager) {
        return imageManager.zaj;
    }

    static /* bridge */ /* synthetic */ Map zag(ImageManager imageManager) {
        return imageManager.zah;
    }

    static /* bridge */ /* synthetic */ Map zah(ImageManager imageManager) {
        return imageManager.zai;
    }

    public final void zaj(zag zag2) {
        Asserts.checkMainThread((String)"ImageManager.loadImage() must be called in the main thread");
        new zab(this, zag2).run();
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(@NonNull Uri var1, @Nullable Drawable var2, boolean var3);
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri zab;
        private final ArrayList zac;

        ImageReceiver(Uri uri) {
            super((Handler)new zau(Looper.getMainLooper()));
            this.zab = uri;
            this.zac = new ArrayList();
        }

        public final void onReceiveResult(int n, Bundle object) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)object.getParcelable("com.google.android.gms.extra.fileDescriptor");
            object = imageReceiver.ImageManager.this;
            ImageReceiver imageReceiver = imageReceiver.zab;
            ((ImageManager)object).zaf.execute(new zaa((ImageManager)object, (Uri)imageReceiver, parcelFileDescriptor));
        }

        static /* bridge */ /* synthetic */ ArrayList zaa(ImageReceiver imageReceiver) {
            return imageReceiver.zac;
        }

        public final void zab(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zac.add(zag2);
        }

        public final void zac(zag zag2) {
            Asserts.checkMainThread((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zac.remove(zag2);
        }

        public final void zad() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.setPackage("com.google.android.gms");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.zab);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.zad.sendBroadcast(intent);
        }
    }
}

