/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.SingleRefDataBufferIterator;
import java.io.Closeable;
import java.util.Iterator;

public abstract class AbstractDataBuffer<T>
implements DataBuffer<T> {
    @Nullable
    @KeepForSdk
    protected final DataHolder mDataHolder;

    @Override
    public int getCount() {
        Closeable this_ = ((AbstractDataBuffer)this_).mDataHolder;
        if (this_ == null) {
            return 0;
        }
        return ((DataHolder)this_).getCount();
    }

    @Override
    @Nullable
    public final Bundle getMetadata() {
        Closeable closeable = ((AbstractDataBuffer)closeable).mDataHolder;
        if (closeable == null) {
            return null;
        }
        return ((DataHolder)closeable).getMetadata();
    }

    @Override
    @NonNull
    public abstract T get(int var1);

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    @NonNull
    public Iterator<T> singleRefIterator() {
        return new SingleRefDataBufferIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected AbstractDataBuffer(@Nullable DataHolder dataHolder) {
        void var1_1;
        this.mDataHolder = var1_1;
    }

    @Override
    public final void close() {
        this.release();
    }

    @Override
    public void release() {
        Closeable this_ = ((AbstractDataBuffer)this_).mDataHolder;
        if (this_ != null) {
            ((DataHolder)this_).close();
            return;
        }
    }

    @Override
    @Deprecated
    public boolean isClosed() {
        Closeable this_ = ((AbstractDataBuffer)this_).mDataHolder;
        return this_ == null || ((DataHolder)this_).isClosed();
    }
}

