/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.FragmentManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.IntentSenderRequest;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.base.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zaca;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zag;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.zaa;
import com.google.android.gms.common.zab;
import com.google.android.gms.common.zac;
import com.google.android.gms.common.zad;
import com.google.android.gms.internal.base.zal;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;

public class GoogleApiAvailability
extends GoogleApiAvailabilityLight {
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    private static final Object zaa;
    private static final GoogleApiAvailability zab;
    @GuardedBy(value="lock")
    private String zac;

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@NonNull Context context) {
        void var1_1;
        return super.getClientVersion((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @HideFirstParty
    public int isGooglePlayServicesAvailable(@NonNull Context context) {
        void var1_1;
        return super.isGooglePlayServicesAvailable((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        void var2_2;
        void var1_1;
        return super.isGooglePlayServicesAvailable((Context)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Activity activity, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorDialog((Activity)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Fragment fragment, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorDialog((Fragment)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Activity activity, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        GoogleApiAvailability googleApiAvailability = this;
        void v1 = var1_1;
        return googleApiAvailability.zaa((Context)v1, errorCode, zag.zab((Activity)v1, googleApiAvailability.getErrorResolutionIntent((Context)v1, (int)var2_2, "d"), (int)var3_3), (DialogInterface.OnCancelListener)var4_4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Dialog getErrorDialog(@NonNull Fragment fragment, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        String string2 = "d";
        string2 = this.getErrorResolutionIntent(var1_1.requireContext(), (int)var2_2, string2);
        return this.zaa(var1_1.requireContext(), (int)var2_2, zag.zac((Fragment)var1_1, (Intent)string2, (int)var3_3), (DialogInterface.OnCancelListener)var4_4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, @NonNull ConnectionResult result) {
        void var1_1;
        void var2_2;
        if (result.hasResolution()) {
            return var2_2.getResolution();
        }
        return this.getErrorResolutionPendingIntent((Context)var1_1, var2_2.getErrorCode(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int errorCode, @Nullable String trackingSource) {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.getErrorResolutionIntent((Context)var1_1, (int)var2_2, (String)var3_3);
    }

    @NonNull
    public static GoogleApiAvailability getInstance() {
        return zab;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> checkApiAvailability(@NonNull GoogleApi<?> api, GoogleApi<?> ... apis) {
        void var2_2;
        return GoogleApiAvailability.zai(api, (HasApiKey[])var2_2).onSuccessTask((SuccessContinuation)new zab());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> checkApiAvailability(@NonNull HasApiKey<?> api, HasApiKey<?> ... apis) {
        void var2_2;
        return GoogleApiAvailability.zai(api, (HasApiKey[])var2_2).onSuccessTask((SuccessContinuation)new zaa());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @MainThread
    @NonNull
    public Task<Void> makeGooglePlayServicesAvailable(@NonNull Activity activity) {
        void var1_3;
        String string2 = "makeGooglePlayServicesAvailable must be called from the main thread";
        Preconditions.checkMainThread((String)string2);
        int n = this.isGooglePlayServicesAvailable((Context)var1_3, GOOGLE_PLAY_SERVICES_VERSION_CODE);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zaca zaca2 = zaca.zaa((Activity)var1_3);
        zaca2.zah(new ConnectionResult(n, null), 0);
        return zaca2.zad();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final String getErrorString(int errorCode) {
        void var1_1;
        return super.getErrorString((int)var1_1);
    }

    static {
        zaa = new Object();
        zab = new GoogleApiAvailability();
        GOOGLE_PLAY_SERVICES_VERSION_CODE = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public void setDefaultNotificationChannelId(@NonNull Context context, @NonNull String notificationChannelId) {
        void var2_3;
        Object object;
        if (PlatformVersion.isAtLeastO()) {
            Preconditions.checkNotNull((Object)((NotificationManager)Preconditions.checkNotNull((Object)object.getSystemService("notification"))).getNotificationChannel((String)var2_3));
        }
        object = zaa;
        synchronized (object) {
            this.zac = var2_3;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void showErrorNotification(@NonNull Context context, int errorCode) {
        void var2_2;
        void var1_1;
        this.zae((Context)var1_1, (int)var2_2, null, this.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, 0, "n"));
    }

    /*
     * WARNING - void declaration
     */
    public void showErrorNotification(@NonNull Context context, @NonNull ConnectionResult result) {
        void var2_2;
        void var1_1;
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent((Context)var1_1, (ConnectionResult)var2_2);
        this.zae((Context)var1_1, var2_2.getErrorCode(), null, pendingIntent);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isUserResolvableError(int errorCode) {
        void var1_1;
        return super.isUserResolvableError((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean showErrorDialogFragment(@NonNull Activity activity, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.showErrorDialogFragment((Activity)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean showErrorDialogFragment(@NonNull Activity activity, int errorCode, int requestCode, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var4_5;
        void var3_4;
        void var2_2;
        void var1_1;
        Dialog dialog = this.getErrorDialog((Activity)var1_1, (int)var2_2, (int)var3_4, (DialogInterface.OnCancelListener)var4_5);
        if (dialog == null) {
            return false;
        }
        this.zad((Activity)var1_1, dialog, "GooglePlayServicesErrorDialog", (DialogInterface.OnCancelListener)var4_5);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean showErrorDialogFragment(@NonNull Activity activity, int errorCode, @NonNull ActivityResultLauncher<IntentSenderRequest> activityResultLauncher, @Nullable DialogInterface.OnCancelListener cancelListener) {
        void var3_4;
        void var4_5;
        void var2_2;
        void var1_1;
        Dialog dialog = this.zaa((Context)var1_1, (int)var2_2, null, (DialogInterface.OnCancelListener)var4_5, new zac(this, (Activity)var1_1, (int)var2_2, (ActivityResultLauncher)var3_4));
        if (dialog == null) {
            return false;
        }
        this.zad((Activity)var1_1, dialog, "GooglePlayServicesErrorDialog", (DialogInterface.OnCancelListener)var4_5);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    final Dialog zaa(@NonNull Context object, int n, @Nullable zag zag2, @Nullable DialogInterface.OnCancelListener object2, @Nullable DialogInterface.OnClickListener onClickListener) {
        String string2;
        String string3;
        void var4_15;
        void var0_6;
        void var0_4;
        void var1_8;
        void var2_12;
        if (var2_12 == false) {
            return null;
        }
        TypedValue typedValue = new TypedValue();
        var1_8.getTheme().resolveAttribute(16843529, typedValue, true);
        String string4 = var1_8.getResources().getResourceEntryName(typedValue.resourceId);
        if ("Theme.Dialog.Alert".equals(string4)) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)var1_8, 5);
        } else {
            Object var0_7 = null;
        }
        if (var0_4 == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)var1_8);
        }
        var0_6.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zac((Context)var1_8, (int)var2_12));
        if (var4_15 != null) {
            var0_6.setOnCancelListener((DialogInterface.OnCancelListener)var4_15);
        }
        if ((string3 = com.google.android.gms.common.internal.zac.zab((Context)var1_8, (int)var2_12)) != null) {
            void var3_14;
            if (var3_14 == null) {
                void var5_17;
                var3_14 = var5_17;
            }
            var0_6.setPositiveButton((CharSequence)string3, (DialogInterface.OnClickListener)var3_14);
        }
        if ((string2 = com.google.android.gms.common.internal.zac.zaf((Context)var1_8, (int)var2_12)) != null) {
            var0_6.setTitle((CharSequence)string2);
        }
        Object[] objectArray = new Object[]{(int)var2_12};
        String string5 = String.format("Creating dialog for Google Play services availability issue. ConnectionResult=%s", objectArray);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
        Log.w((String)"GoogleApiAvailability", (String)string5, (Throwable)illegalArgumentException);
        return var0_6.create();
    }

    @NonNull
    public final Dialog zab(@NonNull Activity activity, @NonNull DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        Activity activity2 = activity;
        builder.setMessage((CharSequence)com.google.android.gms.common.internal.zac.zac((Context)activity2, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        this.zad(activity2, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public final zabv zac(Context context, zabu zabu2) {
        zabv zabv2;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zabv zabv3 = zabv2;
        zabv3(zabu2);
        ContextCompat.registerReceiver((Context)context, (BroadcastReceiver)zabv3, (IntentFilter)intentFilter, (int)2);
        zabv2.zaa(context);
        if (!this.isUninstalledAppPossiblyUpdating(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zabu2.zaa();
            zabv2.zab();
            return null;
        }
        return zabv2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zad(Activity activity, Dialog dialog, String string2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        block2: {
            try {
                boolean bl = activity instanceof FragmentActivity;
                if (!bl) break block2;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                break block2;
            }
            androidx.fragment.app.FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
            return;
        }
        FragmentManager fragmentManager = activity.getFragmentManager();
        ErrorDialogFragment.newInstance(dialog, onCancelListener).show(fragmentManager, string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TargetApi(value=20)
    final void zae(Context object, int n, @Nullable String object2, @Nullable PendingIntent pendingIntent) {
        int n2;
        object2 = new Object[]{n, null};
        object2 = String.format("GMS core API Availability. ConnectionResult=%s, tag=%s", object2);
        Object object3 = new IllegalArgumentException();
        Log.w((String)"GoogleApiAvailability", (String)object2, (Throwable)object3);
        if (n == 18) {
            object5.zaf((Context)object);
            return;
        }
        if (pendingIntent == null) {
            if (n != 6) return;
            Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            return;
        }
        object2 = com.google.android.gms.common.internal.zac.zae((Context)object, n);
        object3 = com.google.android.gms.common.internal.zac.zad((Context)object, n);
        Resources resources = object.getResources();
        NotificationManager notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)object.getSystemService("notification"));
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)object).setLocalOnly(true).setAutoCancel(true).setContentTitle((CharSequence)object2).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)object3));
        if (DeviceProperties.isWearable((Context)object)) {
            Preconditions.checkState((boolean)PlatformVersion.isAtLeastKitKatWatch());
            int n3 = object.getApplicationInfo().icon;
            if (n3 == 0) {
                n3 = 17301642;
            }
            builder.setSmallIcon(n3).setPriority(2);
            if (DeviceProperties.isWearableWithoutPlayStore((Context)object)) {
                builder.addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            } else {
                builder.setContentIntent(pendingIntent);
            }
        } else {
            builder.setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setContentIntent(pendingIntent).setContentText((CharSequence)object3);
        }
        if (PlatformVersion.isAtLeastO()) {
            block19: {
                Preconditions.checkState((boolean)PlatformVersion.isAtLeastO());
                Object object4 = zaa;
                // MONITORENTER : object4
                Object object5 = object5.zac;
                // MONITOREXIT : object4
                if (object5 != null) break block19;
                object5 = "com.google.android.gms.availability";
                object4 = notificationManager.getNotificationChannel((String)object5);
                object = object.getResources().getString(R.string.common_google_play_services_notification_channel_name);
                if (object4 == null) {
                    notificationManager.createNotificationChannel(new NotificationChannel((String)object5, (CharSequence)object, 4));
                } else if (!((String)object).contentEquals(object4.getName())) {
                    object4.setName((CharSequence)object);
                    notificationManager.createNotificationChannel((NotificationChannel)object4);
                }
            }
            builder.setChannelId((String)object5);
        }
        object = builder.build();
        switch (n) {
            default: {
                n2 = 39789;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                GooglePlayServicesUtilLight.sCanceledAvailabilityNotification.set(false);
                n2 = 10436;
            }
        }
        notificationManager.notify(n2, (Notification)object);
        return;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object4
                throw throwable;
            }
        }
    }

    final void zaf(Context context) {
        new zad(this, context).sendEmptyMessageDelayed(1, 120000L);
    }

    public final boolean zag(@NonNull Activity activity, @NonNull LifecycleFragment lifecycleFragment, int n, int n2, @Nullable DialogInterface.OnCancelListener onCancelListener) {
        if ((lifecycleFragment = this.zaa((Context)activity, n, zag.zad(lifecycleFragment, this.getErrorResolutionIntent((Context)activity, n, "d"), 2), onCancelListener, null)) == null) {
            return false;
        }
        this.zad(activity, (Dialog)lifecycleFragment, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zah(@NonNull Context context, @NonNull ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent;
        if (InstantApps.isInstantApp((Context)context) || (pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult)) == null) {
            return false;
        }
        Context context2 = context;
        this.zae(context, connectionResult.getErrorCode(), null, PendingIntent.getActivity((Context)context2, (int)0, (Intent)GoogleApiActivity.zaa(context2, pendingIntent, n, true), (int)(zal.zaa | 0x8000000)));
        return true;
    }

    @NonNull
    public static final Task zai(@NonNull HasApiKey hasApiKey, HasApiKey ... hasApiKeyArray) {
        Preconditions.checkNotNull((Object)hasApiKey, (Object)"Requested API must not be null.");
        int n = hasApiKeyArray.length;
        for (int i = 0; i < n; ++i) {
            Preconditions.checkNotNull((Object)hasApiKeyArray[i], (Object)"Requested API must not be null.");
        }
        ArrayList<HasApiKey> arrayList = new ArrayList<HasApiKey>(hasApiKeyArray.length + 1);
        arrayList.add(hasApiKey);
        arrayList.addAll(Arrays.asList(hasApiKeyArray));
        return GoogleApiManager.zaj().zam(arrayList);
    }
}

