/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.NonGmsServiceBrokerClient;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zabo;
import com.google.android.gms.common.api.internal.zabt;
import com.google.android.gms.common.api.internal.zacq;
import com.google.android.gms.common.api.zad;
import com.google.android.gms.common.api.zae;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.AttributionSourceWrapper;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context zab;
    @Nullable
    private final String zac;
    @Nullable
    private final AttributionSourceWrapper zad;
    private final Api zae;
    private final Api.ApiOptions zaf;
    private final ApiKey zag;
    private final Looper zah;
    private final int zai;
    private final GoogleApiClient zaj;
    private final StatusExceptionMapper zak;
    @NonNull
    protected final GoogleApiManager zaa;

    @KeepForSdk
    @NonNull
    public Context getApplicationContext() {
        return this.zab;
    }

    @KeepForSdk
    @NonNull
    public Looper getLooper() {
        return this.zah;
    }

    @KeepForSdk
    @NonNull
    public O getApiOptions() {
        return (O)this.zaf;
    }

    @KeepForSdk
    @NonNull
    public GoogleApiClient asGoogleApiClient() {
        return this.zaj;
    }

    @Override
    @NonNull
    public final ApiKey<O> getApiKey() {
        return this.zag;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(2, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@NonNull T methodImpl) {
        void var1_1;
        this.zad(0, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(1, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <L> ListenerHolder<L> registerListener(@NonNull L listener, @NonNull String listenerType) {
        void var2_2;
        return ListenerHolders.createListenerHolder(listener, this.zah, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    protected ClientSettings.Builder createClientSettingsBuilder() {
        void var1_9;
        void var1_5;
        GoogleSignInAccount googleSignInAccount;
        ClientSettings.Builder builder = new ClientSettings.Builder();
        Api.ApiOptions apiOptions = this.zaf;
        if (apiOptions instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions).getGoogleSignInAccount()) != null) {
            Account account = googleSignInAccount.getAccount();
        } else {
            Api.ApiOptions apiOptions2 = this.zaf;
            if (apiOptions2 instanceof Api.ApiOptions.HasAccountOptions) {
                Account account = ((Api.ApiOptions.HasAccountOptions)apiOptions2).getAccount();
            } else {
                Object var1_15 = null;
            }
        }
        builder.zab((Account)var1_5);
        Api.ApiOptions apiOptions3 = this.zaf;
        if (apiOptions3 instanceof Api.ApiOptions.HasGoogleSignInAccountOptions) {
            GoogleSignInAccount googleSignInAccount2 = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions3).getGoogleSignInAccount();
            if (googleSignInAccount2 == null) {
                Set set = Collections.emptySet();
            } else {
                Set<Scope> set = googleSignInAccount2.getRequestedScopes();
            }
        } else {
            Set set = Collections.emptySet();
        }
        builder.zaa((Collection)var1_9);
        builder.zac(this.zab.getClass().getName());
        builder.setRealClientPackageName(this.zab.getPackageName());
        return builder;
    }

    @KeepForSdk
    @NonNull
    protected Task<Boolean> disconnectService() {
        return this.zaa.zan(this);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(2, (TaskApiCall)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(0, (TaskApiCall)var1_1);
    }

    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@NonNull RegistrationMethods<A, ?> methods) {
        Runnable runnable;
        Preconditions.checkNotNull(methods);
        Preconditions.checkNotNull(((RegistrationMethods)((Object)runnable)).register.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(((RegistrationMethods)((Object)runnable)).zaa.getListenerKey(), (Object)"Listener has already been released.");
        RegisterListenerMethod registerListenerMethod = ((RegistrationMethods)((Object)runnable)).register;
        UnregisterListenerMethod unregisterListenerMethod = ((RegistrationMethods)((Object)runnable)).zaa;
        runnable = ((RegistrationMethods)((Object)runnable)).zab;
        return this.zaa.zao(this, registerListenerMethod, unregisterListenerMethod, runnable);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@NonNull T registerMethod, @NonNull U unregisterMethod) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(registerMethod);
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotNull(var1_1.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(var2_2.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)Objects.equal(var1_1.getListenerKey(), var2_2.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        zad zad2 = new zad();
        return this.zaa.zao(this, (RegisterListenerMethod)var1_1, (UnregisterListenerMethod)var2_2, zad2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        void var1_1;
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey<?>)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey, int methodKey) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zaa.zap(this, (ListenerHolder.ListenerKey)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(1, (TaskApiCall)var1_1);
    }

    @Nullable
    protected String getApiFallbackAttributionTag(@NonNull Context context) {
        return null;
    }

    @KeepForSdk
    @Nullable
    protected String getContextAttributionTag() {
        return this.zac;
    }

    @Deprecated
    @KeepForSdk
    @Nullable
    protected String getContextFeatureId() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((Context)v0, (Activity)v0, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        builder.setLooper(var1_1.getMainLooper());
        this((Activity)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        this((Context)var1_1, null, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        this((Context)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private GoogleApi(@NonNull Context object, @Nullable Activity activity, Api api, Api.ApiOptions apiOptions, Settings settings) {
        void var6_7;
        block5: {
            void var6_9;
            block6: {
                block3: {
                    block4: {
                        Preconditions.checkNotNull((Object)object, (Object)"Null context is not permitted.");
                        Preconditions.checkNotNull((Object)api, (Object)"Api must not be null.");
                        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
                        this.zab = (Context)Preconditions.checkNotNull((Object)object.getApplicationContext(), (Object)"The provided context did not have an application context.");
                        if (Build.VERSION.SDK_INT < 30) break block3;
                        if (object == null) break block4;
                        String string2 = ContextCompat.getAttributionTag((Context)object);
                        break block5;
                    }
                    Object var6_8 = null;
                    break block6;
                }
                Context context = object;
            }
            if (var6_9 != null) {
                String string3 = this.getApiFallbackAttributionTag((Context)var6_9);
            } else {
                Object var6_11 = null;
            }
        }
        this.zac = var6_7;
        object = Build.VERSION.SDK_INT >= 31 ? (object != null ? new AttributionSourceWrapper(object.getAttributionSource()) : null) : null;
        this.zad = object;
        this.zae = api;
        this.zaf = apiOptions;
        this.zah = settings.zab;
        this.zag = ApiKey.getSharedApiKey(this.zae, this.zaf, this.zac);
        this.zaj = new zabt(this);
        this.zaa = GoogleApiManager.zak(this.zab);
        this.zai = this.zaa.zaa();
        this.zak = settings.zaa;
        if (activity != null && !(activity instanceof GoogleApiActivity) && Looper.myLooper() == Looper.getMainLooper()) {
            zaad.zad(activity, this.zaa, this.zag);
        }
        this.zaa.zaz(this);
    }

    public final int zaa() {
        return this.zai;
    }

    @WorkerThread
    public final Api.Client zab(Looper object, zabo zabo2) {
        ClientSettings clientSettings = ((GoogleApi)this).createClientSettingsBuilder().build();
        Api.ApiOptions apiOptions = ((GoogleApi)this).zaf;
        zabo zabo3 = zabo2;
        object = ((Api.AbstractClientBuilder)Preconditions.checkNotNull((Object)((GoogleApi)this).zae.zaa())).buildClient(((GoogleApi)this).zab, (Looper)object, clientSettings, apiOptions, zabo3, zabo3);
        zabo2 = ((GoogleApi)this).zad;
        if (zabo2 == null || !(object instanceof BaseGmsClient)) {
            if (zabo2 == null || !(object instanceof NonGmsServiceBrokerClient)) {
                if ((this = ((GoogleApi)this).getContextAttributionTag()) != null && object instanceof BaseGmsClient) {
                    ((BaseGmsClient)object).setAttributionTag((String)this);
                }
                if (this != null && object instanceof NonGmsServiceBrokerClient) {
                    ((NonGmsServiceBrokerClient)object).zad((String)this);
                }
                return object;
            }
            ((NonGmsServiceBrokerClient)object).zac((AttributionSourceWrapper)zabo2);
            return object;
        }
        ((BaseGmsClient)object).setAttributionSourceWrapper((AttributionSourceWrapper)zabo2);
        return object;
    }

    private final BaseImplementation.ApiMethodImpl zad(int n, @NonNull BaseImplementation.ApiMethodImpl apiMethodImpl) {
        apiMethodImpl.zak();
        this.zaa.zau(this, n, apiMethodImpl);
        return apiMethodImpl;
    }

    public final zacq zac(Context context, Handler handler) {
        return new zacq(context, handler, this.createClientSettingsBuilder().build());
    }

    private final Task zae(int n, @NonNull TaskApiCall taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StatusExceptionMapper statusExceptionMapper = this.zak;
        this.zaa.zav(this, n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        return taskCompletionSource.getTask();
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        @NonNull
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        @NonNull
        public final StatusExceptionMapper zaa;
        @NonNull
        public final Looper zab;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        private Settings(StatusExceptionMapper mapper, Account account, Looper looper) {
            void var3_3;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var3_3;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zae zae2) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zaa;
            private Looper zab;

            /*
             * WARNING - void declaration
             */
            @KeepForSdk
            @NonNull
            public Builder setLooper(@NonNull Looper looper) {
                void var1_1;
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zab = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @KeepForSdk
            @NonNull
            public Builder setMapper(@NonNull StatusExceptionMapper mapper) {
                void var1_1;
                Preconditions.checkNotNull((Object)mapper, (Object)"StatusExceptionMapper must not be null.");
                this.zaa = var1_1;
                return this;
            }

            @KeepForSdk
            @NonNull
            public Settings build() {
                if (this.zaa == null) {
                    this.zaa = new ApiExceptionMapper();
                }
                if (this.zab == null) {
                    this.zab = Looper.getMainLooper();
                }
                return new Settings(this.zaa, null, this.zab, null);
            }

            @KeepForSdk
            public Builder() {
            }
        }
    }
}

