/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zabz;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import java.util.concurrent.Executor;

@KeepForSdk
public final class ListenerHolder<L> {
    private final Executor zaa;
    @Nullable
    private volatile Object zab;
    @Nullable
    private volatile ListenerKey zac;

    @Nullable
    @KeepForSdk
    public ListenerKey<L> getListenerKey() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L listener, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaa = new HandlerExecutor((Looper)var1_1);
        this.zab = Preconditions.checkNotNull((Object)var2_2, (Object)"Listener must not be null");
        this.zac = new ListenerKey<void>(var2_2, Preconditions.checkNotEmpty((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Executor executor, @NonNull L listener, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zaa = (Executor)Preconditions.checkNotNull((Object)var1_1, (Object)"Executor must not be null");
        this.zab = Preconditions.checkNotNull((Object)var2_2, (Object)"Listener must not be null");
        this.zac = new ListenerKey<void>(var2_2, Preconditions.checkNotEmpty((String)var3_3));
    }

    @KeepForSdk
    public void clear() {
        this.zab = null;
        this.zac = null;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void notifyListener(@NonNull Notifier<? super L> notifier) {
        void var1_1;
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        zabz zabz2 = new zabz(this, (Notifier)var1_1);
        this.zaa.execute(zabz2);
    }

    @KeepForSdk
    public boolean hasListener() {
        return this.zab != null;
    }

    public static /* synthetic */ void zaa(@NonNull ListenerHolder object, @NonNull Notifier notifier) {
        object = ((ListenerHolder)object).zab;
        if (object == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(object);
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final Object zaa;
        private final String zab;

        @KeepForSdk
        public int hashCode() {
            return System.identityHashCode(this.zaa) * 31 + this.zab.hashCode();
        }

        @KeepForSdk
        @NonNull
        public String toIdString() {
            int n = System.identityHashCode(this.zaa);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.zab);
            stringBuilder.append("@");
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        ListenerKey(L listener, String listenerType) {
            void var2_2;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var2_2;
        }

        @KeepForSdk
        public boolean equals(@Nullable Object o) {
            ListenerKey listenerKey;
            if (this == listenerKey) {
                return true;
            }
            if (!(listenerKey instanceof ListenerKey)) {
                return false;
            }
            listenerKey = listenerKey;
            return this.zaa == listenerKey.zaa && this.zab.equals(listenerKey.zab);
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(@NonNull L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

