/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zaaz;
import com.google.android.gms.common.api.internal.zaba;
import com.google.android.gms.common.api.internal.zabb;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zabx;
import com.google.android.gms.common.api.internal.zaby;
import com.google.android.gms.common.api.internal.zacx;
import com.google.android.gms.common.api.internal.zacz;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.ClientLibraryUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zabc
extends GoogleApiClient
implements zabx {
    private final Lock zaj;
    private final com.google.android.gms.common.internal.zak zak;
    @Nullable
    private zaby zal = null;
    private final int zam;
    private final Context zan;
    private final Looper zao;
    @VisibleForTesting
    final Queue zaa = new LinkedList();
    private volatile boolean zap;
    private long zaq;
    private long zar;
    private final zaba zas;
    private final GoogleApiAvailability zat;
    @Nullable
    @VisibleForTesting
    zabv zab;
    final Map zac;
    Set zad;
    final ClientSettings zae;
    final Map zaf;
    final Api.AbstractClientBuilder zag;
    private final ListenerHolders zau;
    private final ArrayList zav;
    private Integer zaw;
    @Nullable
    Set zah;
    final zacz zai;
    private final zaj zax;

    public static int zad(Iterable iterable, boolean bl) {
        Iterator iterator = iterable.iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            Api.Client client = (Api.Client)iterator.next();
            bl2 = client.requiresSignIn() | bl2;
            bl3 = client.providesSignIn() | bl3;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static /* bridge */ /* synthetic */ Context zae(zabc zabc2) {
        return zabc2.zan;
    }

    @Override
    public final Context getContext() {
        return this.zan;
    }

    @Override
    public final Looper getLooper() {
        return this.zao;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect() {
        int n = Looper.myLooper() != Looper.getMainLooper() ? 1 : 0;
        Preconditions.checkState(n != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zaj.lock();
        try {
            n = this.zam;
            if (n >= 0) {
                Integer n2 = this.zaw;
                boolean bl = n2 != null;
                Preconditions.checkState((boolean)bl, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else {
                Integer n3 = this.zaw;
                if (n3 == null) {
                    this.zaw = zabc.zad(this.zac.values(), false);
                } else {
                    int n4 = n3;
                    if (n4 == 2) {
                        throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                    }
                }
            }
            zabc zabc2 = this;
            zabc2.zal((Integer)Preconditions.checkNotNull((Object)zabc2.zaw));
            this.zak.zab();
            ConnectionResult connectionResult = ((zaby)Preconditions.checkNotNull((Object)this.zal)).zab();
            this.zaj.unlock();
            return connectionResult;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState((boolean)bl, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zaj.lock();
        try {
            Integer n = this.zaw;
            if (n == null) {
                this.zaw = zabc.zad(this.zac.values(), false);
            } else {
                int n2 = n;
                if (n2 == 2) {
                    throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                }
            }
            zabc zabc2 = this;
            zabc2.zal((Integer)Preconditions.checkNotNull((Object)zabc2.zaw));
            this.zak.zab();
            timeUnit = ((zaby)Preconditions.checkNotNull((Object)this.zal)).zac(l, timeUnit);
            this.zaj.unlock();
            return timeUnit;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> connectionResult) {
        ConnectionResult connectionResult2;
        block10: {
            this.zaj.lock();
            try {
                boolean bl = this.isConnected();
                if (bl || (bl = this.zap)) {
                    bl = this.zac.containsKey(connectionResult.zab());
                    if (bl) {
                        connectionResult2 = ((zaby)Preconditions.checkNotNull((Object)this.zal)).zad((Api)connectionResult);
                        if (connectionResult2 == null) {
                            boolean bl2 = this.zap;
                            if (bl2) {
                                connectionResult = ConnectionResult.RESULT_SUCCESS;
                            } else {
                                Log.w((String)"GoogleApiClientImpl", (String)this.zaf());
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(connectionResult.zad());
                                stringBuilder.append(" requested in getConnectionResult is not connected but is not present in the failed  connections map");
                                Log.wtf((String)"GoogleApiClientImpl", (String)stringBuilder.toString(), (Throwable)new Exception());
                                connectionResult = new ConnectionResult(8, null);
                            }
                            this.zaj.unlock();
                            return connectionResult;
                        }
                        break block10;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(connectionResult.zad());
                        stringBuilder.append(" was never registered with GoogleApiClient");
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                }
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            catch (Throwable throwable) {
                this.zaj.unlock();
                throw throwable;
            }
        }
        this.zaj.unlock();
        return connectionResult2;
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = (Api.Client)this.zac.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Integer n = this.zaw;
        boolean bl = n != null ? n != 2 : true;
        Preconditions.checkState((boolean)bl, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zac.containsKey(Common.CLIENT_KEY)) {
            zabc zabc2 = this;
            zabc2.zam(zabc2, statusPendingResult, false);
            return statusPendingResult;
        }
        AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
        zaax zaax2 = new zaax(this, atomicReference, statusPendingResult);
        zaay zaay2 = new zaay(this, statusPendingResult);
        Context context = this.zan;
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder(context);
        builder.addApi(Common.API);
        builder.addConnectionCallbacks(zaax2);
        builder.addOnConnectionFailedListener(zaay2);
        builder.setHandler(this.zas);
        GoogleApiClient googleApiClient = builder.build();
        atomicReference.set(googleApiClient);
        googleApiClient.connect();
        return statusPendingResult;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T object) {
        void var1_2;
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.zaj.lock();
        try {
            object2 = this.zal;
            if (object2 == null) {
                this.zaa.add(object);
            } else {
                BaseImplementation.ApiMethodImpl apiMethodImpl = object2.zae((BaseImplementation.ApiMethodImpl)object);
            }
            this.zaj.unlock();
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T object) {
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.zaj.lock();
        try {
            object2 = this.zal;
            if (object2 != null) {
                void var1_2;
                bl = this.zap;
                if (bl) {
                    boolean bl2;
                    this.zaa.add(object);
                    while (!(bl2 = this.zaa.isEmpty())) {
                        object2 = (BaseImplementation.ApiMethodImpl)this.zaa.remove();
                        this.zai.zaa((BasePendingResult)object2);
                        ((BaseImplementation.ApiMethodImpl)object2).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                    }
                } else {
                    BaseImplementation.ApiMethodImpl apiMethodImpl = object2.zaf((BaseImplementation.ApiMethodImpl)object);
                }
                this.zaj.unlock();
                return var1_2;
            }
            throw new IllegalStateException("GoogleApiClient is not connected yet.");
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L object) {
        this.zaj.lock();
        try {
            ListenerHolders listenerHolders = this.zau;
            Looper looper = this.zao;
            object = listenerHolders.zaa(object, looper, "NO_TYPE");
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        this.zaj.unlock();
        return object;
    }

    final String zaf() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dump("", null, printWriter, null);
        return stringWriter.toString();
    }

    static String zag(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
            case 1: 
        }
        return "SIGN_IN_MODE_REQUIRED";
    }

    static /* bridge */ /* synthetic */ void zah(zabc zabc2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zabc2.zam(googleApiClient, statusPendingResult, true);
    }

    static /* bridge */ /* synthetic */ void zai(zabc zabc2) {
        block3: {
            zabc2.zaj.lock();
            try {
                boolean bl = zabc2.zap;
                if (!bl) break block3;
            }
            catch (Throwable throwable) {
                zabc2.zaj.unlock();
                throw throwable;
            }
            zabc2.zan();
        }
        zabc2.zaj.unlock();
    }

    static /* bridge */ /* synthetic */ void zaj(zabc zabc2) {
        block3: {
            zabc2.zaj.lock();
            try {
                boolean bl = zabc2.zak();
                if (!bl) break block3;
            }
            catch (Throwable throwable) {
                zabc2.zaj.unlock();
                throw throwable;
            }
            zabc2.zan();
        }
        zabc2.zaj.unlock();
    }

    /*
     * Enabled aggressive block sorting
     */
    public zabc(Context object, Lock object22, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder abstractClientBuilder, Map map, List list, List list2, Map map2, int n, int n2, ArrayList arrayList) {
        long l = true != ClientLibraryUtils.isPackageSide() ? 120000L : 10000L;
        this.zaq = l;
        this.zar = 5000L;
        this.zad = new HashSet();
        this.zau = new ListenerHolders();
        this.zaw = null;
        this.zah = null;
        this.zax = new zaaw(this);
        this.zan = object;
        this.zaj = object22;
        this.zak = new com.google.android.gms.common.internal.zak(looper, this.zax);
        this.zao = looper;
        this.zas = new zaba(this, looper);
        this.zat = googleApiAvailability;
        this.zam = n;
        if (n >= 0) {
            this.zaw = n2;
        }
        this.zaf = map;
        this.zac = map2;
        this.zav = arrayList;
        this.zai = new zacz();
        for (Object object22 : list) {
            this.zak.zaf((GoogleApiClient.ConnectionCallbacks)object22);
        }
        object = list2.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.zae = clientSettings;
                this.zag = abstractClientBuilder;
                return;
            }
            object22 = (GoogleApiClient.OnConnectionFailedListener)object.next();
            this.zak.zag((GoogleApiClient.OnConnectionFailedListener)object22);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zal(int n) {
        Integer n2 = this.zaw;
        if (n2 == null) {
            this.zaw = n;
        } else if (n2 != n) {
            String string2 = zabc.zag(this.zaw);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot use sign-in mode: ");
            stringBuilder.append(zabc.zag(n));
            stringBuilder.append(". Mode was already set to ");
            stringBuilder.append(string2);
            throw new IllegalStateException(stringBuilder.toString());
        }
        if (this.zal != null) {
            return;
        }
        Looper looper = this.zac.values().iterator();
        n = 0;
        boolean bl = false;
        while (looper.hasNext()) {
            Api.Client client = (Api.Client)looper.next();
            n = client.requiresSignIn() | n;
            bl = client.providesSignIn() | bl;
        }
        switch (this.zaw) {
            case 1: {
                if (n == 0) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (n == 0) break;
                zabc zabc2 = this;
                this.zal = zaz.zag(this.zan, zabc2, this.zaj, this.zao, zabc2.zat, this.zac, this.zae, this.zaf, this.zag, this.zav);
                return;
            }
        }
        Context context = this.zan;
        Lock lock = this.zaj;
        looper = this.zao;
        GoogleApiAvailability googleApiAvailability = this.zat;
        Map map = this.zac;
        ClientSettings clientSettings = this.zae;
        Map map2 = this.zaf;
        Api.AbstractClientBuilder abstractClientBuilder = this.zag;
        ArrayList arrayList = this.zav;
        this.zal = new zabg(context, this, lock, looper, googleApiAvailability, map, clientSettings, map2, abstractClientBuilder, arrayList, this);
    }

    private final void zam(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zaa.zaa(googleApiClient).setResultCallback(new zaaz(this, statusPendingResult, bl, googleApiClient));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect() {
        boolean bl;
        int n;
        block16: {
            this.zaj.lock();
            try {
                int n2 = this.zam;
                if (n2 >= 0) {
                    Integer n3 = this.zaw;
                    boolean bl2 = n3 != null;
                    Preconditions.checkState((boolean)bl2, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
                } else {
                    Integer n4 = this.zaw;
                    if (n4 == null) {
                        this.zaw = zabc.zad(this.zac.values(), false);
                    } else {
                        int n5 = n4;
                        if (n5 == 2) {
                            throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                        }
                    }
                }
                n = (Integer)Preconditions.checkNotNull((Object)this.zaw);
                this.zaj.lock();
                if (n != 3) {
                    if (n != 1) {
                        if (n == 2) {
                            n = 2;
                            bl = true;
                            break block16;
                        } else {
                            bl = false;
                        }
                        break block16;
                    }
                    bl = true;
                    break block16;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                this.zaj.unlock();
                throw throwable;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Illegal sign-in mode: ");
        stringBuilder.append(n);
        String string2 = stringBuilder.toString();
        Preconditions.checkArgument((boolean)bl, (Object)string2);
        this.zal(n);
        this.zan();
        this.zaj.unlock();
        this.zaj.unlock();
        return;
        catch (Throwable throwable) {}
        this.zaj.unlock();
        throw throwable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect(int n) {
        boolean bl;
        block6: {
            block7: {
                this.zaj.lock();
                if (n == 3) break block7;
                if (n != 1) {
                    if (n == 2) {
                        n = 2;
                        bl = true;
                        break block6;
                    } else {
                        bl = false;
                    }
                    break block6;
                } else {
                    bl = true;
                }
                break block6;
            }
            bl = true;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal sign-in mode: ");
            stringBuilder.append(n);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            this.zal(n);
            this.zan();
            this.zaj.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    private final void zan() {
        this.zak.zab();
        ((zaby)Preconditions.checkNotNull((Object)this.zal)).zaq();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void disconnect() {
        this.zaj.lock();
        try {
            boolean bl;
            this.zai.zab();
            Object object = this.zal;
            if (object != null) {
                object.zar();
            }
            this.zau.zab();
            object = this.zaa.iterator();
            while (bl = object.hasNext()) {
                BaseImplementation.ApiMethodImpl apiMethodImpl = (BaseImplementation.ApiMethodImpl)object.next();
                apiMethodImpl.zan(null);
                apiMethodImpl.cancel();
            }
            this.zaa.clear();
            object = this.zal;
            if (object != null) {
                this.zak();
                this.zak.zaa();
            }
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        this.zaj.unlock();
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(((zabc)((Object)zaby2)).zan);
        printWriter.append(string2).append("mResuming=").print(((zabc)((Object)zaby2)).zap);
        Collection collection = ((zabc)((Object)zaby2)).zaa;
        printWriter.append(" mWorkQueue.size()=").print(collection.size());
        collection = ((zabc)((Object)zaby2)).zai.zab;
        printWriter.append(" mUnconsumedApiCalls.size()=").println(collection.size());
        zaby zaby2 = ((zabc)((Object)zaby2)).zal;
        if (zaby2 != null) {
            zaby2.zas(string2, fileDescriptor, printWriter, stringArray);
            return;
        }
    }

    @Override
    public final void zaa(ConnectionResult connectionResult) {
        if (!this.zat.isPlayServicesPossiblyUpdating(this.zan, connectionResult.getErrorCode())) {
            this.zak();
        }
        if (!this.zap) {
            this.zak.zac(connectionResult);
            this.zak.zaa();
            return;
        }
    }

    @Override
    public final void zab(@Nullable Bundle bundle) {
        while (!this.zaa.isEmpty()) {
            zabc zabc2 = this;
            ((GoogleApiClient)zabc2).execute((BaseImplementation.ApiMethodImpl)zabc2.zaa.remove());
        }
        this.zak.zad(bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zac(int n, boolean n2) {
        block5: {
            block4: {
                block6: {
                    block7: {
                        if (n != 1) break block5;
                        if (n2 != 0) break block6;
                        if (!this.zap) break block7;
                        n = 1;
                        break block5;
                    }
                    this.zap = true;
                    if (this.zab != null || ClientLibraryUtils.isPackageSide()) break block4;
                    try {
                        GoogleApiAvailability googleApiAvailability = this.zat;
                        Context context = this.zan.getApplicationContext();
                        this.zab = googleApiAvailability.zac(context, new zabb(this));
                        break block4;
                    }
                    catch (SecurityException securityException) {}
                }
                n = 1;
                break block5;
            }
            zaba zaba2 = this.zas;
            zaba2.sendMessageDelayed(zaba2.obtainMessage(1), this.zaq);
            zaba zaba3 = this.zas;
            zaba3.sendMessageDelayed(zaba3.obtainMessage(2), this.zar);
            n = 1;
        }
        BasePendingResult[] basePendingResultArray = this.zai.zab.toArray(new BasePendingResult[0]);
        int n3 = basePendingResultArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            basePendingResultArray[n2].forceFailureUnlessReady(zacz.zaa);
        }
        this.zak.zae(n);
        this.zak.zaa();
        if (n == 2) {
            this.zan();
            return;
        }
    }

    @Override
    public final void maybeSignOut() {
        zaby zaby2 = ((zabc)((Object)zaby2)).zal;
        if (zaby2 != null) {
            zaby2.zau();
            return;
        }
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zaf(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zag(onConnectionFailedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zao(zacx zacx2) {
        this.zaj.lock();
        try {
            Set set = this.zah;
            if (set == null) {
                this.zah = new HashSet();
            }
            this.zah.add(zacx2);
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        this.zaj.unlock();
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        if (this.zam < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        com.google.android.gms.common.api.internal.zak.zaa(lifecycleActivity).zae(this.zam);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zah(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zai(onConnectionFailedListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zap(zacx var1_1) {
        block14: {
            this.zaj.lock();
            try {
                var2_7 = this.zah;
                if (var2_7 == null) {
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
                    break block14;
                }
            }
            catch (Throwable v0) {
                this.zaj.unlock();
                throw v0;
            }
            {
                var1_2 = var2_7.remove(var1_1);
                if (!var1_2) {
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
                    break block14;
                }
                this.zaj.lock();
            }
            try {
                var1_3 = this.zah;
                if (var1_3 != null) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            catch (Throwable var1_6) {
                ** continue;
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    this.zaj.unlock();
                    throw var1_6;
                }
            }
        }
lbl28:
        // 4 sources

        while (true) {
            this.zaj.unlock();
            return;
        }
lbl-1000:
        // 1 sources

        {
            this.zaj.unlock();
lbl32:
            // 2 sources

            while (true) {
                var1_4 = this.zal;
                if (var1_4 == null) ** GOTO lbl28
                var1_4.zat();
                ** GOTO lbl28
                break;
            }
        }
lbl-1000:
        // 1 sources

        {
            var1_5 = var1_3.isEmpty();
            var1_5 ^= true;
        }
        {
            this.zaj.unlock();
            if (!var1_5) ** break;
            ** continue;
            ** continue;
        }
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zac.containsKey(api.zab());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((zabc)((Object)client)).isConnected()) {
            return false;
        }
        Api.Client client = (Api.Client)((zabc)((Object)client)).zac.get(api.zab());
        return client != null && client.isConnected();
    }

    @Override
    public final boolean isConnected() {
        zaby zaby2 = ((zabc)((Object)zaby2)).zal;
        return zaby2 != null && zaby2.zaw();
    }

    @Override
    public final boolean isConnecting() {
        zaby zaby2 = ((zabc)((Object)zaby2)).zal;
        return zaby2 != null && zaby2.zax();
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zak.zaj(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zak.zak(onConnectionFailedListener);
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        zaby zaby2 = ((zabc)((Object)zaby2)).zal;
        return zaby2 != null && zaby2.zay(signInConnectionListener);
    }

    final boolean zak() {
        if (!this.zap) {
            return false;
        }
        this.zap = false;
        this.zas.removeMessages(2);
        this.zas.removeMessages(1);
        zabv zabv2 = this.zab;
        if (zabv2 != null) {
            zabv2.zab();
            this.zab = null;
        }
        return true;
    }
}

