/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.zaac;
import com.google.android.gms.common.api.internal.zaad;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zabp;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zacg;
import com.google.android.gms.common.api.internal.zacq;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zabo
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zau {
    private final Queue zab = new LinkedList();
    private final Api.Client zac;
    private final ApiKey zad;
    private final zaac zae;
    private final Set zaf = new HashSet();
    private final Map zag = new HashMap();
    private final int zah;
    @Nullable
    private final zacq zai;
    private boolean zaj;
    private final List zak = new ArrayList();
    @Nullable
    private ConnectionResult zal = null;
    private int zam = 0;
    final /* synthetic */ GoogleApiManager zaa;

    public final int zab() {
        return this.zah;
    }

    @WorkerThread
    final int zac() {
        return this.zam;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zad() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        return this.zal;
    }

    @WorkerThread
    @Nullable
    private final Feature zaC(@Nullable Feature[] featureArray) {
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        ArrayMap arrayMap = new ArrayMap(featureArray2.length);
        for (int i = 0; i < featureArray2.length; ++i) {
            Feature feature = featureArray2[i];
            arrayMap.put(feature.getName(), feature.getVersion());
        }
        for (Feature feature : featureArray) {
            Long l = (Long)arrayMap.get(feature.getName());
            if (l != null && l >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ Api.Client zae(zabo zabo2) {
        return zabo2.zac;
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    static /* bridge */ /* synthetic */ ApiKey zag(zabo zabo2) {
        return zabo2.zad;
    }

    public final Map zah() {
        return this.zag;
    }

    static /* bridge */ /* synthetic */ void zai(zabo zabo2, Status status) {
        zabo2.zaE(status);
    }

    static /* bridge */ /* synthetic */ void zaj(zabo zabo2) {
        zabo2.zaH();
    }

    static /* bridge */ /* synthetic */ void zak(zabo zabo2, int n) {
        zabo2.zaI(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zal(zabo zabo2, zabp zabp2) {
        if (!zabo2.zak.contains(zabp2) || zabo2.zaj) {
            return;
        }
        if (!zabo2.zac.isConnected()) {
            zabo2.zao();
            return;
        }
        zabo2.zaG();
    }

    static /* bridge */ /* synthetic */ void zam(zabo zabo2, zabp iterator) {
        if (zabo2.zak.remove(iterator)) {
            Object[] objectArray;
            GoogleApiManager.zad(zabo2.zaa).removeMessages(15, (Object)iterator);
            GoogleApiManager.zad(zabo2.zaa).removeMessages(16, (Object)iterator);
            Feature feature = zabp.zaa((zabp)((Object)iterator));
            iterator = zabo2.zab;
            ArrayList<zai> arrayList = new ArrayList<zai>(iterator.size());
            for (zai zai2 : zabo2.zab) {
                if (!(zai2 instanceof zac) || (objectArray = ((zac)zai2).zab(zabo2)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)feature)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                objectArray = (zai)arrayList.get(i);
                zabo2.zab.remove(objectArray);
                objectArray.zae((Exception)new UnsupportedApiCallException(feature));
            }
        }
    }

    @WorkerThread
    public zabo(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        this.zaa = googleApiManager;
        this.zac = googleApi.zab(GoogleApiManager.zad(googleApiManager).getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = new zaac();
        this.zah = googleApi.zaa();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(GoogleApiManager.zac(googleApiManager), GoogleApiManager.zad(googleApiManager));
            return;
        }
        this.zai = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaD(ConnectionResult connectionResult) {
        Iterator iterator = this.zaf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zaf.clear();
                return;
            }
            zal zal2 = (zal)iterator.next();
            String string2 = Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    @WorkerThread
    public final void zan() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zal = null;
    }

    @WorkerThread
    public final void zao() {
        Object object;
        block7: {
            int n;
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
            if (this.zac.isConnected() || this.zac.isConnecting()) {
                return;
            }
            try {
                GoogleApiManager googleApiManager = this.zaa;
                object = GoogleApiManager.zal(googleApiManager);
                n = ((com.google.android.gms.common.internal.zal)object).zab(GoogleApiManager.zac(googleApiManager), this.zac);
                if (n == 0) break block7;
            }
            catch (IllegalStateException illegalStateException) {
                this.zar(new ConnectionResult(10), illegalStateException);
                return;
            }
            object = new ConnectionResult(n, null);
            String string2 = this.zac.getClass().getName();
            String string3 = object.toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The service for ");
            stringBuilder.append(string2);
            stringBuilder.append(" is not available: ");
            stringBuilder.append(string3);
            Log.w((String)"GoogleApiManager", (String)stringBuilder.toString());
            this.zar((ConnectionResult)object, null);
            return;
        }
        GoogleApiManager googleApiManager = this.zaa;
        object = this.zac;
        ApiKey apiKey = this.zad;
        zabr zabr2 = new zabr(googleApiManager, (Api.Client)object, apiKey);
        if (object.requiresSignIn()) {
            ((zacq)Preconditions.checkNotNull((Object)this.zai)).zae(zabr2);
        }
        try {
            this.zac.connect(zabr2);
            return;
        }
        catch (SecurityException securityException) {
            this.zar(new ConnectionResult(10), securityException);
            return;
        }
    }

    @WorkerThread
    public final void zap(zai zai2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zac.isConnected()) {
            if (this.zaM(zai2)) {
                this.zaJ();
                return;
            }
            this.zab.add(zai2);
            return;
        }
        this.zab.add(zai2);
        zai2 = this.zal;
        if (zai2 != null && zai2.hasResolution()) {
            zabo zabo2 = this;
            zabo2.zar(zabo2.zal, null);
            return;
        }
        this.zao();
    }

    @WorkerThread
    private final void zaE(Status status) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaF(status, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaF(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabo)((Object)iterator)).zaa));
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            throw new IllegalArgumentException("Status XOR exception should be null");
        }
        Iterator iterator = ((zabo)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zad(status);
            } else {
                zai2.zae(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaG() {
        ArrayList arrayList = new ArrayList(this.zab);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaM(zai2)) {
                this.zab.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    final void zaq() {
        ++this.zam;
    }

    @Override
    public final void onConnected(@Nullable Bundle object) {
        object = this.zaa;
        if (Looper.myLooper() == GoogleApiManager.zad((GoogleApiManager)object).getLooper()) {
            this.zaH();
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabk(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaH() {
        this.zan();
        this.zaD(ConnectionResult.RESULT_SUCCESS);
        this.zaL();
        Iterator iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            zacg zacg2 = (zacg)iterator.next();
            if (this.zaC(zacg2.zaa.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                zacg2.zaa.registerListener(this.zac, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException | RuntimeException throwable) {
                Log.e((String)"GoogleApiManager", (String)"Failed to register listener on re-connection.", (Throwable)throwable);
                iterator.remove();
            }
        }
        this.zaG();
        this.zaJ();
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zar(connectionResult, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zar(@NonNull ConnectionResult object, @Nullable Exception exception) {
        void var2_3;
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabo)((Object)apiKey)).zaa));
        Object object2 = ((zabo)((Object)apiKey)).zai;
        if (object2 != null) {
            ((zacq)object2).zaf();
        }
        ((zabo)((Object)apiKey)).zan();
        GoogleApiManager.zal(((zabo)((Object)apiKey)).zaa).zac();
        ((zabo)((Object)apiKey)).zaD((ConnectionResult)object);
        if (((zabo)((Object)apiKey)).zac instanceof zap && object.getErrorCode() != 24) {
            GoogleApiManager.zat(((zabo)((Object)apiKey)).zaa, true);
            object2 = ((zabo)((Object)apiKey)).zaa;
            GoogleApiManager.zad((GoogleApiManager)object2).sendMessageDelayed(GoogleApiManager.zad((GoogleApiManager)object2).obtainMessage(19), 300000L);
        }
        if (object.getErrorCode() == 4) {
            ((zabo)((Object)apiKey)).zaE(GoogleApiManager.zaf());
            return;
        }
        if (object.getErrorCode() == 25) {
            zabo zabo2 = apiKey;
            zabo2.zaE(GoogleApiManager.zag(zabo2.zad, object));
            return;
        }
        if (((zabo)((Object)apiKey)).zab.isEmpty()) {
            ((zabo)((Object)apiKey)).zal = object;
            return;
        }
        if (var2_3 != null) {
            Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(((zabo)((Object)apiKey)).zaa));
            ((zabo)((Object)apiKey)).zaF(null, (Exception)var2_3, false);
            return;
        }
        if (!GoogleApiManager.zaC(((zabo)((Object)apiKey)).zaa)) {
            zabo zabo3 = apiKey;
            zabo3.zaE(GoogleApiManager.zag(zabo3.zad, object));
            return;
        }
        zabo zabo4 = apiKey;
        zabo4.zaF(GoogleApiManager.zag(zabo4.zad, object), null, true);
        if (((zabo)((Object)apiKey)).zab.isEmpty() || ((zabo)((Object)apiKey)).zaN((ConnectionResult)object) || ((zabo)((Object)apiKey)).zaa.zaG((ConnectionResult)object, ((zabo)((Object)apiKey)).zah)) {
            return;
        }
        if (object.getErrorCode() == 18) {
            ((zabo)((Object)apiKey)).zaj = true;
        }
        if (((zabo)((Object)apiKey)).zaj) {
            GoogleApiManager googleApiManager = ((zabo)((Object)apiKey)).zaa;
            ApiKey apiKey = ((zabo)((Object)apiKey)).zad;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)9, (Object)apiKey), 5000L);
            return;
        }
        zabo zabo5 = apiKey;
        zabo5.zaE(GoogleApiManager.zag(zabo5.zad, object));
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api api, boolean bl) {
        throw null;
    }

    @Override
    public final void onConnectionSuspended(int n) {
        GoogleApiManager googleApiManager = this.zaa;
        if (Looper.myLooper() == GoogleApiManager.zad(googleApiManager).getLooper()) {
            this.zaI(n);
            return;
        }
        GoogleApiManager.zad(this.zaa).post((Runnable)new zabl(this, n));
    }

    @WorkerThread
    private final void zaI(int n) {
        ((zabo)((Object)iterator)).zan();
        ((zabo)((Object)iterator)).zaj = true;
        Object object = ((zabo)((Object)iterator)).zac.getLastDisconnectMessage();
        ((zabo)((Object)iterator)).zae.zae(n, (String)object);
        ApiKey apiKey = ((zabo)((Object)iterator)).zad;
        object = ((zabo)((Object)iterator)).zaa;
        GoogleApiManager.zad((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad((GoogleApiManager)object), (int)9, (Object)apiKey), 5000L);
        apiKey = ((zabo)((Object)iterator)).zad;
        object = ((zabo)((Object)iterator)).zaa;
        GoogleApiManager.zad((GoogleApiManager)object).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad((GoogleApiManager)object), (int)11, (Object)apiKey), 120000L);
        GoogleApiManager.zal(((zabo)((Object)iterator)).zaa).zac();
        Iterator iterator = ((zabo)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zacg)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zas(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zar(connectionResult, null);
    }

    @WorkerThread
    public final void zat(zal zal2) {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaf.add(zal2);
    }

    private final void zaJ() {
        ApiKey apiKey = this.zad;
        GoogleApiManager.zad(this.zaa).removeMessages(12, (Object)apiKey);
        apiKey = this.zad;
        GoogleApiManager googleApiManager = this.zaa;
        GoogleApiManager.zad(googleApiManager).sendMessageDelayed(GoogleApiManager.zad(googleApiManager).obtainMessage(12, (Object)apiKey), GoogleApiManager.zab(this.zaa));
    }

    @WorkerThread
    public final void zau() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (this.zaj) {
            this.zao();
            return;
        }
    }

    @WorkerThread
    private final void zaK(zai zai2) {
        zai2.zag(this.zae, this.zaA());
        try {
            zai2.zaf(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    @WorkerThread
    public final void zav() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        this.zaE(GoogleApiManager.zaa);
        this.zae.zaf();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            this.zap(new zah(listenerKey, new TaskCompletionSource()));
        }
        this.zaD(new ConnectionResult(4));
        if (this.zac.isConnected()) {
            this.zac.onUserSignOut(new zabn(this));
            return;
        }
    }

    @WorkerThread
    private final void zaL() {
        if (this.zaj) {
            ApiKey apiKey = this.zad;
            GoogleApiManager.zad(this.zaa).removeMessages(11, (Object)apiKey);
            apiKey = this.zad;
            GoogleApiManager.zad(this.zaa).removeMessages(9, (Object)apiKey);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zaw() {
        Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
        if (!this.zaj) {
            return;
        }
        this.zaL();
        Object object = this.zaa;
        if (GoogleApiManager.zae((GoogleApiManager)object).isGooglePlayServicesAvailable(GoogleApiManager.zac((GoogleApiManager)object)) == 18) {
            object = "Connection timed out waiting for Google Play services update to complete.";
            object = new Status(21, (String)object);
        } else {
            object = "API failed to connect while resuming due to an unknown error.";
            object = new Status(22, (String)object);
        }
        this.zaE((Status)object);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    static /* bridge */ /* synthetic */ boolean zax(zabo zabo2) {
        return zabo2.zaj;
    }

    static /* bridge */ /* synthetic */ boolean zay(zabo zabo2, boolean bl) {
        return zabo2.zaO(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final boolean zaM(zai object) {
        StringBuilder stringBuilder;
        if (!(object instanceof zac)) {
            ((zabo)((Object)googleApiManager)).zaK((zai)object);
            return true;
        }
        Object object2 = (zac)object;
        zabo zabo2 = googleApiManager;
        Feature feature = zabo2.zaC(((zac)object2).zab(zabo2));
        if (feature == null) {
            ((zabo)((Object)googleApiManager)).zaK((zai)object);
            return true;
        }
        object = ((zabo)((Object)googleApiManager)).zac.getClass().getName();
        String string2 = feature.getName();
        long l = feature.getVersion();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append((String)object);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder3.append(" could not execute call because it requires feature (");
        stringBuilder3.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        object = stringBuilder.toString();
        Log.w((String)"GoogleApiManager", (String)object);
        if (GoogleApiManager.zaC(((zabo)((Object)googleApiManager)).zaa) && ((zac)object2).zaa((zabo)((Object)googleApiManager))) {
            object = ((zabo)((Object)googleApiManager)).zad;
            object2 = new zabp((ApiKey)object, feature, null);
            int n = ((zabo)((Object)googleApiManager)).zak.indexOf(object2);
            if (n >= 0) {
                zabp zabp2 = (zabp)((zabo)((Object)googleApiManager)).zak.get(n);
                GoogleApiManager.zad(((zabo)((Object)googleApiManager)).zaa).removeMessages(15, (Object)zabp2);
                GoogleApiManager googleApiManager = ((zabo)((Object)googleApiManager)).zaa;
                GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)zabp2), 5000L);
                return false;
            }
            ((zabo)((Object)googleApiManager)).zak.add(object2);
            GoogleApiManager googleApiManager = ((zabo)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)15, (Object)object2), 5000L);
            googleApiManager = ((zabo)((Object)googleApiManager)).zaa;
            GoogleApiManager.zad(googleApiManager).sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.zad(googleApiManager), (int)16, (Object)object2), 120000L);
            googleApiManager = new ConnectionResult(2, null);
            if (super.zaN((ConnectionResult)googleApiManager)) return false;
            ((zabo)((Object)googleApiManager)).zaa.zaG((ConnectionResult)googleApiManager, ((zabo)((Object)googleApiManager)).zah);
            return false;
        }
        ((zai)object2).zae((Exception)new UnsupportedApiCallException(feature));
        return true;
    }

    final boolean zaz() {
        return this.zac.isConnected();
    }

    public final boolean zaA() {
        return this.zac.requiresSignIn();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaN(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zaq();
        synchronized (object) {
            GoogleApiManager googleApiManager = this.zaa;
            zaad zaad2 = GoogleApiManager.zah(googleApiManager);
            if (zaad2 == null) return false;
            boolean bl = GoogleApiManager.zas(googleApiManager).contains(this.zad);
            if (!bl) return false;
            GoogleApiManager.zah(this.zaa).zah(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final boolean zaB() {
        return this.zaO(true);
    }

    @WorkerThread
    private final boolean zaO(boolean bl) {
        block5: {
            block4: {
                Preconditions.checkHandlerThread((Handler)GoogleApiManager.zad(this.zaa));
                if (!this.zac.isConnected() || !this.zag.isEmpty()) break block4;
                if (!this.zae.zag()) break block5;
                if (bl) {
                    this.zaJ();
                }
            }
            return false;
        }
        this.zac.disconnect("Timing out service connection.");
        return true;
    }
}

