/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.NonGmsServiceBrokerClient;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zabk;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.zab;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.AttributionSourceWrapper;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context zab;
    @Nullable
    private final String zac;
    @Nullable
    private final AttributionSourceWrapper zad;
    private final Api zae;
    private final Api.ApiOptions zaf;
    private final ApiKey zag;
    private final Looper zah;
    private final int zai;
    private final GoogleApiClient zaj;
    private final StatusExceptionMapper zak;
    @NonNull
    protected final GoogleApiManager zaa;

    /*
     * WARNING - void declaration
     */
    @MainThread
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((Context)v0, (Activity)v0, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull Settings settings) {
        this((Context)var1_1, null, (Api)var2_2, (Api.ApiOptions)var3_3, (Settings)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private GoogleApi(@NonNull Context object, @Nullable Activity activity, Api api, Api.ApiOptions apiOptions, Settings settings) {
        void var6_7;
        block5: {
            void var6_9;
            block6: {
                block3: {
                    block4: {
                        Preconditions.checkNotNull((Object)object, (Object)"Null context is not permitted.");
                        Preconditions.checkNotNull((Object)api, (Object)"Api must not be null.");
                        Preconditions.checkNotNull((Object)settings, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
                        this.zab = (Context)Preconditions.checkNotNull((Object)object.getApplicationContext(), (Object)"The provided context did not have an application context.");
                        if (Build.VERSION.SDK_INT < 30) break block3;
                        if (object == null) break block4;
                        String string2 = ContextCompat.getAttributionTag((Context)object);
                        break block5;
                    }
                    Object var6_8 = null;
                    break block6;
                }
                Context context = object;
            }
            if (var6_9 != null) {
                String string3 = this.getApiFallbackAttributionTag((Context)var6_9);
            } else {
                Object var6_11 = null;
            }
        }
        this.zac = var6_7;
        object = Build.VERSION.SDK_INT >= 31 ? (object != null ? new AttributionSourceWrapper(object.getAttributionSource()) : null) : null;
        this.zad = object;
        this.zae = api;
        this.zaf = apiOptions;
        this.zah = settings.zab;
        this.zag = ApiKey.getSharedApiKey(this.zae, this.zaf, this.zac);
        this.zaj = new zabq(this);
        this.zaa = GoogleApiManager.zaa(this.zab);
        this.zai = this.zaa.zac();
        this.zak = settings.zaa;
        if (activity != null && !(activity instanceof GoogleApiActivity) && Looper.myLooper() == Looper.getMainLooper()) {
            zaab.zaa(activity, this.zaa, this.zag);
        }
        this.zaa.zad(this);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Activity activity, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        builder.setLooper(var1_1.getMainLooper());
        this((Activity)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public GoogleApi(@NonNull Context context, @NonNull Api<O> api, @NonNull O options, @NonNull StatusExceptionMapper mapper) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Settings.Builder builder = new Settings.Builder();
        builder.setMapper((StatusExceptionMapper)var4_4);
        this((Context)var1_1, (Api<void>)var2_2, var3_3, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(@NonNull T methodImpl) {
        void var1_1;
        this.zad(0, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(0, (TaskApiCall)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(1, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(1, (TaskApiCall)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(@NonNull T methodImpl) {
        void var1_1;
        this.zad(2, (BaseImplementation.ApiMethodImpl)var1_1);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(@NonNull TaskApiCall<A, TResult> methodImpl) {
        void var1_1;
        return this.zae(2, (TaskApiCall)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(@NonNull T registerMethod, @NonNull U unregisterMethod) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(registerMethod);
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotNull(var1_1.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkNotNull(var2_2.getListenerKey(), (Object)"Listener has already been released.");
        Preconditions.checkArgument((boolean)Objects.equal(var1_1.getListenerKey(), var2_2.getListenerKey()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        zab zab2 = com.google.android.gms.common.api.zab.zaa;
        return this.zaa.zan(this, (RegisterListenerMethod)var1_1, (UnregisterListenerMethod)var2_2, zab2);
    }

    @KeepForSdk
    @NonNull
    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(@NonNull RegistrationMethods<A, ?> methods) {
        Runnable runnable;
        Preconditions.checkNotNull(methods);
        Preconditions.checkNotNull(((RegistrationMethods)((Object)runnable)).register.getListenerKey(), (Object)"Listener has already been released.");
        UnregisterListenerMethod unregisterListenerMethod = ((RegistrationMethods)((Object)runnable)).zaa;
        Preconditions.checkNotNull(unregisterListenerMethod.getListenerKey(), (Object)"Listener has already been released.");
        RegisterListenerMethod registerListenerMethod = ((RegistrationMethods)((Object)runnable)).register;
        runnable = ((RegistrationMethods)((Object)runnable)).zab;
        return this.zaa.zan(this, registerListenerMethod, unregisterListenerMethod, runnable);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey) {
        void var1_1;
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey<?>)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<Boolean> doUnregisterEventListener(@NonNull ListenerHolder.ListenerKey<?> listenerKey, int methodKey) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listenerKey, (Object)"Listener key cannot be null.");
        return this.zaa.zao(this, (ListenerHolder.ListenerKey)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public <L> ListenerHolder<L> registerListener(@NonNull L listener, @NonNull String listenerType) {
        void var2_2;
        return ListenerHolders.createListenerHolder(listener, this.zah, (String)var2_2);
    }

    @KeepForSdk
    @NonNull
    protected Task<Boolean> disconnectService() {
        return this.zaa.zaj(this);
    }

    @KeepForSdk
    @NonNull
    public O getApiOptions() {
        return (O)this.zaf;
    }

    @Override
    @NonNull
    public final ApiKey<O> getApiKey() {
        return this.zag;
    }

    @KeepForSdk
    @NonNull
    public GoogleApiClient asGoogleApiClient() {
        return this.zaj;
    }

    @KeepForSdk
    @NonNull
    public Looper getLooper() {
        return this.zah;
    }

    @KeepForSdk
    @NonNull
    public Context getApplicationContext() {
        return this.zab;
    }

    @Deprecated
    @KeepForSdk
    @Nullable
    protected String getContextFeatureId() {
        return this.zac;
    }

    @KeepForSdk
    @Nullable
    protected String getContextAttributionTag() {
        return this.zac;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    protected ClientSettings.Builder createClientSettingsBuilder() {
        void var1_9;
        void var1_6;
        GoogleSignInAccount googleSignInAccount;
        ClientSettings.Builder builder = new ClientSettings.Builder();
        Api.ApiOptions apiOptions = this.zaf;
        boolean bl = apiOptions instanceof Api.ApiOptions.HasGoogleSignInAccountOptions;
        if (bl && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions).getGoogleSignInAccount()) != null) {
            Account account = googleSignInAccount.getAccount();
        } else if (apiOptions instanceof Api.ApiOptions.HasAccountOptions) {
            Account account = ((Api.ApiOptions.HasAccountOptions)apiOptions).getAccount();
        } else {
            Object var1_13 = null;
        }
        builder.zaa((Account)var1_6);
        if (bl) {
            GoogleSignInAccount googleSignInAccount2 = ((Api.ApiOptions.HasGoogleSignInAccountOptions)apiOptions).getGoogleSignInAccount();
            if (googleSignInAccount2 == null) {
                Set set = Collections.emptySet();
            } else {
                Set<Scope> set = googleSignInAccount2.getRequestedScopes();
            }
        } else {
            Set set = Collections.emptySet();
        }
        builder.zab((Collection)var1_9);
        ClientSettings.Builder builder2 = builder;
        Context context = this.zab;
        builder2.zac(context.getClass().getName());
        builder2.setRealClientPackageName(context.getPackageName());
        return builder;
    }

    @Nullable
    protected String getApiFallbackAttributionTag(@NonNull Context context) {
        return null;
    }

    private final BaseImplementation.ApiMethodImpl zad(int n, @NonNull BaseImplementation.ApiMethodImpl apiMethodImpl) {
        apiMethodImpl.zak();
        this.zaa.zak(this, n, apiMethodImpl);
        return apiMethodImpl;
    }

    private final Task zae(int n, @NonNull TaskApiCall taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StatusExceptionMapper statusExceptionMapper = this.zak;
        this.zaa.zal(this, n, taskApiCall, taskCompletionSource, statusExceptionMapper);
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final Api.Client zaa(Looper object, zabk zabk2) {
        ClientSettings clientSettings = ((GoogleApi)this).createClientSettingsBuilder().build();
        Api.ApiOptions apiOptions = ((GoogleApi)this).zaf;
        zabk zabk3 = zabk2;
        object = ((Api.AbstractClientBuilder)Preconditions.checkNotNull((Object)((GoogleApi)this).zae.zab())).buildClient(((GoogleApi)this).zab, (Looper)object, clientSettings, apiOptions, zabk3, zabk3);
        zabk2 = ((GoogleApi)this).zad;
        if (zabk2 == null || !(object instanceof BaseGmsClient)) {
            if (zabk2 == null || !(object instanceof NonGmsServiceBrokerClient)) {
                if ((this = ((GoogleApi)this).getContextAttributionTag()) != null && object instanceof BaseGmsClient) {
                    ((BaseGmsClient)object).setAttributionTag((String)this);
                }
                if (this != null && object instanceof NonGmsServiceBrokerClient) {
                    ((NonGmsServiceBrokerClient)object).zaa((String)this);
                }
                return object;
            }
            ((NonGmsServiceBrokerClient)object).zab((AttributionSourceWrapper)zabk2);
            return object;
        }
        ((BaseGmsClient)object).setAttributionSourceWrapper((AttributionSourceWrapper)zabk2);
        return object;
    }

    public final int zab() {
        return this.zai;
    }

    public final zacm zac(Context context, Handler handler) {
        return new zacm(context, handler, this.createClientSettingsBuilder().build());
    }

    @KeepForSdk
    public static class Settings {
        @KeepForSdk
        @NonNull
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        @NonNull
        public final StatusExceptionMapper zaa;
        @NonNull
        public final Looper zab;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        private Settings(StatusExceptionMapper mapper, Account account, Looper looper) {
            void var3_3;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var3_3;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, byte[] byArray) {
            this(statusExceptionMapper, null, looper);
        }

        @KeepForSdk
        public static class Builder {
            private StatusExceptionMapper zaa;
            private Looper zab;

            @KeepForSdk
            public Builder() {
            }

            /*
             * WARNING - void declaration
             */
            @KeepForSdk
            @NonNull
            public Builder setMapper(@NonNull StatusExceptionMapper mapper) {
                void var1_1;
                Preconditions.checkNotNull((Object)mapper, (Object)"StatusExceptionMapper must not be null.");
                this.zaa = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @KeepForSdk
            @NonNull
            public Builder setLooper(@NonNull Looper looper) {
                void var1_1;
                Preconditions.checkNotNull((Object)looper, (Object)"Looper must not be null.");
                this.zab = var1_1;
                return this;
            }

            @KeepForSdk
            @NonNull
            public Settings build() {
                if (this.zaa == null) {
                    this.zaa = new ApiExceptionMapper();
                }
                if (this.zab == null) {
                    this.zab = Looper.getMainLooper();
                }
                return new Settings(this.zaa, null, this.zab, null);
            }
        }
    }
}

