/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zab;
import com.google.android.gms.signin.SignInOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@KeepForSdk
public final class ClientSettings {
    @Nullable
    private final Account zaa;
    private final Set zab;
    private final Set zac;
    private final Map zad;
    private final int zae;
    @Nullable
    private final View zaf;
    private final String zag;
    private final String zah;
    private final SignInOptions zai;
    private Integer zaj;

    @KeepForSdk
    @NonNull
    public static ClientSettings createDefault(@NonNull Context context) {
        Context context2;
        return new GoogleApiClient.Builder(context2).zaa();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public ClientSettings(@NonNull Account account, @NonNull Set<Scope> scopes, @NonNull Map<Api<?>, zab> optionalApiSettingsMap, int gravityForPopups, @Nullable View viewForPopups, @NonNull String realClientPackageName, @NonNull String realClientClassName, @Nullable SignInOptions signInOptions) {
        this((Account)var1_1, (Set)var2_2, (Map)var3_3, (int)var4_4, (View)var5_5, (String)var6_6, (String)var7_7, (SignInOptions)var8_8, false);
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ClientSettings(@Nullable Account object, @NonNull Set iterator, @NonNull Map map, int n, @Nullable View view, @NonNull String string2, @NonNull String string3, @Nullable SignInOptions signInOptions, boolean bl) {
        this.zaa = object;
        object = iterator == null ? Collections.emptySet() : Collections.unmodifiableSet(iterator);
        this.zab = object;
        if (map == null) {
            map = Collections.emptyMap();
        }
        this.zad = map;
        this.zaf = view;
        this.zae = n;
        this.zag = string2;
        this.zah = string3;
        if (signInOptions == null) {
            signInOptions = SignInOptions.zaa;
        }
        this.zai = signInOptions;
        object = new HashSet(this.zab);
        iterator = this.zad.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zac = Collections.unmodifiableSet(object);
                return;
            }
            object.addAll(((zab)iterator.next()).zaa);
        }
    }

    @Deprecated
    @androidx.annotation.Nullable
    @KeepForSdk
    public String getAccountName() {
        ClientSettings this_ = this_.zaa;
        if (this_ != null) {
            return ((Account)this_).name;
        }
        return null;
    }

    @androidx.annotation.Nullable
    @KeepForSdk
    public Account getAccount() {
        return this.zaa;
    }

    @KeepForSdk
    @NonNull
    public Account getAccountOrDefault() {
        ClientSettings this_ = this_.zaa;
        if (this_ != null) {
            return this_;
        }
        return new Account("<<default account>>", "com.google");
    }

    @KeepForSdk
    public int getGravityForPopups() {
        return this.zae;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getRequiredScopes() {
        return this.zab;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getAllRequestedScopes() {
        return this.zac;
    }

    @KeepForSdk
    @NonNull
    public String getRealClientPackageName() {
        return this.zag;
    }

    @androidx.annotation.Nullable
    @KeepForSdk
    public View getViewForPopups() {
        return this.zaf;
    }

    @KeepForSdk
    @NonNull
    public Set<Scope> getApplicableScopes(@NonNull Api<?> api) {
        Object object;
        if ((object = (zab)((ClientSettings)((Object)this_)).zad.get(object)) == null || (object = ((zab)object).zaa).isEmpty()) {
            return ((ClientSettings)((Object)this_)).zab;
        }
        Set this_ = ((ClientSettings)((Object)this_)).zab;
        HashSet<Scope> hashSet = new HashSet<Scope>(this_);
        hashSet.addAll((Collection<Scope>)object);
        return hashSet;
    }

    @NonNull
    public final Map zaa() {
        return this.zad;
    }

    @androidx.annotation.Nullable
    public final String zab() {
        return this.zah;
    }

    @NonNull
    public final SignInOptions zac() {
        return this.zai;
    }

    @androidx.annotation.Nullable
    public final Integer zad() {
        return this.zaj;
    }

    public final void zae(@NonNull Integer n) {
        this.zaj = n;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private Account zaa;
        private ArraySet zab;
        private String zac;
        private String zad;
        private final SignInOptions zae = SignInOptions.zaa;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setRealClientPackageName(@NonNull String name) {
            void var1_1;
            this.zac = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public ClientSettings build() {
            return new ClientSettings(this.zaa, (Set)this.zab, null, 0, null, this.zac, this.zad, this.zae, false);
        }

        @NonNull
        public final Builder zaa(@Nullable Account account) {
            this.zaa = account;
            return this;
        }

        @NonNull
        public final Builder zab(@NonNull Collection collection) {
            if (this.zab == null) {
                this.zab = new ArraySet();
            }
            this.zab.addAll(collection);
            return this;
        }

        @NonNull
        public final Builder zac(@NonNull String string2) {
            this.zad = string2;
            return this;
        }
    }
}

