/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.internal.Preconditions;

@KeepName
public class GoogleApiActivity
extends Activity
implements DialogInterface.OnCancelListener {
    @VisibleForTesting
    protected int zaa = 0;

    protected final void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zaa = bundle.getInt("resolution");
        }
        if (this.zaa != 1) {
            this.zab();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onActivityResult(int n, int n2, @NonNull Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 1) {
            boolean bl = this.getIntent().getBooleanExtra("notify_manager", true);
            this.zaa = 0;
            this.setResult(n2, intent);
            if (bl) {
                GoogleApiManager googleApiManager = GoogleApiManager.zaa((Context)this);
                switch (n2) {
                    case 0: {
                        googleApiManager.zaq(new ConnectionResult(13, null), this.getIntent().getIntExtra("failing_client_id", -1));
                    }
                    default: {
                        break;
                    }
                    case -1: {
                        googleApiManager.zai();
                        break;
                    }
                }
            }
        } else if (n == 2) {
            this.zaa = 0;
            this.setResult(n2, intent);
        }
        this.finish();
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        bundle.putInt("resolution", this.zaa);
        super.onSaveInstanceState(bundle);
    }

    public final void onCancel(@NonNull DialogInterface dialogInterface) {
        this.zaa = 0;
        this.setResult(0);
        this.finish();
    }

    @NonNull
    public static Intent zaa(@NonNull Context context, @NonNull PendingIntent pendingIntent, int n, boolean bl) {
        Class<GoogleApiActivity> clazz = GoogleApiActivity.class;
        Intent intent = new Intent(context, clazz);
        intent.putExtra("pending_intent", (Parcelable)pendingIntent);
        intent.putExtra("failing_client_id", n);
        intent.putExtra("notify_manager", bl);
        return intent;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zab() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            Log.e((String)"GoogleApiActivity", (String)"Activity started without extras");
            this.finish();
            return;
        }
        PendingIntent pendingIntent = (PendingIntent)bundle.get("pending_intent");
        Integer n = (Integer)bundle.get("error_code");
        if (pendingIntent == null && n == null) {
            Log.e((String)"GoogleApiActivity", (String)"Activity started without resolution");
            this.finish();
            return;
        }
        if (pendingIntent == null) {
            int n2 = (Integer)Preconditions.checkNotNull((Object)n);
            GoogleApiActivity googleApiActivity = this;
            GoogleApiAvailability.getInstance().showErrorDialogFragment((Activity)googleApiActivity, n2, 2, (DialogInterface.OnCancelListener)googleApiActivity);
            this.zaa = 1;
            return;
        }
        try {
            this.startIntentSenderForResult(pendingIntent.getIntentSender(), 1, null, 0, 0, 0);
            this.zaa = 1;
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            block8: {
                block7: {
                    if (!bundle.getBoolean("notify_manager", true)) break block7;
                    GoogleApiManager.zaa((Context)this).zaq(new ConnectionResult(22, null), this.getIntent().getIntExtra("failing_client_id", -1));
                    break block8;
                    catch (IntentSender.SendIntentException sendIntentException) {
                        Log.e((String)"GoogleApiActivity", (String)"Failed to launch pendingIntent", (Throwable)sendIntentException);
                        this.finish();
                        return;
                    }
                }
                String string2 = pendingIntent.toString();
                int n3 = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n3 + 36);
                stringBuilder.append("Activity not found while launching ");
                stringBuilder.append(string2);
                stringBuilder.append(".");
                String string3 = stringBuilder.toString();
                if (Build.FINGERPRINT.contains("generic")) {
                    string3 = string3.concat(" This may occur when resolving Google Play services connection issues on emulators with Google APIs but not Google Play Store.");
                }
                Log.e((String)"GoogleApiActivity", (String)string3, (Throwable)activityNotFoundException);
            }
            this.zaa = 1;
            this.finish();
            return;
        }
    }
}

