/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.zaaa;
import com.google.android.gms.common.api.internal.zaab;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zabn;
import com.google.android.gms.common.api.internal.zac;
import com.google.android.gms.common.api.internal.zacd;
import com.google.android.gms.common.api.internal.zacl;
import com.google.android.gms.common.api.internal.zacm;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zai;
import com.google.android.gms.common.api.internal.zal;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.zap;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;

public final class zabk
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zat {
    private final Queue zab;
    private final Api.Client zac;
    private final ApiKey zad;
    private final zaaa zae;
    private final Set zaf;
    private final Map zag;
    private final int zah;
    @Nullable
    private final zacm zai;
    private boolean zaj;
    private final List zak;
    @Nullable
    private ConnectionResult zal;
    private int zam;
    final /* synthetic */ GoogleApiManager zaa;

    @WorkerThread
    public zabk(GoogleApiManager googleApiManager, GoogleApi googleApi) {
        Objects.requireNonNull(googleApiManager);
        this.zaa = googleApiManager;
        this.zab = new LinkedList();
        this.zaf = new HashSet();
        this.zag = new HashMap();
        this.zak = new ArrayList();
        this.zal = null;
        this.zam = 0;
        this.zac = googleApi.zaa(googleApiManager.zaF().getLooper(), this);
        this.zad = googleApi.getApiKey();
        this.zae = new zaaa();
        this.zah = googleApi.zab();
        if (this.zac.requiresSignIn()) {
            this.zai = googleApi.zac(googleApiManager.zaz(), googleApiManager.zaF());
            return;
        }
        this.zai = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle object) {
        object = this.zaa;
        Object object2 = ((GoogleApiManager)object).zaF();
        if (Looper.myLooper() == object2.getLooper()) {
            this.zaC();
            return;
        }
        object2 = new zabg(this);
        ((GoogleApiManager)object).zaF().post((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zaC() {
        this.zah();
        this.zaN(ConnectionResult.RESULT_SUCCESS);
        this.zaK();
        Iterator iterator = this.zag.values().iterator();
        while (iterator.hasNext()) {
            RegisterListenerMethod registerListenerMethod = ((zacd)iterator.next()).zaa;
            if (this.zaO(registerListenerMethod.getRequiredFeatures()) != null) {
                iterator.remove();
                continue;
            }
            try {
                registerListenerMethod.registerListener(this.zac, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(3);
                this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                break;
            }
            catch (RemoteException | RuntimeException throwable) {
                Log.e((String)"GoogleApiManager", (String)"Failed to register listener on re-connection.", (Throwable)throwable);
                iterator.remove();
            }
        }
        this.zaF();
        this.zaL();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        GoogleApiManager googleApiManager = this.zaa;
        Object object = googleApiManager.zaF();
        if (Looper.myLooper() == object.getLooper()) {
            this.zaD(n);
            return;
        }
        object = new zabh(this, n);
        googleApiManager.zaF().post((Runnable)object);
    }

    @WorkerThread
    private final void zaD(int n) {
        ((zabk)((Object)iterator)).zah();
        ((zabk)((Object)iterator)).zaj = true;
        String string2 = ((zabk)((Object)iterator)).zac.getLastDisconnectMessage();
        ((zabk)((Object)iterator)).zae.zae(n, string2);
        ApiKey apiKey = ((zabk)((Object)iterator)).zad;
        GoogleApiManager googleApiManager = ((zabk)((Object)iterator)).zaa;
        string2 = googleApiManager.zaF();
        googleApiManager.zaF().sendMessageDelayed(Message.obtain((Handler)string2, (int)9, (Object)apiKey), 5000L);
        string2 = googleApiManager.zaF();
        googleApiManager.zaF().sendMessageDelayed(Message.obtain((Handler)string2, (int)11, (Object)apiKey), 120000L);
        googleApiManager.zaB().zac();
        Iterator iterator = ((zabk)((Object)iterator)).zag.values().iterator();
        while (iterator.hasNext()) {
            ((zacd)iterator.next()).zac.run();
        }
    }

    @WorkerThread
    public final void zab(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        Api.Client client = this.zac;
        String string2 = client.getClass().getName();
        String string3 = String.valueOf(connectionResult);
        int n = String.valueOf(string2).length();
        int n2 = String.valueOf(string3).length();
        StringBuilder stringBuilder = new StringBuilder(n + 25 + n2);
        stringBuilder.append("onSignInFailed for ");
        stringBuilder.append(string2);
        stringBuilder.append(" with ");
        stringBuilder.append(string3);
        client.disconnect(stringBuilder.toString());
        this.zac(connectionResult, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zaE(@NonNull ConnectionResult connectionResult) {
        Object object = GoogleApiManager.zay();
        synchronized (object) {
            GoogleApiManager googleApiManager = this.zaa;
            zaab zaab2 = googleApiManager.zaD();
            if (zaab2 == null) return false;
            boolean bl = googleApiManager.zaE().contains(this.zad);
            if (!bl) return false;
            googleApiManager.zaD().zaf(connectionResult, this.zah);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public final void zaa(ConnectionResult connectionResult, Api api, boolean bl) {
        throw null;
    }

    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        this.zac(connectionResult, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zac(@NonNull ConnectionResult connectionResult, @Nullable Exception object) {
        GoogleApiManager googleApiManager = this.zaa;
        Preconditions.checkHandlerThread((Handler)googleApiManager.zaF());
        Object object2 = this.zai;
        if (object2 != null) {
            ((zacm)object2).zad();
        }
        this.zah();
        googleApiManager.zaB().zac();
        this.zaN(connectionResult);
        if (this.zac instanceof zap && connectionResult.getErrorCode() != 24) {
            googleApiManager.zax(true);
            googleApiManager.zaF().sendMessageDelayed(googleApiManager.zaF().obtainMessage(19), 300000L);
        }
        if (connectionResult.getErrorCode() == 4) {
            this.zaJ(GoogleApiManager.zav());
            return;
        }
        if (connectionResult.getErrorCode() == 25) {
            zabk zabk2 = this;
            zabk2.zaJ(GoogleApiManager.zau(zabk2.zad, connectionResult));
            return;
        }
        object2 = this.zab;
        if (object2.isEmpty()) {
            this.zal = connectionResult;
            return;
        }
        if (object != null) {
            Preconditions.checkHandlerThread((Handler)googleApiManager.zaF());
            this.zaI(null, (Exception)object, false);
            return;
        }
        if (!googleApiManager.zaG()) {
            zabk zabk3 = this;
            zabk3.zaJ(GoogleApiManager.zau(zabk3.zad, connectionResult));
            return;
        }
        object = this.zad;
        this.zaI(GoogleApiManager.zau((ApiKey)object, connectionResult), null, true);
        if (object2.isEmpty() || this.zaE(connectionResult) || googleApiManager.zap(connectionResult, this.zah)) {
            return;
        }
        if (connectionResult.getErrorCode() == 18) {
            this.zaj = true;
        }
        if (this.zaj) {
            googleApiManager.zaF().sendMessageDelayed(Message.obtain((Handler)googleApiManager.zaF(), (int)9, (Object)object), 5000L);
            return;
        }
        this.zaJ(GoogleApiManager.zau((ApiKey)object, connectionResult));
    }

    @WorkerThread
    private final void zaF() {
        Queue queue = this.zab;
        ArrayList arrayList = new ArrayList(queue);
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            zai zai2;
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    zai2 = (zai)arrayList.get(n2);
                    if (this.zac.isConnected()) break block6;
                }
                return;
            }
            if (this.zaG(zai2)) {
                queue.remove(zai2);
            }
            ++n2;
        }
    }

    @WorkerThread
    public final void zad(zai zai2) {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        if (this.zac.isConnected()) {
            if (this.zaG(zai2)) {
                this.zaL();
                return;
            }
            this.zab.add(zai2);
            return;
        }
        this.zab.add(zai2);
        zai2 = this.zal;
        if (zai2 != null && zai2.hasResolution()) {
            zabk zabk2 = this;
            zabk2.zac(zabk2.zal, null);
            return;
        }
        this.zam();
    }

    @WorkerThread
    public final void zae() {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        this.zaJ(GoogleApiManager.zaa);
        this.zae.zad();
        for (ListenerHolder.ListenerKey listenerKey : this.zag.keySet().toArray(new ListenerHolder.ListenerKey[0])) {
            this.zad(new zah(listenerKey, new TaskCompletionSource()));
        }
        this.zaN(new ConnectionResult(4));
        Api.Client client = this.zac;
        if (client.isConnected()) {
            client.onUserSignOut(new zabj(this));
            return;
        }
    }

    public final Api.Client zaf() {
        return this.zac;
    }

    public final Map zag() {
        return this.zag;
    }

    @WorkerThread
    public final void zah() {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        this.zal = null;
    }

    @WorkerThread
    @Nullable
    public final ConnectionResult zai() {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        return this.zal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private final boolean zaG(zai object) {
        StringBuilder stringBuilder;
        if (!(object instanceof zac)) {
            ((zabk)object5).zaH((zai)object);
            return true;
        }
        Object object2 = (zac)object;
        zabk zabk2 = object5;
        Object object3 = zabk2.zaO(((zac)object2).zaa(zabk2));
        if (object3 == null) {
            ((zabk)object5).zaH((zai)object);
            return true;
        }
        object = ((zabk)object5).zac.getClass().getName();
        Object object4 = object3.getName();
        long l = object3.getVersion();
        int n = String.valueOf(object).length();
        n += 53;
        int n2 = String.valueOf(object4).length();
        n = n + n2 + 2;
        n2 = String.valueOf(l).length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(n + n2 + 2);
        stringBuilder2.append((String)object);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder3.append(" could not execute call because it requires feature (");
        stringBuilder3.append((String)object4);
        stringBuilder.append(", ");
        stringBuilder.append(l);
        stringBuilder.append(").");
        object = stringBuilder.toString();
        Log.w((String)"GoogleApiManager", (String)object);
        object = ((zabk)object5).zaa;
        if (((GoogleApiManager)object).zaG() && ((zac)object2).zab((zabk)object5)) {
            Object object5;
            object2 = ((zabk)object5).zad;
            object2 = ((zabk)object5).zak;
            object4 = new zabl((ApiKey)object2, (Feature)object3, null);
            n = object2.indexOf(object4);
            if (n >= 0) {
                object5 = (zabl)object2.get(n);
                ((GoogleApiManager)object).zaF().removeMessages(15, object5);
                object5 = Message.obtain((Handler)((GoogleApiManager)object).zaF(), (int)15, (Object)object5);
                ((GoogleApiManager)object).zaF().sendMessageDelayed((Message)object5, 5000L);
                return false;
            }
            object2.add(object4);
            object2 = Message.obtain((Handler)((GoogleApiManager)object).zaF(), (int)15, (Object)object4);
            ((GoogleApiManager)object).zaF().sendMessageDelayed((Message)object2, 5000L);
            object2 = Message.obtain((Handler)((GoogleApiManager)object).zaF(), (int)16, (Object)object4);
            ((GoogleApiManager)object).zaF().sendMessageDelayed((Message)object2, 120000L);
            object2 = new ConnectionResult(2, null);
            object4 = ", version: ";
            if (!super.zaE((ConnectionResult)object2)) {
                if (!((GoogleApiManager)object).zap((ConnectionResult)object2, ((zabk)object5).zah)) return false;
                object5 = object3.getName();
                l = object3.getVersion();
                int n3 = String.valueOf(object5).length();
                int n4 = String.valueOf(l).length();
                Object object6 = object3 = new StringBuilder((n3 += 55) + n4);
                ((StringBuilder)object6).append("Notification displayed for missing feature: ");
                ((StringBuilder)object6).append((String)object5);
                ((StringBuilder)object3).append((String)object4);
                ((StringBuilder)object3).append(l);
                object5 = ((StringBuilder)object3).toString();
                Log.w((String)"GoogleApiManager", (String)object5);
                return false;
            }
            object5 = object3.getName();
            l = object3.getVersion();
            int n5 = String.valueOf(object5).length();
            int n6 = String.valueOf(l).length();
            Object object7 = object3 = new StringBuilder((n5 += 61) + n6);
            ((StringBuilder)object7).append("A dialog should be displayed for missing feature: ");
            ((StringBuilder)object7).append((String)object5);
            ((StringBuilder)object3).append((String)object4);
            ((StringBuilder)object3).append(l);
            object5 = ((StringBuilder)object3).toString();
            Log.w((String)"GoogleApiManager", (String)object5);
            return false;
        }
        ((zai)object2).zad((Exception)new UnsupportedApiCallException((Feature)object3));
        return true;
    }

    @WorkerThread
    private final void zaH(zai zai2) {
        zai2.zae(this.zae, this.zap());
        try {
            zai2.zaf(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaI(@Nullable Status status, @Nullable Exception exception, boolean bl) {
        Preconditions.checkHandlerThread((Handler)((zabk)((Object)iterator)).zaa.zaF());
        boolean bl2 = status == null;
        boolean bl3 = exception == null;
        if (bl2 == bl3) {
            throw new IllegalArgumentException("Status XOR exception should be null");
        }
        Iterator iterator = ((zabk)((Object)iterator)).zab.iterator();
        while (iterator.hasNext()) {
            zai zai2 = (zai)iterator.next();
            if (bl && zai2.zac != 2) continue;
            if (status != null) {
                zai2.zac(status);
            } else {
                zai2.zad(exception);
            }
            iterator.remove();
        }
        return;
    }

    @WorkerThread
    private final void zaJ(Status status) {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        this.zaI(status, null, false);
    }

    @WorkerThread
    public final void zaj() {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        if (this.zaj) {
            this.zam();
            return;
        }
    }

    @WorkerThread
    private final void zaK() {
        if (this.zaj) {
            GoogleApiManager googleApiManager = this.zaa;
            ApiKey apiKey = this.zad;
            googleApiManager.zaF().removeMessages(11, (Object)apiKey);
            googleApiManager.zaF().removeMessages(9, (Object)apiKey);
            this.zaj = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zak() {
        Object object = this.zaa;
        Preconditions.checkHandlerThread((Handler)((GoogleApiManager)object).zaF());
        if (!this.zaj) {
            return;
        }
        this.zaK();
        Context context = ((GoogleApiManager)object).zaz();
        if (((GoogleApiManager)object).zaA().isGooglePlayServicesAvailable(context) == 18) {
            object = "Connection timed out waiting for Google Play services update to complete.";
            object = new Status(21, (String)object);
        } else {
            object = "API failed to connect while resuming due to an unknown error.";
            object = new Status(22, (String)object);
        }
        this.zaJ((Status)object);
        this.zac.disconnect("Timing out connection while resuming.");
    }

    private final void zaL() {
        ApiKey apiKey = ((zabk)((Object)googleApiManager)).zad;
        GoogleApiManager googleApiManager = ((zabk)((Object)googleApiManager)).zaa;
        googleApiManager.zaF().removeMessages(12, (Object)apiKey);
        Handler handler = googleApiManager.zaF();
        googleApiManager.zaF().sendMessageDelayed(handler.obtainMessage(12, (Object)apiKey), googleApiManager.zaw());
    }

    @WorkerThread
    public final boolean zal() {
        return this.zaM(true);
    }

    @WorkerThread
    private final boolean zaM(boolean bl) {
        Api.Client client;
        block5: {
            block4: {
                Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
                client = this.zac;
                if (!client.isConnected() || !this.zag.isEmpty()) break block4;
                if (!this.zae.zac()) break block5;
                if (bl) {
                    this.zaL();
                }
            }
            return false;
        }
        client.disconnect("Timing out service connection.");
        return true;
    }

    @WorkerThread
    public final void zam() {
        Object object;
        Object object2;
        Object object3;
        GoogleApiManager googleApiManager;
        block8: {
            int n;
            Object object4;
            googleApiManager = this.zaa;
            Preconditions.checkHandlerThread((Handler)googleApiManager.zaF());
            object3 = " is not available: ";
            object2 = "The service for ";
            object = this.zac;
            if (object.isConnected() || object.isConnecting()) {
                return;
            }
            try {
                com.google.android.gms.common.internal.zal zal2 = googleApiManager.zaB();
                object4 = googleApiManager.zaz();
                n = zal2.zaa((Context)object4, (Api.Client)object);
                if (n == 0) break block8;
            }
            catch (IllegalStateException illegalStateException) {
                this.zac(new ConnectionResult(10), illegalStateException);
                return;
            }
            googleApiManager = new ConnectionResult(n, null);
            object = "GoogleApiManager";
            String string2 = this.zac.getClass().getName();
            object4 = googleApiManager.toString();
            int n2 = String.valueOf(string2).length();
            n2 += 35;
            StringBuilder stringBuilder = new StringBuilder(n2 += ((String)object4).length());
            stringBuilder.append((String)object2);
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
            stringBuilder.append((String)object4);
            Log.w((String)object, (String)stringBuilder.toString());
            this.zac((ConnectionResult)googleApiManager, null);
            return;
        }
        object3 = this.zad;
        object2 = new zabn(googleApiManager, (Api.Client)object, (ApiKey)object3);
        if (object.requiresSignIn()) {
            ((zacm)Preconditions.checkNotNull((Object)this.zai)).zac((zacl)object2);
        }
        try {
            object.connect((BaseGmsClient.ConnectionProgressReportCallbacks)object2);
            return;
        }
        catch (SecurityException securityException) {
            this.zac(new ConnectionResult(10), securityException);
            return;
        }
    }

    @WorkerThread
    public final void zan(zal zal2) {
        Preconditions.checkHandlerThread((Handler)this.zaa.zaF());
        this.zaf.add(zal2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zaN(ConnectionResult connectionResult) {
        Set set = this.zaf;
        Iterator iterator = set.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                set.clear();
                return;
            }
            zal zal2 = (zal)iterator.next();
            String string2 = com.google.android.gms.common.internal.Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS) ? this.zac.getEndpointPackageName() : null;
            zal2.zac(this.zad, connectionResult, string2);
        }
    }

    final boolean zao() {
        return this.zac.isConnected();
    }

    public final boolean zap() {
        return this.zac.requiresSignIn();
    }

    public final int zaq() {
        return this.zah;
    }

    @WorkerThread
    @Nullable
    private final Feature zaO(@Nullable Feature[] featureArray) {
        if (featureArray == null || featureArray.length == 0) {
            return null;
        }
        Feature[] featureArray2 = featureArray2.zac.getAvailableFeatures();
        if (featureArray2 == null) {
            featureArray2 = new Feature[]{};
        }
        ArrayMap arrayMap = new ArrayMap(featureArray2.length);
        for (int i = 0; i < featureArray2.length; ++i) {
            Feature feature = featureArray2[i];
            arrayMap.put(feature.getName(), feature.getVersion());
        }
        for (Feature feature : featureArray) {
            Long l = (Long)arrayMap.get(feature.getName());
            if (l != null && l >= feature.getVersion()) continue;
            return feature;
        }
        return null;
    }

    @WorkerThread
    final int zar() {
        return this.zam;
    }

    @WorkerThread
    final void zas() {
        ++this.zam;
    }

    final /* synthetic */ void zat() {
        this.zaC();
    }

    final /* synthetic */ void zau(int n) {
        this.zaD(n);
    }

    final /* synthetic */ void zav(Status status) {
        this.zaJ(status);
    }

    final /* synthetic */ boolean zaw(boolean bl) {
        return this.zaM(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zax(zabl zabl2) {
        if (!this.zak.contains(zabl2) || this.zaj) {
            return;
        }
        if (!this.zac.isConnected()) {
            this.zam();
            return;
        }
        this.zaF();
    }

    final /* synthetic */ void zay(zabl zabl2) {
        if (this.zak.remove(zabl2)) {
            GoogleApiManager googleApiManager = this.zaa;
            googleApiManager.zaF().removeMessages(15, (Object)zabl2);
            googleApiManager.zaF().removeMessages(16, (Object)zabl2);
            zabl2 = zabl2.zab();
            Queue queue = this.zab;
            ArrayList<zai> arrayList = new ArrayList<zai>(queue.size());
            for (zai zai2 : queue) {
                Object[] objectArray;
                if (!(zai2 instanceof zac) || (objectArray = ((zac)zai2).zaa(this)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)zabl2)) continue;
                arrayList.add(zai2);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zai zai3 = (zai)arrayList.get(i);
                queue.remove(zai3);
                zai3.zad((Exception)new UnsupportedApiCallException((Feature)zabl2));
            }
        }
    }

    final /* synthetic */ Api.Client zaz() {
        return this.zac;
    }

    final /* synthetic */ ApiKey zaA() {
        return this.zad;
    }

    final /* synthetic */ boolean zaB() {
        return this.zaj;
    }
}

