/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.OptionalPendingResultImpl;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.zac;
import com.google.android.gms.common.api.zad;
import com.google.android.gms.common.api.zae;
import com.google.android.gms.common.internal.Preconditions;

public final class PendingResults {
    @NonNull
    public static PendingResult<Status> immediatePendingResult(@NonNull Status result) {
        Status status;
        Preconditions.checkNotNull((Object)result, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static PendingResult<Status> immediatePendingResult(@NonNull Status result, @NonNull GoogleApiClient apiClient) {
        Status status;
        void var1_1;
        Preconditions.checkNotNull((Object)result, (Object)"Result must not be null");
        StatusPendingResult statusPendingResult = new StatusPendingResult((GoogleApiClient)var1_1);
        statusPendingResult.setResult(status);
        return statusPendingResult;
    }

    @NonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@NonNull R result) {
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        zae<R> zae2 = new zae<R>(null);
        zae2.setResult(r);
        return new OptionalPendingResultImpl(zae2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(@NonNull R result, @NonNull GoogleApiClient apiClient) {
        R r;
        void var1_1;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        zae<R> zae2 = new zae<R>((GoogleApiClient)var1_1);
        zae2.setResult(r);
        return new OptionalPendingResultImpl(zae2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <R extends Result> PendingResult<R> immediateFailedResult(@NonNull R result, @NonNull GoogleApiClient apiClient) {
        void var1_1;
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        Preconditions.checkArgument((boolean)(r.getStatus().isSuccess() ^ true), (Object)"Status code must not be SUCCESS");
        zad<R> zad2 = new zad<R>((GoogleApiClient)var1_1, r);
        zad2.setResult(r);
        return zad2;
    }

    @NonNull
    public static PendingResult<Status> canceledPendingResult() {
        StatusPendingResult statusPendingResult = new StatusPendingResult(Looper.getMainLooper());
        statusPendingResult.cancel();
        return statusPendingResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static <R extends Result> PendingResult<R> canceledPendingResult(@NonNull R result) {
        R r;
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
        boolean bl = r.getStatus().getStatusCode() == 16;
        Preconditions.checkArgument((boolean)bl, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zac zac2 = new zac(r);
        zac2.cancel();
        return zac2;
    }

    private PendingResults() {
    }
}

