/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.zaa;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@ShowFirstParty
@SafeParcelable.Class(creator="BitmapTeleporterCreator")
@KeepForSdk
public class BitmapTeleporter
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zaa();
    @SafeParcelable.VersionField(id=1)
    final int zaa;
    @SafeParcelable.Field(id=2)
    @Nullable
    ParcelFileDescriptor zab;
    @SafeParcelable.Field(id=3)
    final int zac;
    @Nullable
    private Bitmap zad;
    private boolean zae;
    private File zaf;

    @SafeParcelable.Constructor
    BitmapTeleporter(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=3) int n2) {
        this.zaa = n;
        this.zab = parcelFileDescriptor;
        this.zac = n2;
        this.zad = null;
        this.zae = false;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public BitmapTeleporter(@NonNull Bitmap teleportee) {
        void var1_1;
        this.zaa = 1;
        this.zab = null;
        this.zac = 0;
        this.zad = var1_1;
        this.zae = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @Nullable
    public Bitmap get() {
        Bitmap.Config config;
        int n;
        int n2;
        byte[] byArray;
        if (this.zae) return this.zad;
        Object object = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream((ParcelFileDescriptor)Preconditions.checkNotNull((Object)this.zab)));
        try {
            byArray = new byte[((DataInputStream)object).readInt()];
            n2 = ((DataInputStream)object).readInt();
            n = ((DataInputStream)object).readInt();
            config = Bitmap.Config.valueOf((String)((DataInputStream)object).readUTF());
            ((DataInputStream)object).read(byArray);
        }
        catch (Throwable throwable) {
            BitmapTeleporter.zaa((Closeable)object);
            throw throwable;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
        }
        BitmapTeleporter.zaa((Closeable)object);
        object = ByteBuffer.wrap(byArray);
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
        bitmap.copyPixelsFromBuffer((Buffer)object);
        this.zad = bitmap;
        this.zae = true;
        return this.zad;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        Object object;
        if (this.zab == null) {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = (Bitmap)Preconditions.checkNotNull((Object)this.zad);
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap2.getHeight());
            bitmap2.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            object = this.zaf;
            if (object == null) {
                throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
            }
            Object object2 = "teleporter";
            String string2 = ".tmp";
            object = File.createTempFile((String)object2, string2, (File)object);
            object2 = new FileOutputStream((File)object);
            this.zab = ParcelFileDescriptor.open((File)object, (int)0x10000000);
            ((File)object).delete();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);
            object = new DataOutputStream(bufferedOutputStream);
            ((DataOutputStream)object).writeInt(byArray.length);
            ((DataOutputStream)object).writeInt(bitmap.getWidth());
            ((DataOutputStream)object).writeInt(bitmap.getHeight());
            ((DataOutputStream)object).writeUTF(bitmap.getConfig().toString());
            ((FilterOutputStream)object).write(byArray);
            BitmapTeleporter.zaa((Closeable)object);
        }
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zaa);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zab, (int)(n |= 1), (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)this.zac);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        this.zab = null;
        return;
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        catch (Throwable throwable) {
            BitmapTeleporter.zaa((Closeable)object);
            throw throwable;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not write into unlinked file", iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public void release() {
        if (this.zae) return;
        try {
            ((ParcelFileDescriptor)Preconditions.checkNotNull((Object)this.zab)).close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setTempDir(@NonNull File tempDir) {
        void var1_1;
        if (tempDir == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zaf = var1_1;
    }

    private static final void zaa(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
            return;
        }
    }
}

