/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.os.ConfigurationCompat;
import com.google.android.gms.base.R;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.R;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.Locale;

public final class zac {
    private static final SimpleArrayMap zaa = new SimpleArrayMap();
    @Nullable
    private static Locale zab;

    @Nullable
    public static String zaa(Context context, int n) {
        Resources resources = context.getResources();
        switch (n) {
            default: {
                int n2 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n2 + 22);
                stringBuilder.append("Unexpected error code ");
                stringBuilder.append(n);
                String string2 = stringBuilder.toString();
                Log.e((String)"GoogleApiAvailability", (String)string2);
                return null;
            }
            case 4: 
            case 6: 
            case 18: {
                return null;
            }
            case 20: {
                Log.e((String)"GoogleApiAvailability", (String)"The current user profile is restricted and could not use authenticated features.");
                return zac.zah(context, "common_google_play_services_restricted_profile_title");
            }
            case 17: {
                Log.e((String)"GoogleApiAvailability", (String)"The specified account could not be signed in.");
                return zac.zah(context, "common_google_play_services_sign_in_failed_title");
            }
            case 16: {
                Log.e((String)"GoogleApiAvailability", (String)"One of the API components you attempted to connect to is not available.");
                return null;
            }
            case 11: {
                Log.e((String)"GoogleApiAvailability", (String)"The application is not licensed to the user.");
                return null;
            }
            case 10: {
                Log.e((String)"GoogleApiAvailability", (String)"Developer error occurred. Please see logs for detailed information");
                return null;
            }
            case 9: {
                Log.e((String)"GoogleApiAvailability", (String)"Google Play services is invalid. Cannot recover.");
                return null;
            }
            case 8: {
                Log.e((String)"GoogleApiAvailability", (String)"Internal error occurred. Please see logs for detailed information");
                return null;
            }
            case 7: {
                Log.e((String)"GoogleApiAvailability", (String)"Network error occurred. Please retry request later.");
                return zac.zah(context, "common_google_play_services_network_error_title");
            }
            case 5: {
                Log.e((String)"GoogleApiAvailability", (String)"An invalid account was specified when connecting. Please provide a valid account.");
                return zac.zah(context, "common_google_play_services_invalid_account_title");
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_title);
            }
            case 2: {
                return resources.getString(R.string.common_google_play_services_update_title);
            }
            case 1: 
        }
        return resources.getString(R.string.common_google_play_services_install_title);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static String zab(Context context, int n) {
        String string2 = n == 6 ? zac.zah(context, "common_google_play_services_resolution_required_title") : zac.zaa(context, n);
        if (string2 == null) {
            return context.getResources().getString(R.string.common_google_play_services_notification_ticker);
        }
        return string2;
    }

    @NonNull
    public static String zac(Context context, int n) {
        Resources resources = context.getResources();
        String string2 = zac.zaf(context);
        switch (n) {
            case 20: {
                return zac.zag(context, "common_google_play_services_restricted_profile_text", string2);
            }
            case 18: {
                return resources.getString(R.string.common_google_play_services_updating_text, new Object[]{string2});
            }
            case 17: {
                return zac.zag(context, "common_google_play_services_sign_in_failed_text", string2);
            }
            case 16: {
                return zac.zag(context, "common_google_play_services_api_unavailable_text", string2);
            }
            case 9: {
                return resources.getString(R.string.common_google_play_services_unsupported_text, new Object[]{string2});
            }
            case 7: {
                return zac.zag(context, "common_google_play_services_network_error_text", string2);
            }
            case 5: {
                return zac.zag(context, "common_google_play_services_invalid_account_text", string2);
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_text, new Object[]{string2});
            }
            case 2: {
                if (DeviceProperties.isWearableWithoutPlayStore((Context)context)) {
                    return resources.getString(R.string.common_google_play_services_wear_update_text);
                }
                return resources.getString(R.string.common_google_play_services_update_text, new Object[]{string2});
            }
            default: {
                return resources.getString(R.string.common_google_play_services_unknown_issue, new Object[]{string2});
            }
            case 1: 
        }
        return resources.getString(R.string.common_google_play_services_install_text, new Object[]{string2});
    }

    @NonNull
    public static String zad(Context context, int n) {
        if (n == 6 || n == 19) {
            String string2 = zac.zaf(context);
            return zac.zag(context, "common_google_play_services_resolution_required_text", string2);
        }
        return zac.zac(context, n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static String zae(Context object, int n) {
        void var0_3;
        void var1_7;
        Resources resources = object.getResources();
        switch (var1_7) {
            default: {
                String string2 = resources.getString(17039370);
                return var0_3;
            }
            case 3: {
                String string3 = resources.getString(R.string.common_google_play_services_enable_button);
                return var0_3;
            }
            case 2: {
                String string4 = resources.getString(R.string.common_google_play_services_update_button);
                return var0_3;
            }
            case 1: 
        }
        String string5 = resources.getString(R.string.common_google_play_services_install_button);
        return var0_3;
    }

    public static String zaf(Context object) {
        String string2 = object.getPackageName();
        try {
            object = ((Object)Wrappers.packageManager((Context)object).getApplicationLabel(string2)).toString();
            return object;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            object = object.getApplicationInfo().name;
            if (TextUtils.isEmpty((CharSequence)object)) {
                return string2;
            }
            return object;
        }
    }

    private static String zag(Context object, String string2, String string3) {
        Resources resources = object.getResources();
        if ((object = zac.zah(object, string2)) == null) {
            object = resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        return String.format(resources.getConfiguration().locale, (String)object, string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String zah(Context object, String string2) {
        SimpleArrayMap simpleArrayMap = zaa;
        String string3 = "Got empty resource: ";
        String string4 = "Missing resource: ";
        synchronized (simpleArrayMap) {
            Object object2 = ConfigurationCompat.getLocales((Configuration)object.getResources().getConfiguration()).get(0);
            boolean bl = ((Locale)object2).equals(zab);
            if (!bl) {
                simpleArrayMap.clear();
                zab = object2;
            }
            if ((object2 = (String)simpleArrayMap.get((Object)string2)) != null) {
                return object2;
            }
            if ((object = GooglePlayServicesUtil.getRemoteResource(object)) == null) {
                return null;
            }
            int n = object.getIdentifier(string2, "string", "com.google.android.gms");
            if (n == 0) {
                object = "GoogleApiAvailability";
                int n2 = string2.length() + 18;
                StringBuilder stringBuilder = new StringBuilder(n2);
                stringBuilder.append(string4);
                stringBuilder.append(string2);
                Log.w((String)object, (String)stringBuilder.toString());
                return null;
            }
            int n3 = TextUtils.isEmpty((CharSequence)(object = object.getString(n)));
            if (n3 != 0) {
                object = "GoogleApiAvailability";
                n3 = string2.length() + 20;
                StringBuilder stringBuilder = new StringBuilder(n3);
                stringBuilder.append(string3);
                stringBuilder.append(string2);
                Log.w((String)object, (String)stringBuilder.toString());
                return null;
            }
            simpleArrayMap.put((Object)string2, object);
            return object;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

