/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zaat;
import com.google.android.gms.common.api.internal.zaau;
import com.google.android.gms.common.api.internal.zaav;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zaax;
import com.google.android.gms.common.api.internal.zaay;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zacs;
import com.google.android.gms.common.api.internal.zacu;
import com.google.android.gms.common.api.internal.zak;
import com.google.android.gms.common.api.internal.zax;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.internal.zaj;
import com.google.android.gms.common.util.ClientLibraryUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zaaz
extends GoogleApiClient
implements zabu {
    private final Lock zaj;
    private final com.google.android.gms.common.internal.zak zak;
    @Nullable
    private zabv zal = null;
    private final int zam;
    private final Context zan;
    private final Looper zao;
    @VisibleForTesting
    final Queue zaa = new LinkedList();
    private volatile boolean zap;
    private long zaq;
    private long zar;
    private final zaax zas;
    private final GoogleApiAvailability zat;
    @Nullable
    @VisibleForTesting
    zabs zab;
    final Map zac;
    Set zad;
    final ClientSettings zae;
    final Map zaf;
    final Api.AbstractClientBuilder zag;
    private final ListenerHolders zau;
    private final ArrayList zav;
    private Integer zaw;
    @Nullable
    Set zah;
    final zacu zai;
    private final zaj zax;

    /*
     * Enabled aggressive block sorting
     */
    public zaaz(Context object, Lock object22, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder abstractClientBuilder, Map map, List list, List list2, Map map2, int n, int n2, ArrayList arrayList) {
        long l = true != ClientLibraryUtils.isPackageSide() ? 120000L : 10000L;
        this.zaq = l;
        this.zar = 5000L;
        this.zad = new HashSet();
        this.zau = new ListenerHolders();
        this.zaw = null;
        this.zah = null;
        this.zax = new zaat(this);
        this.zan = object;
        this.zaj = object22;
        this.zak = new com.google.android.gms.common.internal.zak(looper, this.zax);
        this.zao = looper;
        this.zas = new zaax(this, looper);
        this.zat = googleApiAvailability;
        this.zam = n;
        if (n >= 0) {
            this.zaw = n2;
        }
        this.zaf = map;
        this.zac = map2;
        this.zav = arrayList;
        this.zai = new zacu();
        for (Object object22 : list) {
            this.zak.zaf((GoogleApiClient.ConnectionCallbacks)object22);
        }
        object = list2.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.zae = clientSettings;
                this.zag = abstractClientBuilder;
                return;
            }
            object22 = (GoogleApiClient.OnConnectionFailedListener)object.next();
            this.zak.zai((GoogleApiClient.OnConnectionFailedListener)object22);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T object) {
        void var1_2;
        Object object2 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object2 = object2 != null ? ((Api)object2).zad() : "the API";
        int n = String.valueOf(object2).length();
        StringBuilder stringBuilder = new StringBuilder(n + 65);
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object2);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        object2 = this.zaj;
        object2.lock();
        try {
            zabv zabv2 = this.zal;
            if (zabv2 == null) {
                this.zaa.add(object);
            } else {
                BaseImplementation.ApiMethodImpl apiMethodImpl = zabv2.zab((BaseImplementation.ApiMethodImpl)object);
            }
            object2.unlock();
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        return var1_2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T object) {
        BaseImplementation.ApiMethodImpl apiMethodImpl;
        Object object2;
        Object object3 = ((BaseImplementation.ApiMethodImpl)object).getApi();
        boolean bl = this.zac.containsKey(((BaseImplementation.ApiMethodImpl)object).getClientKey());
        object3 = object3 != null ? ((Api)object3).zad() : "the API";
        int n = String.valueOf(object3).length();
        StringBuilder stringBuilder = new StringBuilder(n + 65);
        stringBuilder.append("GoogleApiClient is not configured to use ");
        stringBuilder.append((String)object3);
        stringBuilder.append(" required for this call.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        object3 = this.zaj;
        object3.lock();
        try {
            object2 = this.zal;
            if (object2 == null) throw new IllegalStateException("GoogleApiClient is not connected yet.");
            n = this.zap ? 1 : 0;
            if (n != 0) {
                boolean bl2;
                object2 = this.zaa;
                object2.add(object);
                while (!(bl2 = object2.isEmpty())) {
                    BaseImplementation.ApiMethodImpl apiMethodImpl2 = (BaseImplementation.ApiMethodImpl)object2.remove();
                    this.zai.zaa(apiMethodImpl2);
                    apiMethodImpl2.setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object3.unlock();
                return (T)object;
            }
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        {
            apiMethodImpl = object2.zac((BaseImplementation.ApiMethodImpl)object);
            this.zaj.unlock();
        }
        return (T)apiMethodImpl;
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L object) {
        this.zaj.lock();
        try {
            ListenerHolders listenerHolders = this.zau;
            Looper looper = this.zao;
            object = listenerHolders.zaa(object, looper, "NO_TYPE");
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        this.zaj.unlock();
        return object;
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = (Api.Client)this.zac.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zac.containsKey(api.zac());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((zaaz)((Object)client)).isConnected()) {
            return false;
        }
        Api.Client client = (Api.Client)((zaaz)((Object)client)).zac.get(api.zac());
        return client != null && client.isConnected();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> object) {
        String string2;
        Object object2;
        block9: {
            object2 = ((zaaz)object3).zaj;
            object2.lock();
            string2 = " was never registered with GoogleApiClient";
            String string3 = " requested in getConnectionResult is not connected but is not present in the failed  connections map";
            try {
                int n = ((zaaz)object3).isConnected();
                if (n != 0 || (n = ((zaaz)object3).zap) != 0) {
                    n = ((zaaz)object3).zac.containsKey(((Api)object).zac());
                    if (n != 0) {
                        string2 = ((zabv)Preconditions.checkNotNull((Object)((zaaz)object3).zal)).zad((Api)object);
                        if (string2 == null) {
                            Object object3;
                            boolean bl = ((zaaz)object3).zap;
                            if (bl) {
                                object3 = ConnectionResult.RESULT_SUCCESS;
                            } else {
                                Log.w((String)"GoogleApiClientImpl", (String)((zaaz)object3).zae());
                                String string4 = "GoogleApiClientImpl";
                                object = ((Api)object).zad();
                                n = String.valueOf(object).length();
                                StringBuilder stringBuilder = new StringBuilder(n += 100);
                                stringBuilder.append((String)object);
                                stringBuilder.append(string3);
                                Log.wtf((String)string4, (String)stringBuilder.toString(), (Throwable)new Exception());
                                object3 = object = new ConnectionResult(8, null);
                            }
                            object2.unlock();
                            return object3;
                        }
                        object2.unlock();
                        return string2;
                    }
                    break block9;
                }
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            catch (Throwable throwable) {
                ((zaaz)object3).zaj.unlock();
                throw throwable;
            }
        }
        object = ((Api)object).zad();
        int n = String.valueOf(object).length();
        StringBuilder stringBuilder = new StringBuilder(n += 42);
        stringBuilder.append((String)object);
        stringBuilder.append(string2);
        object2 = new IllegalArgumentException(stringBuilder.toString());
        throw object2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect() {
        boolean bl;
        String string2;
        int n;
        block16: {
            Lock lock = this.zaj;
            lock.lock();
            try {
                int n2 = this.zam;
                if (n2 >= 0) {
                    Integer n3 = this.zaw;
                    boolean bl2 = n3 != null;
                    Preconditions.checkState((boolean)bl2, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
                } else {
                    Integer n4 = this.zaw;
                    if (n4 == null) {
                        this.zaw = zaaz.zaf(this.zac.values(), false);
                    } else {
                        int n5 = n4;
                        if (n5 == 2) {
                            throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                        }
                    }
                }
                n = (Integer)Preconditions.checkNotNull((Object)this.zaw);
                string2 = "Illegal sign-in mode: ";
                lock.lock();
                if (n != 3) {
                    if (n != 1) {
                        if (n == 2) {
                            n = 2;
                            bl = true;
                            break block16;
                        } else {
                            bl = false;
                        }
                        break block16;
                    }
                    bl = true;
                    break block16;
                }
                bl = true;
            }
            catch (Throwable throwable) {
                this.zaj.unlock();
                throw throwable;
            }
        }
        int n6 = String.valueOf(n).length() + 22;
        StringBuilder stringBuilder = new StringBuilder(n6);
        stringBuilder.append(string2);
        stringBuilder.append(n);
        string2 = stringBuilder.toString();
        Preconditions.checkArgument((boolean)bl, (Object)string2);
        this.zam(n);
        this.zan();
        Lock lock = this.zaj;
        lock.unlock();
        lock.unlock();
        return;
        catch (Throwable throwable) {}
        this.zaj.unlock();
        throw throwable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void connect(int n) {
        boolean bl;
        String string2;
        block6: {
            block7: {
                this.zaj.lock();
                string2 = "Illegal sign-in mode: ";
                if (n == 3) break block7;
                if (n != 1) {
                    if (n == 2) {
                        n = 2;
                        bl = true;
                        break block6;
                    } else {
                        bl = false;
                    }
                    break block6;
                } else {
                    bl = true;
                }
                break block6;
            }
            bl = true;
        }
        try {
            int n2 = String.valueOf(n).length() + 22;
            StringBuilder stringBuilder = new StringBuilder(n2);
            stringBuilder.append(string2);
            stringBuilder.append(n);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            this.zam(n);
            this.zan();
            this.zaj.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect() {
        int n = Looper.myLooper() != Looper.getMainLooper() ? 1 : 0;
        Preconditions.checkState(n != 0, (Object)"blockingConnect must not be called on the UI thread");
        Lock lock = zaaz3.zaj;
        lock.lock();
        try {
            n = zaaz3.zam;
            if (n >= 0) {
                Integer n2 = zaaz3.zaw;
                boolean bl = n2 != null;
                Preconditions.checkState((boolean)bl, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else {
                Integer n3 = zaaz3.zaw;
                if (n3 == null) {
                    zaaz3.zaw = zaaz.zaf(zaaz3.zac.values(), false);
                } else {
                    int n4 = n3;
                    if (n4 == 2) {
                        throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                    }
                }
            }
            zaaz zaaz2 = zaaz3;
            zaaz2.zam((Integer)Preconditions.checkNotNull((Object)zaaz2.zaw));
            zaaz3.zak.zab();
            zaaz zaaz3 = ((zabv)Preconditions.checkNotNull((Object)zaaz3.zal)).zaf();
            lock.unlock();
            return zaaz3;
        }
        catch (Throwable throwable) {
            zaaz3.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        boolean bl = Looper.myLooper() != Looper.getMainLooper();
        Preconditions.checkState((boolean)bl, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        Lock lock = zaaz3.zaj;
        lock.lock();
        try {
            Integer n = zaaz3.zaw;
            if (n == null) {
                zaaz3.zaw = zaaz.zaf(zaaz3.zac.values(), false);
            } else {
                int n2 = n;
                if (n2 == 2) {
                    throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
                }
            }
            zaaz zaaz2 = zaaz3;
            zaaz2.zam((Integer)Preconditions.checkNotNull((Object)zaaz2.zaw));
            zaaz3.zak.zab();
            zaaz zaaz3 = ((zabv)Preconditions.checkNotNull((Object)zaaz3.zal)).zag(l, timeUnit);
            lock.unlock();
            return zaaz3;
        }
        catch (Throwable throwable) {
            zaaz3.zaj.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void disconnect() {
        Lock lock = this.zaj;
        lock.lock();
        try {
            boolean bl;
            this.zai.zab();
            Object object = this.zal;
            if (object != null) {
                object.zah();
            }
            this.zau.zab();
            object = this.zaa;
            Iterator iterator = object.iterator();
            while (bl = iterator.hasNext()) {
                BaseImplementation.ApiMethodImpl apiMethodImpl = (BaseImplementation.ApiMethodImpl)iterator.next();
                apiMethodImpl.zan(null);
                apiMethodImpl.cancel();
            }
            object.clear();
            object = this.zal;
            if (object != null) {
                this.zad();
                this.zak.zaa();
            }
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        lock.unlock();
    }

    @Override
    public final void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Integer n = this.zaw;
        boolean bl = n != null ? n != 2 : true;
        Preconditions.checkState((boolean)bl, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zac.containsKey(Common.CLIENT_KEY)) {
            zaaz zaaz2 = this;
            zaaz2.zal(zaaz2, statusPendingResult, false);
            return statusPendingResult;
        }
        AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
        zaau zaau2 = new zaau(this, atomicReference, statusPendingResult);
        zaav zaav2 = new zaav(this, statusPendingResult);
        Context context = this.zan;
        GoogleApiClient.Builder builder = new GoogleApiClient.Builder(context);
        builder.addApi(Common.API);
        builder.addConnectionCallbacks(zaau2);
        builder.addOnConnectionFailedListener(zaav2);
        builder.setHandler(this.zas);
        GoogleApiClient googleApiClient = builder.build();
        atomicReference.set(googleApiClient);
        googleApiClient.connect();
        return statusPendingResult;
    }

    private final void zal(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.zaa.zaa(googleApiClient).setResultCallback(new zaaw(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        int n = this.zam;
        if (n < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        com.google.android.gms.common.api.internal.zak.zaa(lifecycleActivity).zac(n);
    }

    @Override
    public final boolean isConnected() {
        zabv zabv2 = ((zaaz)((Object)zabv2)).zal;
        return zabv2 != null && zabv2.zai();
    }

    @Override
    public final boolean isConnecting() {
        zabv zabv2 = ((zaaz)((Object)zabv2)).zal;
        return zabv2 != null && zabv2.zaj();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zam(int n) {
        Integer n2 = ((zaaz)((Object)string2)).zaw;
        if (n2 == null) {
            ((zaaz)((Object)string2)).zaw = n;
        } else if (n2 != n) {
            String string2 = zaaz.zag(((zaaz)((Object)string2)).zaw);
            String string3 = zaaz.zag(n);
            n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 51 + string2.length());
            stringBuilder.append("Cannot use sign-in mode: ");
            stringBuilder.append(string3);
            stringBuilder.append(". Mode was already set to ");
            stringBuilder.append(string2);
            throw new IllegalStateException(stringBuilder.toString());
        }
        if (((zaaz)((Object)string2)).zal != null) {
            return;
        }
        Map map = ((zaaz)((Object)string2)).zac;
        Looper looper = map.values().iterator();
        n = 0;
        boolean bl = false;
        while (looper.hasNext()) {
            Api.Client client = (Api.Client)looper.next();
            n = client.requiresSignIn() | n;
            bl = client.providesSignIn() | bl;
        }
        switch (((zaaz)((Object)string2)).zaw) {
            case 1: {
                if (n == 0) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (n == 0) break;
                String string4 = string2;
                ((zaaz)((Object)string2)).zal = com.google.android.gms.common.api.internal.zax.zaa(((zaaz)((Object)string2)).zan, (zaaz)((Object)string4), ((zaaz)((Object)string2)).zaj, ((zaaz)((Object)string2)).zao, ((zaaz)((Object)string4)).zat, map, ((zaaz)((Object)string2)).zae, ((zaaz)((Object)string2)).zaf, ((zaaz)((Object)string2)).zag, ((zaaz)((Object)string2)).zav);
                return;
            }
        }
        Context context = ((zaaz)((Object)string2)).zan;
        Lock lock = ((zaaz)((Object)string2)).zaj;
        looper = ((zaaz)((Object)string2)).zao;
        GoogleApiAvailability googleApiAvailability = ((zaaz)((Object)string2)).zat;
        ClientSettings clientSettings = ((zaaz)((Object)string2)).zae;
        Map map2 = ((zaaz)((Object)string2)).zaf;
        Api.AbstractClientBuilder abstractClientBuilder = ((zaaz)((Object)string2)).zag;
        ArrayList arrayList = ((zaaz)((Object)string2)).zav;
        ((zaaz)((Object)string2)).zal = new zabd(context, (zaaz)((Object)string2), lock, looper, googleApiAvailability, map, clientSettings, map2, abstractClientBuilder, arrayList, (zabu)((Object)string2));
    }

    private final void zan() {
        this.zak.zab();
        ((zabv)Preconditions.checkNotNull((Object)this.zal)).zae();
    }

    final boolean zad() {
        if (!this.zap) {
            return false;
        }
        this.zap = false;
        zaax zaax2 = this.zas;
        zaax2.removeMessages(2);
        zaax2.removeMessages(1);
        zabs zabs2 = this.zab;
        if (zabs2 != null) {
            zabs2.zab();
            this.zab = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zaf(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zak.zag(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zak.zah(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zai(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zak.zaj(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zak.zak(onConnectionFailedListener);
    }

    @Override
    public final void zaa(@Nullable Bundle bundle) {
        Queue queue;
        while (!(queue = this.zaa).isEmpty()) {
            ((GoogleApiClient)this).execute((BaseImplementation.ApiMethodImpl)queue.remove());
        }
        this.zak.zac(bundle);
    }

    @Override
    public final void zab(ConnectionResult connectionResult) {
        if (!this.zat.isPlayServicesPossiblyUpdating(this.zan, connectionResult.getErrorCode())) {
            this.zad();
        }
        if (!this.zap) {
            com.google.android.gms.common.internal.zak zak2 = this.zak;
            zak2.zae(connectionResult);
            zak2.zaa();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zac(int n, boolean n2) {
        block5: {
            block4: {
                block6: {
                    block7: {
                        if (n != 1) break block5;
                        if (n2 != 0) break block6;
                        if (!this.zap) break block7;
                        n = 1;
                        break block5;
                    }
                    this.zap = true;
                    if (this.zab != null || ClientLibraryUtils.isPackageSide()) break block4;
                    try {
                        GoogleApiAvailability googleApiAvailability = this.zat;
                        Context context = this.zan.getApplicationContext();
                        this.zab = googleApiAvailability.zaf(context, new zaay(this));
                        break block4;
                    }
                    catch (SecurityException securityException) {}
                }
                n = 1;
                break block5;
            }
            zaax zaax2 = this.zas;
            zaax2.sendMessageDelayed(zaax2.obtainMessage(1), this.zaq);
            zaax2.sendMessageDelayed(zaax2.obtainMessage(2), this.zar);
            n = 1;
        }
        BasePendingResult[] basePendingResultArray = this.zai.zab.toArray(new BasePendingResult[0]);
        int n3 = basePendingResultArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            basePendingResultArray[n2].forceFailureUnlessReady(zacu.zaa);
        }
        com.google.android.gms.common.internal.zak zak2 = this.zak;
        zak2.zad(n);
        zak2.zaa();
        if (n == 2) {
            this.zan();
            return;
        }
    }

    @Override
    public final Context getContext() {
        return this.zan;
    }

    @Override
    public final Looper getLooper() {
        return this.zao;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        zabv zabv2 = ((zaaz)((Object)zabv2)).zal;
        return zabv2 != null && zabv2.zak(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        zabv zabv2 = ((zaaz)((Object)zabv2)).zal;
        if (zabv2 != null) {
            zabv2.zam();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zao(zacs zacs2) {
        this.zaj.lock();
        try {
            Set set = this.zah;
            if (set == null) {
                this.zah = new HashSet();
            }
            this.zah.add(zacs2);
        }
        catch (Throwable throwable) {
            this.zaj.unlock();
            throw throwable;
        }
        this.zaj.unlock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zap(zacs var1_1) {
        block14: {
            var2_7 = this.zaj;
            var2_7.lock();
            try {
                var3_8 = this.zah;
                if (var3_8 == null) {
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
                    break block14;
                }
            }
            catch (Throwable v0) {
                this.zaj.unlock();
                throw v0;
            }
            {
                var1_2 = var3_8.remove(var1_1);
                if (!var1_2) {
                    Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
                    break block14;
                }
                var2_7.lock();
            }
            try {
                var1_3 = this.zah;
                if (var1_3 != null) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            catch (Throwable var1_6) {
                ** continue;
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    this.zaj.unlock();
                    throw var1_6;
                }
            }
        }
lbl29:
        // 4 sources

        while (true) {
            this.zaj.unlock();
            return;
        }
lbl-1000:
        // 1 sources

        {
            var2_7.unlock();
lbl33:
            // 2 sources

            while (true) {
                var1_4 = this.zal;
                if (var1_4 == null) ** GOTO lbl29
                var1_4.zal();
                ** GOTO lbl29
                break;
            }
        }
lbl-1000:
        // 1 sources

        {
            var1_5 = var1_3.isEmpty();
            var1_5 ^= true;
        }
        {
            this.zaj.unlock();
            if (!var1_5) ** break;
            ** continue;
            ** continue;
        }
    }

    final String zae() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dump("", null, printWriter, null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(((zaaz)((Object)zabv2)).zan);
        printWriter.append(string2).append("mResuming=").print(((zaaz)((Object)zabv2)).zap);
        Collection collection = ((zaaz)((Object)zabv2)).zaa;
        printWriter.append(" mWorkQueue.size()=").print(collection.size());
        collection = ((zaaz)((Object)zabv2)).zai.zab;
        printWriter.append(" mUnconsumedApiCalls.size()=").println(collection.size());
        zabv zabv2 = ((zaaz)((Object)zabv2)).zal;
        if (zabv2 != null) {
            zabv2.zan(string2, fileDescriptor, printWriter, stringArray);
            return;
        }
    }

    public static int zaf(Iterable iterable, boolean bl) {
        Iterator iterator = iterable.iterator();
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            Api.Client client = (Api.Client)iterator.next();
            bl2 = client.requiresSignIn() | bl2;
            bl3 = client.providesSignIn() | bl3;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zag(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
            case 1: 
        }
        return "SIGN_IN_MODE_REQUIRED";
    }

    final /* synthetic */ void zah(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        this.zal(googleApiClient, statusPendingResult, true);
    }

    final /* synthetic */ void zai() {
        block3: {
            this.zaj.lock();
            try {
                boolean bl = this.zap;
                if (!bl) break block3;
            }
            catch (Throwable throwable) {
                this.zaj.unlock();
                throw throwable;
            }
            this.zan();
        }
        this.zaj.unlock();
    }

    final /* synthetic */ void zaj() {
        block3: {
            this.zaj.lock();
            try {
                boolean bl = this.zad();
                if (!bl) break block3;
            }
            catch (Throwable throwable) {
                this.zaj.unlock();
                throw throwable;
            }
            this.zan();
        }
        this.zaj.unlock();
    }

    final /* synthetic */ Context zak() {
        return this.zan;
    }
}

