/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.zabw;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.HandlerExecutor;
import java.util.concurrent.Executor;

@KeepForSdk
public final class ListenerHolder<L> {
    private final Executor zaa;
    @Nullable
    private volatile ListenerKey zab;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Looper looper, @NonNull L listener, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        String string2;
        this.zaa = new HandlerExecutor((Looper)string2);
        string2 = "Listener must not be null";
        this.zab = new ListenerKey<Object>(Preconditions.checkNotNull((Object)var2_2, (Object)string2), Preconditions.checkNotEmpty((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    ListenerHolder(@NonNull Executor executor, @NonNull L listener, @NonNull String listenerType) {
        void var3_3;
        void var2_2;
        String string2;
        this.zaa = (Executor)Preconditions.checkNotNull((Object)string2, (Object)"Executor must not be null");
        string2 = "Listener must not be null";
        this.zab = new ListenerKey<Object>(Preconditions.checkNotNull((Object)var2_2, (Object)string2), Preconditions.checkNotEmpty((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void notifyListener(@NonNull Notifier<? super L> notifier) {
        void var1_1;
        Preconditions.checkNotNull(notifier, (Object)"Notifier must not be null");
        zabw zabw2 = new zabw(this, (Notifier)var1_1);
        this.zaa.execute(zabw2);
    }

    @KeepForSdk
    public boolean hasListener() {
        return this.zab != null;
    }

    @KeepForSdk
    public void clear() {
        this.zab = null;
    }

    @Nullable
    @KeepForSdk
    public ListenerKey<L> getListenerKey() {
        return this.zab;
    }

    final /* synthetic */ void zaa(Notifier notifier) {
        ListenerKey listenerKey = ((ListenerHolder)((Object)listenerKey)).zab;
        if (listenerKey == null) {
            notifier.onNotifyListenerFailed();
            return;
        }
        try {
            notifier.notifyListener(listenerKey.zaa());
        }
        catch (RuntimeException runtimeException) {
            notifier.onNotifyListenerFailed();
            throw runtimeException;
        }
    }

    @KeepForSdk
    public static final class ListenerKey<L> {
        private final Object zaa;
        private final String zab;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        ListenerKey(L listener, String listenerType) {
            void var2_2;
            void var1_1;
            this.zaa = var1_1;
            this.zab = var2_2;
        }

        @KeepForSdk
        public boolean equals(@Nullable Object o) {
            ListenerKey listenerKey;
            if (this == listenerKey) {
                return true;
            }
            if (!(listenerKey instanceof ListenerKey)) {
                return false;
            }
            listenerKey = listenerKey;
            return this.zaa == listenerKey.zaa && this.zab.equals(listenerKey.zab);
        }

        @KeepForSdk
        public int hashCode() {
            return System.identityHashCode(this.zaa) * 31 + this.zab.hashCode();
        }

        @KeepForSdk
        @NonNull
        public String toIdString() {
            String string2 = this.zab;
            int n = System.identityHashCode(this.zaa);
            int n2 = String.valueOf(string2).length();
            int n3 = String.valueOf(n).length();
            StringBuilder stringBuilder = new StringBuilder(n2 + 1 + n3);
            stringBuilder.append(string2);
            stringBuilder.append("@");
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        final /* synthetic */ Object zaa() {
            return this.zaa;
        }
    }

    @KeepForSdk
    public static interface Notifier<L> {
        @KeepForSdk
        public void notifyListener(@NonNull L var1);

        @KeepForSdk
        public void onNotifyListenerFailed();
    }
}

