/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;
import java.util.Iterator;

public final class DataBufferUtils {
    @KeepForSdk
    @NonNull
    public static final String KEY_NEXT_PAGE_TOKEN = "next_page_token";
    @KeepForSdk
    @NonNull
    public static final String KEY_PREV_PAGE_TOKEN = "prev_page_token";

    private DataBufferUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(@NonNull DataBuffer<E> buffer) {
        DataBuffer<E> dataBuffer;
        ArrayList arrayList = new ArrayList(dataBuffer.getCount());
        try {
            boolean bl;
            Iterator<E> iterator = dataBuffer.iterator();
            while (bl = iterator.hasNext()) {
                arrayList.add(((Freezable)iterator.next()).freeze());
            }
        }
        catch (Throwable throwable) {
            dataBuffer.close();
            throw throwable;
        }
        dataBuffer.close();
        return arrayList;
    }

    public static boolean hasNextPage(@NonNull DataBuffer<?> buffer) {
        Bundle bundle = buffer.getMetadata();
        return bundle != null && bundle.getString(KEY_NEXT_PAGE_TOKEN) != null;
    }

    public static boolean hasPrevPage(@NonNull DataBuffer<?> buffer) {
        Bundle bundle = buffer.getMetadata();
        return bundle != null && bundle.getString(KEY_PREV_PAGE_TOKEN) != null;
    }

    public static boolean hasData(@NonNull DataBuffer<?> buffer) {
        DataBuffer<?> dataBuffer;
        return buffer != null && dataBuffer.getCount() > 0;
    }
}

