/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zaw;
import com.google.android.gms.signin.internal.zae;
import com.google.android.gms.signin.internal.zaf;
import com.google.android.gms.signin.internal.zai;
import com.google.android.gms.signin.internal.zak;

@KeepForSdk
public class SignInClientImpl
extends GmsClient<zaf>
implements com.google.android.gms.signin.zae {
    private final boolean zab;
    private final ClientSettings zac;
    private final Bundle zad;
    @Nullable
    private final Integer zae;
    public static final /* synthetic */ int zaa;

    public SignInClientImpl(@NonNull Context context, @NonNull Looper looper, boolean bl, @NonNull ClientSettings clientSettings, @NonNull Bundle bundle, @NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zab = true;
        this.zac = clientSettings;
        this.zad = bundle;
        this.zae = clientSettings.zad();
    }

    @Override
    public final boolean requiresSignIn() {
        return this.zab;
    }

    @NonNull
    protected final String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    @NonNull
    protected final String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    @NonNull
    protected final Bundle getGetServiceRequestExtraArgs() {
        Object object = this.zac;
        String string2 = ((ClientSettings)object).getRealClientPackageName();
        if (!this.getContext().getPackageName().equals(string2)) {
            object = ((ClientSettings)object).getRealClientPackageName();
            this.zad.putString("com.google.android.gms.signin.internal.realClientPackageName", (String)object);
        }
        return this.zad;
    }

    @KeepForSdk
    @NonNull
    public static Bundle createBundleFromClientSettings(@NonNull ClientSettings clientSettings) {
        ClientSettings clientSettings2;
        clientSettings.zac();
        Integer n = clientSettings2.zad();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)clientSettings2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", false);
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", false);
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
        bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", false);
        bundle.putString("com.google.android.gms.signin.internal.hostedDomain", null);
        bundle.putString("com.google.android.gms.signin.internal.logSessionId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", false);
        return bundle;
    }

    @Override
    public final int getMinApkVersion() {
        return 12451000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    protected final /* synthetic */ IInterface createServiceInterface(@NonNull IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (!(iInterface instanceof zaf)) return new zaf(iBinder);
        return (zaf)iInterface;
    }

    @Override
    public final void zab(@NonNull IAccountAccessor iAccountAccessor, boolean bl) {
        try {
            ((zaf)this.getService()).zaf(iAccountAccessor, (Integer)Preconditions.checkNotNull((Object)this.zae), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    @Override
    public final void zac() {
        try {
            ((zaf)this.getService()).zae((Integer)Preconditions.checkNotNull((Object)this.zae));
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zaa(zae zae2) {
        Preconditions.checkNotNull((Object)zae2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            Account account = ((SignInClientImpl)((Object)zaf2)).zac.getAccountOrDefault();
            boolean bl = "<<default account>>".equals(account.name);
            AbstractSafeParcelable abstractSafeParcelable = bl ? Storage.getInstance(zaf2.getContext()).getSavedDefaultGoogleSignInAccount() : null;
            Integer n = ((SignInClientImpl)((Object)zaf2)).zae;
            zaw zaw2 = new zaw(account, (Integer)Preconditions.checkNotNull((Object)n), (GoogleSignInAccount)abstractSafeParcelable);
            zaf zaf2 = (zaf)zaf2.getService();
            abstractSafeParcelable = new zai(1, zaw2);
            zaf2.zag((zai)abstractSafeParcelable, zae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zak zak2 = new zak(1, new ConnectionResult(8, null), null);
                zae2.zab(zak2);
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
                return;
            }
        }
    }

    @Override
    public final void zad() {
        SignInClientImpl signInClientImpl = this;
        signInClientImpl.connect((BaseGmsClient.ConnectionProgressReportCallbacks)new BaseGmsClient.LegacyClientCallbackAdapter((BaseGmsClient)signInClientImpl));
    }
}

