/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.c;
import com.google.android.gms.internal.jr;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BaseImplementation {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.gD();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                BaseImplementation.a(result);
                throw runtimeException;
            }
        }
    }

    public static abstract class AbstractPendingResult<R extends Result>
    implements b<R>,
    PendingResult<R> {
        private final Object Jp = new Object();
        protected final CallbackHandler<R> mHandler;
        private final CountDownLatch mr = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> Jq = new ArrayList();
        private ResultCallback<R> Jr;
        private volatile R Js;
        private volatile boolean Jt;
        private boolean Ju;
        private boolean Jv;
        private jr Jw;

        protected AbstractPendingResult(Looper looper) {
            this.mHandler = new CallbackHandler(looper);
        }

        protected AbstractPendingResult(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        protected abstract R c(Status var1);

        public final boolean isReady() {
            return this.mr.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R gA() {
            Object object = this.Jp;
            synchronized (object) {
                jx.a(!this.Jt, "Result has already been consumed.");
                jx.a(this.isReady(), "Result is not ready.");
                R r2 = this.Js;
                this.gB();
                return r2;
            }
        }

        @Override
        public final R await() {
            jx.a(Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            jx.a(!this.Jt, "Result has already been consumed");
            try {
                this.mr.await();
            }
            catch (InterruptedException interruptedException) {
                this.gC();
            }
            jx.a(this.isReady(), "Result is not ready.");
            return this.gA();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            jx.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread when time is greater than zero.");
            jx.a(!this.Jt, "Result has already been consumed.");
            try {
                boolean bl2 = this.mr.await(time, units);
                if (!bl2) {
                    this.gD();
                }
            }
            catch (InterruptedException interruptedException) {
                this.gC();
            }
            jx.a(this.isReady(), "Result is not ready.");
            return this.gA();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            jx.a(!this.Jt, "Result has already been consumed.");
            Object object = this.Jp;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gA());
                } else {
                    this.Jr = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            jx.a(!this.Jt, "Result has already been consumed.");
            jx.a(this.mHandler != null, "CallbackHandler has not been set before calling setResultCallback.");
            Object object = this.Jp;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.gA());
                } else {
                    this.Jr = callback;
                    this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            jx.a(!this.Jt, "Result has already been consumed.");
            Object object = this.Jp;
            synchronized (object) {
                if (this.isReady()) {
                    a2.m(this.Js.getStatus());
                } else {
                    this.Jq.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void a(jr jr2) {
            Object object = this.Jp;
            synchronized (object) {
                this.Jw = jr2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.Jp;
            synchronized (object) {
                if (this.Ju || this.Jt) {
                    return;
                }
                if (this.Jw != null) {
                    try {
                        this.Jw.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                BaseImplementation.a(this.Js);
                this.Jr = null;
                this.Ju = true;
                this.c(this.c(Status.KA));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.Jp;
            synchronized (object) {
                return this.Ju;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void b(R r2) {
            Object object = this.Jp;
            synchronized (object) {
                if (this.Jv || this.Ju) {
                    BaseImplementation.a(r2);
                    return;
                }
                jx.a(!this.isReady(), "Results have already been set");
                jx.a(!this.Jt, "Result has already been consumed");
                this.c(r2);
            }
        }

        protected void gB() {
            this.Jt = true;
            this.Js = null;
            this.Jr = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gC() {
            Object object = this.Jp;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Kx));
                    this.Jv = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gD() {
            Object object = this.Jp;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.c(Status.Kz));
                    this.Jv = true;
                }
            }
        }

        private void c(R r2) {
            this.Js = r2;
            this.Jw = null;
            this.mr.countDown();
            Status status = this.Js.getStatus();
            if (this.Jr != null) {
                this.mHandler.removeTimeoutMessages();
                if (!this.Ju) {
                    this.mHandler.sendResultCallback(this.Jr, this.gA());
                }
            }
            for (PendingResult.a a2 : this.Jq) {
                a2.m(status);
            }
            this.Jq.clear();
        }
    }

    public static abstract class a<R extends Result, A extends Api.a>
    extends AbstractPendingResult<R>
    implements c.d<A> {
        private final Api.c<A> Jn;
        private final GoogleApiClient Jx;
        private c.b Jy;

        protected a(Api.c<A> c2, GoogleApiClient googleApiClient) {
            super(googleApiClient.getLooper());
            this.Jn = jx.i(c2);
            this.Jx = googleApiClient;
        }

        public final a gE() {
            jx.b(this.Jx, (Object)"GoogleApiClient was not set.");
            this.Jx.b(this);
            return this;
        }

        @Override
        public final Api.c<A> gz() {
            return this.Jn;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void l(Status status) {
            jx.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.c(status));
        }

        @Override
        public void a(c.b b2) {
            this.Jy = b2;
        }

        @Override
        public int gF() {
            return 0;
        }

        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void gB() {
            super.gB();
            if (this.Jy != null) {
                this.Jy.b(this);
                this.Jy = null;
            }
        }

        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.l(status);
        }
    }

    public static interface b<R> {
        public void b(R var1);
    }
}

