/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.f;
import com.google.android.gms.common.api.g;
import com.google.android.gms.internal.jg;
import com.google.android.gms.internal.jm;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.kc;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class c
implements GoogleApiClient {
    private final Lock zO = new ReentrantLock();
    private final Condition JR = this.zO.newCondition();
    private final jm JS;
    private final int JT;
    private final Context mContext;
    private final Looper JF;
    final Queue<d<?>> JU = new LinkedList();
    private ConnectionResult JV;
    private int JW;
    private volatile int JX = 4;
    private volatile boolean JY;
    private boolean JZ = false;
    private int Ka;
    private long Kb = 120000L;
    private long Kc = 5000L;
    final Handler Kd;
    BroadcastReceiver Ke;
    private final Bundle Kf = new Bundle();
    private final Map<Api.c<?>, Api.a> Kg = new HashMap();
    private final List<String> Kh;
    private boolean Ki;
    private final Set<com.google.android.gms.common.api.d<?>> Kj = Collections.newSetFromMap(new WeakHashMap());
    final Set<d<?>> Kk = Collections.newSetFromMap(new ConcurrentHashMap());
    private final b Jy = new b(){

        @Override
        public void b(d<?> d2) {
            c.this.Kk.remove(d2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks Kl = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            c.this.zO.lock();
            try {
                if (c.this.JX == 1) {
                    if (connectionHint != null) {
                        c.this.Kf.putAll(connectionHint);
                    }
                    c.this.gJ();
                }
            }
            finally {
                c.this.zO.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            c.this.zO.lock();
            try {
                switch (cause) {
                    case 2: {
                        c.this.al(cause);
                        c.this.connect();
                        return;
                    }
                    case 1: {
                        if (c.this.gL()) {
                            return;
                        }
                        c.this.JY = true;
                        c.this.Ke = new a(c.this);
                        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
                        intentFilter.addDataScheme("package");
                        c.this.mContext.registerReceiver(c.this.Ke, intentFilter);
                        c.this.Kd.sendMessageDelayed(c.this.Kd.obtainMessage(1), c.this.Kb);
                        c.this.Kd.sendMessageDelayed(c.this.Kd.obtainMessage(2), c.this.Kc);
                        c.this.al(cause);
                        return;
                    }
                }
                return;
            }
            finally {
                c.this.zO.unlock();
            }
        }
    };
    private final jm.b Km = new jm.b(){

        @Override
        public boolean gN() {
            return c.this.Ki;
        }

        @Override
        public boolean isConnected() {
            return c.this.isConnected();
        }

        @Override
        public Bundle fX() {
            return null;
        }
    };

    public c(Context context, Looper looper, jg jg2, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n2) {
        this.mContext = context;
        this.JS = new jm(context, looper, this.Km);
        this.JF = looper;
        this.Kd = new c(looper);
        this.JT = n2;
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.JS.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.JS.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b b2 = api.gx();
            Api.ApiOptions apiOptions = map.get(api);
            this.Kg.put(api.gz(), (Api.a)c.a(b2, apiOptions, context, looper, jg2, this.Kl, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    c.this.zO.lock();
                    try {
                        if (c.this.JV == null || b2.getPriority() < c.this.JW) {
                            c.this.JV = result;
                            c.this.JW = b2.getPriority();
                        }
                        c.this.gJ();
                    }
                    finally {
                        c.this.zO.unlock();
                    }
                }
            }));
        }
        this.Kh = Collections.unmodifiableList(jg2.ho());
    }

    private static <C extends Api.a, O> C a(Api.b<C, O> b2, Object object, Context context, Looper looper, jg jg2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return b2.a(context, looper, jg2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void gJ() {
        --this.Ka;
        if (this.Ka == 0) {
            if (this.JV != null) {
                this.JZ = false;
                this.al(3);
                if (!this.gL() || !GooglePlayServicesUtil.e(this.mContext, this.JV.getErrorCode())) {
                    this.gM();
                    this.JS.b(this.JV);
                }
                this.Ki = false;
            } else {
                this.JX = 2;
                this.gM();
                this.JR.signalAll();
                this.gK();
                if (this.JZ) {
                    this.JZ = false;
                    this.al(-1);
                } else {
                    Bundle bundle = this.Kf.isEmpty() ? null : this.Kf;
                    this.JS.f(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T t2) {
        this.zO.lock();
        try {
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.JU.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.zO.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T t2) {
        jx.a(this.isConnected() || this.gL(), "GoogleApiClient is not connected yet.");
        this.gK();
        try {
            this.a((d<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.al(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(d<A> d2) throws DeadObjectException {
        this.zO.lock();
        try {
            jx.b(d2.gz() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.Kk.add(d2);
            d2.a(this.Jy);
            if (this.gL()) {
                d2.l(new Status(8));
                return;
            }
            A a2 = this.a(d2.gz());
            d2.b(a2);
        }
        finally {
            this.zO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gK() {
        this.zO.lock();
        try {
            jx.a(this.isConnected() || this.gL(), "GoogleApiClient is not connected yet.");
            while (!this.JU.isEmpty()) {
                try {
                    this.a(this.JU.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.zO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> com.google.android.gms.common.api.d<L> d(L l2) {
        jx.b(l2, (Object)"Listener must not be null");
        this.zO.lock();
        try {
            com.google.android.gms.common.api.d<L> d2 = new com.google.android.gms.common.api.d<L>(this.JF, l2);
            this.Kj.add(d2);
            com.google.android.gms.common.api.d<L> d3 = d2;
            return d3;
        }
        finally {
            this.zO.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.c<C> c2) {
        Api.a a2 = this.Kg.get(c2);
        jx.b(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    @Override
    public boolean a(Scope scope) {
        return this.Kh.contains(scope.gO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zO.lock();
        try {
            this.JZ = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.Ki = true;
            this.JV = null;
            this.JX = 1;
            this.Kf.clear();
            this.Ka = this.Kg.size();
            for (Api.a a2 : this.Kg.values()) {
                a2.connect();
            }
        }
        finally {
            this.zO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        jx.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.zO.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.JR.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zO.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.Iu;
                return connectionResult;
            }
            if (this.JV != null) {
                ConnectionResult connectionResult = this.JV;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        jx.a(Looper.myLooper() != Looper.getMainLooper(), "blockingConnect must not be called on the UI thread");
        this.zO.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.JR.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.Iu;
                return connectionResult;
            }
            if (this.JV != null) {
                ConnectionResult connectionResult = this.JV;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zO.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.gM();
        this.al(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void al(int n2) {
        this.zO.lock();
        try {
            if (this.JX != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.JU.iterator();
                        while (iterator.hasNext()) {
                            d object = (d)iterator.next();
                            if (object.gF() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        this.JU.clear();
                    }
                    for (d d2 : this.Kk) {
                        d2.cancel();
                    }
                    this.Kk.clear();
                    for (com.google.android.gms.common.api.d d3 : this.Kj) {
                        d3.clear();
                    }
                    this.Kj.clear();
                    if (this.JV == null && !this.JU.isEmpty()) {
                        this.JZ = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.JX = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.JV = null;
                    }
                    this.JR.signalAll();
                }
                this.Ki = false;
                for (Api.a a2 : this.Kg.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.Ki = true;
                this.JX = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.JS.aE(n2);
                    }
                    this.Ki = false;
                }
            }
        }
        finally {
            this.zO.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        jx.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        final f f2 = new f(this.JF);
        if (this.Kg.containsKey(kc.DQ)) {
            this.a(this, f2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    c.this.a((GoogleApiClient)atomicReference.get(), f2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    f2.b(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(kc.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.Kd).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return f2;
    }

    private void a(final GoogleApiClient googleApiClient, final f f2, final boolean bl2) {
        kc.Nu.c(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void j(Status status) {
                if (status.isSuccess() && c.this.isConnected()) {
                    c.this.reconnect();
                }
                f2.b(status);
                if (bl2) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.j((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        jx.a(this.JT >= 0, "Called stopAutoManage but automatic lifecycle management is not enabled.");
        g.a(lifecycleActivity).ao(this.JT);
    }

    @Override
    public boolean isConnected() {
        return this.JX == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.JX == 1;
    }

    boolean gL() {
        return this.JY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zO.lock();
        try {
            if (this.gL()) {
                this.connect();
            }
        }
        finally {
            this.zO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gM() {
        this.zO.lock();
        try {
            if (!this.JY) {
                return;
            }
            this.JY = false;
            this.Kd.removeMessages(2);
            this.Kd.removeMessages(1);
            this.mContext.unregisterReceiver(this.Ke);
        }
        finally {
            this.zO.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.JS.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.JS.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.JS.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.JS.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.JS.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.JS.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Looper getLooper() {
        return this.JF;
    }

    private class c
    extends Handler {
        c(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    c.this.gM();
                    break;
                }
                case 2: {
                    c.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    private static class a
    extends BroadcastReceiver {
        private WeakReference<c> Ks;

        a(c c2) {
            this.Ks = new WeakReference<c>(c2);
        }

        public void onReceive(Context context, Intent intent) {
            Uri uri = intent.getData();
            String string2 = null;
            if (uri != null) {
                string2 = uri.getSchemeSpecificPart();
            }
            if (string2 == null || !string2.equals("com.google.android.gms")) {
                return;
            }
            c c2 = (c)this.Ks.get();
            if (c2 == null) {
                return;
            }
            if (!c2.isConnected() && !c2.isConnecting() && c2.gL()) {
                c2.connect();
            }
        }
    }

    static interface d<A extends Api.a> {
        public void cancel();

        public Api.c<A> gz();

        public void b(A var1) throws DeadObjectException;

        public void l(Status var1);

        public void a(b var1);

        public int gF();
    }

    static interface b {
        public void b(d<?> var1);
    }
}

