/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.f;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final f CREATOR = new f();
    private final int CK;
    private final String[] Ld;
    Bundle Le;
    private final CursorWindow[] Lf;
    private final int Iv;
    private final Bundle Lg;
    int[] Lh;
    int Li;
    boolean mClosed = false;
    private Object Lj;
    private boolean Lk = true;
    private static final a Ll = new a(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.CK = versionCode;
        this.Ld = columns;
        this.Lf = windows;
        this.Iv = statusCode;
        this.Lg = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.CK = 1;
        this.Ld = jx.i(columns);
        this.Lf = jx.i(windows);
        this.Iv = statusCode;
        this.Lg = metadata;
        this.gX();
    }

    public void e(Object object) {
        this.Lj = object;
    }

    private DataHolder(a builder, int statusCode, Bundle metadata) {
        this(builder.Ld, DataHolder.a(builder, -1), statusCode, metadata);
    }

    public void gX() {
        int n2;
        this.Le = new Bundle();
        for (n2 = 0; n2 < this.Ld.length; ++n2) {
            this.Le.putInt(this.Ld[n2], n2);
        }
        this.Lh = new int[this.Lf.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.Lf.length; ++i2) {
            this.Lh[i2] = n2;
            int n3 = this.Lf[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.Lf[i2].getNumRows() - n4;
        }
        this.Li = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.CK;
    }

    String[] gY() {
        return this.Ld;
    }

    CursorWindow[] gZ() {
        return this.Lf;
    }

    public int getStatusCode() {
        return this.Iv;
    }

    public Bundle gV() {
        return this.Lg;
    }

    private static CursorWindow[] a(a a2, int n2) {
        if (a2.Ld.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= a2.Lm.size() ? a2.Lm : a2.Lm.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(a2.Ld.length);
        boolean bl2 = false;
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(a2.Ld.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i2);
                boolean bl3 = true;
                for (int i3 = 0; i3 < a2.Ld.length && bl3; ++i3) {
                    String string2 = a2.Ld[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl3 = cursorWindow.putNull(i2, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl3 = cursorWindow.putString((String)v2, i2, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl3 = cursorWindow.putLong(((Long)v2).longValue(), i2, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl3 = cursorWindow.putLong((long)((Integer)v2).intValue(), i2, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl4 = (Boolean)v2;
                        bl3 = cursorWindow.putLong(bl4 ? 1L : 0L, i2, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl3 = cursorWindow.putBlob((byte[])v2, i2, i3);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        bl3 = cursorWindow.putDouble(((Double)v2).doubleValue(), i2, i3);
                        continue;
                    }
                    if (v2 instanceof Float) {
                        bl3 = cursorWindow.putDouble((double)((Float)v2).floatValue(), i2, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl3) {
                    if (bl2) {
                        String string3 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new b(string3);
                    }
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(a2.Ld.length);
                    arrayList.add(cursorWindow);
                    --i2;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n4 = arrayList.size();
            for (int i4 = 0; i4 < n4; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void g(String string2, int n2) {
        if (this.Le == null || !this.Le.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.Li) {
            throw new CursorIndexOutOfBoundsException(n2, this.Li);
        }
    }

    public boolean aQ(String string2) {
        return this.Le.containsKey(string2);
    }

    public long a(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].getLong(n2, this.Le.getInt(string2));
    }

    public int b(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].getInt(n2, this.Le.getInt(string2));
    }

    public String c(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].getString(n2, this.Le.getInt(string2));
    }

    public boolean d(String string2, int n2, int n3) {
        this.g(string2, n2);
        Long l2 = this.Lf[n3].getLong(n2, this.Le.getInt(string2));
        return l2 == 1L;
    }

    public float e(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].getFloat(n2, this.Le.getInt(string2));
    }

    public byte[] f(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].getBlob(n2, this.Le.getInt(string2));
    }

    public Uri g(String string2, int n2, int n3) {
        String string3 = this.c(string2, n2, n3);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void a(String string2, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        this.g(string2, n2);
        this.Lf[n3].copyStringToBuffer(n2, this.Le.getInt(string2), charArrayBuffer);
    }

    public boolean h(String string2, int n2, int n3) {
        this.g(string2, n2);
        return this.Lf[n3].isNull(n2, this.Le.getInt(string2));
    }

    public int getCount() {
        return this.Li;
    }

    public int au(int n2) {
        int n3;
        jx.K(n2 >= 0 && n2 < this.Li);
        for (n3 = 0; n3 < this.Lh.length; ++n3) {
            if (n2 >= this.Lh[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.Lh.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.Lf.length; ++i2) {
                    this.Lf[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.Lk && this.Lf.length > 0 && !this.isClosed()) {
                String string2 = this.Lj == null ? "internal object: " + this.toString() : this.Lj.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder av(int n2) {
        return DataHolder.a(n2, null);
    }

    public static DataHolder a(int n2, Bundle bundle) {
        return new DataHolder(Ll, n2, bundle);
    }

    public static class b
    extends RuntimeException {
        public b(String string2) {
            super(string2);
        }
    }

    public static class a {
        private final String[] Ld;
        private final ArrayList<HashMap<String, Object>> Lm;
        private final String Ln;
        private final HashMap<Object, Integer> Lo;
        private boolean Lp;
        private String Lq;

        private a(String[] stringArray, String string2) {
            this.Ld = jx.i(stringArray);
            this.Lm = new ArrayList();
            this.Ln = string2;
            this.Lo = new HashMap();
            this.Lp = false;
            this.Lq = null;
        }
    }
}

