/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class kj<K, V> {
    private final LinkedHashMap<K, V> Nw;
    private int size;
    private int Nx;
    private int Ny;
    private int Nz;
    private int NA;
    private int NB;
    private int NC;

    public kj(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.Nx = n2;
        this.Nw = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        kj<K, V> kj2 = this;
        synchronized (kj2) {
            object = this.Nw.get(key);
            if (object != null) {
                ++this.NB;
                return object;
            }
            ++this.NC;
        }
        kj2 = this.create(key);
        if (kj2 == null) {
            return null;
        }
        kj kj3 = this;
        synchronized (kj3) {
            ++this.Nz;
            object = this.Nw.put(key, kj2);
            if (object != null) {
                this.Nw.put(key, object);
            } else {
                this.size += this.c(key, kj2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, kj2, object);
            return object;
        }
        this.trimToSize(this.Nx);
        return (V)kj2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        kj kj2 = this;
        synchronized (kj2) {
            ++this.Ny;
            this.size += this.c(key, value);
            v2 = this.Nw.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.Nx);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            kj kj2 = this;
            synchronized (kj2) {
                if (this.size < 0 || this.Nw.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.Nw.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.Nw.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.Nw.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.NA;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.NB + this.NC;
        int n3 = n2 != 0 ? 100 * this.NB / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.Nx, this.NB, this.NC, n3);
    }
}

