/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.pu;
import com.google.android.gms.internal.qv;
import com.google.android.gms.internal.qw;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cq
implements o.f {
    private final Context mContext;
    private final String aqm;
    private final ExecutorService asJ;
    private bg<pu.a> asC;

    cq(Context context, String string2) {
        this.mContext = context;
        this.aqm = string2;
        this.asJ = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<pu.a> bg2) {
        this.asC = bg2;
    }

    @Override
    public void pt() {
        this.asJ.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.qi();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void qi() {
        if (this.asC == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.asC.ps();
        bh.V("Attempting to load resource from disk");
        if ((ce.qa().qb() == ce.a.asr || ce.qa().qb() == ce.a.ass) && this.aqm.equals(ce.qa().getContainerId())) {
            this.asC.a(bg.a.arV);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.qj());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.S("Failed to find the resource in the disk");
            this.asC.a(bg.a.arV);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(fileInputStream, byteArrayOutputStream);
            pu.a a2 = pu.a.l(byteArrayOutputStream.toByteArray());
            this.d(a2);
            this.asC.l(a2);
        }
        catch (IOException iOException) {
            this.asC.a(bg.a.arW);
            bh.W("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.asC.a(bg.a.arW);
            bh.W("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.W("Error closing stream for reading resource from disk");
            }
        }
        bh.V("The Disk resource was successfully read.");
    }

    @Override
    public void b(final pu.a a2) {
        this.asJ.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.c(a2);
            }
        });
    }

    @Override
    public cr.c fH(int n2) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.W("Failed to load the container. No default container resource found with the resource ID " + n2);
            return null;
        }
        bh.V("Attempting to load a container from the resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(inputStream, byteArrayOutputStream);
            cr.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                bh.V("The container was successfully loaded from the resource (using JSON file format)");
                return c2;
            }
            return this.k(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.W("Error reading the default container with resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
            return null;
        }
    }

    private cr.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return ba.cI(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.S("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            bh.W("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cr.c k(byte[] byArray) {
        try {
            cr.c c2 = cr.b(c.f.a(byArray));
            if (c2 != null) {
                bh.V("The container was successfully loaded from the resource (using binary file)");
            }
            return c2;
        }
        catch (qv qv2) {
            bh.T("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (cr.g g2) {
            bh.W("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.asJ.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(pu.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.qj();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.T("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(qw.f(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.W("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.W("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File qj() {
        String string2 = "resource_" + this.aqm;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string2);
    }

    private void d(pu.a a2) throws IllegalArgumentException {
        if (a2.gs == null && a2.auC == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

