/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final zzf CREATOR = new zzf();
    private final int zzFG;
    private final String[] zzNU;
    Bundle zzNV;
    private final CursorWindow[] zzNW;
    private final int zzLs;
    private final Bundle zzNX;
    int[] zzNY;
    int zzNZ;
    boolean mClosed = false;
    private Object zzOa;
    private boolean zzOb = true;
    private static final zza zzOc = new zza(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzFG = versionCode;
        this.zzNU = columns;
        this.zzNW = windows;
        this.zzLs = statusCode;
        this.zzNX = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.zzFG = 1;
        this.zzNU = zzx.zzl(columns);
        this.zzNW = zzx.zzl(windows);
        this.zzLs = statusCode;
        this.zzNX = metadata;
        this.zziy();
    }

    public void zzg(Object object) {
        this.zzOa = object;
    }

    private DataHolder(zza builder, int statusCode, Bundle metadata) {
        this(builder.zzNU, DataHolder.zza(builder, -1), statusCode, metadata);
    }

    public void zziy() {
        int n;
        this.zzNV = new Bundle();
        for (n = 0; n < this.zzNU.length; ++n) {
            this.zzNV.putInt(this.zzNU[n], n);
        }
        this.zzNY = new int[this.zzNW.length];
        n = 0;
        for (int i = 0; i < this.zzNW.length; ++i) {
            this.zzNY[i] = n;
            int n2 = this.zzNW[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzNW[i].getNumRows() - n3;
        }
        this.zzNZ = n;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    int getVersionCode() {
        return this.zzFG;
    }

    String[] zziz() {
        return this.zzNU;
    }

    CursorWindow[] zziA() {
        return this.zzNW;
    }

    public int getStatusCode() {
        return this.zzLs;
    }

    public Bundle zziu() {
        return this.zzNX;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzNU.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzOd.size() ? zza2.zzOd : zza2.zzOd.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzNU.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzNU.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (int j = 0; j < zza2.zzNU.length && bl2; ++j) {
                    String string2 = zza2.zzNU[j];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, j);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, j);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, j);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, j);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, j);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, j);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, j);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, j);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v);
                }
                if (!bl2) {
                    if (bl) {
                        String string3 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string3);
                    }
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzNU.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzg(String string2, int n) {
        if (this.zzNV == null || !this.zzNV.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzNZ) {
            throw new CursorIndexOutOfBoundsException(n, this.zzNZ);
        }
    }

    public boolean zzba(String string2) {
        return this.zzNV.containsKey(string2);
    }

    public long zza(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].getLong(n, this.zzNV.getInt(string2));
    }

    public int zzb(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].getInt(n, this.zzNV.getInt(string2));
    }

    public String zzc(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].getString(n, this.zzNV.getInt(string2));
    }

    public boolean zzd(String string2, int n, int n2) {
        this.zzg(string2, n);
        Long l = this.zzNW[n2].getLong(n, this.zzNV.getInt(string2));
        return l == 1L;
    }

    public float zze(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].getFloat(n, this.zzNV.getInt(string2));
    }

    public byte[] zzf(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].getBlob(n, this.zzNV.getInt(string2));
    }

    public Uri zzg(String string2, int n, int n2) {
        String string3 = this.zzc(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzg(string2, n);
        this.zzNW[n2].copyStringToBuffer(n, this.zzNV.getInt(string2), charArrayBuffer);
    }

    public boolean zzh(String string2, int n, int n2) {
        this.zzg(string2, n);
        return this.zzNW[n2].isNull(n, this.zzNV.getInt(string2));
    }

    public int getCount() {
        return this.zzNZ;
    }

    public int zzax(int n) {
        int n2;
        zzx.zzN(n >= 0 && n < this.zzNZ);
        for (n2 = 0; n2 < this.zzNY.length; ++n2) {
            if (n >= this.zzNY[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzNY.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzNW.length; ++i) {
                    this.zzNW[i].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.zzOb && this.zzNW.length > 0 && !this.isClosed()) {
                String string2 = this.zzOa == null ? "internal object: " + this.toString() : this.zzOa.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder zzay(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzOc, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzNU;
        private final ArrayList<HashMap<String, Object>> zzOd;
        private final String zzOe;
        private final HashMap<Object, Integer> zzOf;
        private boolean zzOg;
        private String zzOh;

        private zza(String[] stringArray, String string2) {
            this.zzNU = zzx.zzl(stringArray);
            this.zzOd = new ArrayList();
            this.zzOe = string2;
            this.zzOf = new HashMap();
            this.zzOg = false;
            this.zzOh = null;
        }
    }
}

