/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.zzb;
import java.util.Set;

public class zzc {
    private static final zzc zzLH = new zzc();

    private zzc() {
    }

    public static zzc zzhP() {
        return zzLH;
    }

    public boolean zzb(PackageManager packageManager, String string2) {
        PackageInfo packageInfo;
        try {
            packageInfo = packageManager.getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (Log.isLoggable((String)"GoogleSignatureVerifier", (int)3)) {
                Log.d((String)"GoogleSignatureVerifier", (String)("Package manager can't find package " + string2 + ", defaulting to false"));
            }
            return false;
        }
        return this.zza(packageManager, packageInfo);
    }

    public boolean zza(PackageManager packageManager, PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GooglePlayServicesUtil.zzc(packageManager)) {
            return this.zza(packageInfo, true);
        }
        boolean bl = this.zza(packageInfo, false);
        if (!bl && this.zza(packageInfo, true)) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return bl;
    }

    private boolean zza(PackageInfo packageInfo, boolean bl) {
        zzb.zzb zzb2;
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return false;
        }
        Set<zzb.zza> set = bl ? zzb.zzhL() : zzb.zzhM();
        if (set.contains(zzb2 = new zzb.zzb(packageInfo.signatures[0].toByteArray()))) {
            return true;
        }
        if (Log.isLoggable((String)"GoogleSignatureVerifier", (int)2)) {
            Log.v((String)"GoogleSignatureVerifier", (String)("Signature not valid.  Found: \n" + Base64.encodeToString((byte[])((zzb.zza)zzb2).getBytes(), (int)0)));
        }
        return false;
    }

    zzb.zza zza(PackageInfo packageInfo, zzb.zza ... zzaArray) {
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzb.zzb zzb2 = new zzb.zzb(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzaArray.length; ++i) {
            if (!zzaArray[i].equals(zzb2)) continue;
            return zzaArray[i];
        }
        if (Log.isLoggable((String)"GoogleSignatureVerifier", (int)2)) {
            Log.v((String)"GoogleSignatureVerifier", (String)("Signature not valid.  Found: \n" + Base64.encodeToString((byte[])((zzb.zza)zzb2).getBytes(), (int)0)));
        }
        return null;
    }
}

