/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzxb;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public final class zzwr {
    private final ByteBuffer zzaHA;

    private zzwr(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzwr(ByteBuffer byteBuffer) {
        this.zzaHA = byteBuffer;
    }

    public static zzwr zzu(byte[] byArray) {
        return zzwr.zzb(byArray, 0, byArray.length);
    }

    public static zzwr zzb(byte[] byArray, int n, int n2) {
        return new zzwr(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzC(n, 1);
        this.zze(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzC(n, 5);
        this.zzf(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzL(l);
    }

    public void zzy(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zziu(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzC(n, 0);
        this.zzah(bl);
    }

    public void zzb(int n, String string2) throws IOException {
        this.zzC(n, 2);
        this.zzdL(string2);
    }

    public void zza(int n, zzwy zzwy2) throws IOException {
        this.zzC(n, 2);
        this.zzc(zzwy2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzC(n, 2);
        this.zzv(byArray);
    }

    public void zzz(int n, int n2) throws IOException {
        this.zzC(n, 0);
        this.zziv(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzC(n, 0);
        this.zzM(l);
    }

    public void zze(double d) throws IOException {
        this.zzR(Double.doubleToLongBits(d));
    }

    public void zzf(float f) throws IOException {
        this.zziC(Float.floatToIntBits(f));
    }

    public void zzL(long l) throws IOException {
        this.zzP(l);
    }

    public void zziu(int n) throws IOException {
        if (n >= 0) {
            this.zziA(n);
        } else {
            this.zzP(n);
        }
    }

    public void zzah(boolean bl) throws IOException {
        this.zziy(bl ? 1 : 0);
    }

    public void zzdL(String string2) throws IOException {
        try {
            int n = zzwr.zziB(string2.length());
            int n2 = zzwr.zziB(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzaHA.position();
                this.zzaHA.position(n3 + n);
                zzwr.zza((CharSequence)string2, this.zzaHA);
                int n4 = this.zzaHA.position();
                this.zzaHA.position(n3);
                this.zziA(n4 - n3 - n);
                this.zzaHA.position(n4);
            } else {
                this.zziA(zzwr.zza(string2));
                zzwr.zza((CharSequence)string2, this.zzaHA);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new zza(this.zzaHA.position(), this.zzaHA.limit());
        }
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzwr.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzwr.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzwr.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzwy zzwy2) throws IOException {
        zzwy2.zza(this);
    }

    public void zzc(zzwy zzwy2) throws IOException {
        this.zziA(zzwy2.zzvX());
        zzwy2.zza(this);
    }

    public void zzv(byte[] byArray) throws IOException {
        this.zziA(byArray.length);
        this.zzx(byArray);
    }

    public void zziv(int n) throws IOException {
        this.zziA(zzwr.zziD(n));
    }

    public void zzM(long l) throws IOException {
        this.zzP(zzwr.zzS(l));
    }

    public static int zzb(int n, double d) {
        return zzwr.zziz(n) + zzwr.zzf(d);
    }

    public static int zzc(int n, float f) {
        return zzwr.zziz(n) + zzwr.zzg(f);
    }

    public static int zzd(int n, long l) {
        return zzwr.zziz(n) + zzwr.zzN(l);
    }

    public static int zzA(int n, int n2) {
        return zzwr.zziz(n) + zzwr.zziw(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zzwr.zziz(n) + zzwr.zzai(bl);
    }

    public static int zzj(int n, String string2) {
        return zzwr.zziz(n) + zzwr.zzdM(string2);
    }

    public static int zzb(int n, zzwy zzwy2) {
        return zzwr.zziz(n) * 2 + zzwr.zzd(zzwy2);
    }

    public static int zzc(int n, zzwy zzwy2) {
        return zzwr.zziz(n) + zzwr.zze(zzwy2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzwr.zziz(n) + zzwr.zzw(byArray);
    }

    public static int zzB(int n, int n2) {
        return zzwr.zziz(n) + zzwr.zzix(n2);
    }

    public static int zze(int n, long l) {
        return zzwr.zziz(n) + zzwr.zzO(l);
    }

    public static int zzf(double d) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzN(long l) {
        return zzwr.zzQ(l);
    }

    public static int zziw(int n) {
        if (n >= 0) {
            return zzwr.zziB(n);
        }
        return 10;
    }

    public static int zzai(boolean bl) {
        return 1;
    }

    public static int zzdM(String string2) {
        int n = zzwr.zza(string2);
        return zzwr.zziB(n) + n;
    }

    public static int zzd(zzwy zzwy2) {
        return zzwy2.zzvY();
    }

    public static int zze(zzwy zzwy2) {
        int n = zzwy2.zzvY();
        return zzwr.zziB(n) + n;
    }

    public static int zzw(byte[] byArray) {
        return zzwr.zziB(byArray.length) + byArray.length;
    }

    public static int zzix(int n) {
        return zzwr.zziB(zzwr.zziD(n));
    }

    public static int zzO(long l) {
        return zzwr.zzQ(zzwr.zzS(l));
    }

    public int zzvJ() {
        return this.zzaHA.remaining();
    }

    public void zzvK() {
        if (this.zzvJ() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzaHA.hasRemaining()) {
            throw new zza(this.zzaHA.position(), this.zzaHA.limit());
        }
        this.zzaHA.put(by);
    }

    public void zziy(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzx(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzaHA.remaining() < n2) {
            throw new zza(this.zzaHA.position(), this.zzaHA.limit());
        }
        this.zzaHA.put(byArray, n, n2);
    }

    public void zzC(int n, int n2) throws IOException {
        this.zziA(zzxb.zzD(n, n2));
    }

    public static int zziz(int n) {
        return zzwr.zziB(zzxb.zzD(n, 0));
    }

    public void zziA(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zziy(n);
                return;
            }
            this.zziy(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zziB(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzP(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zziy((int)l);
                return;
            }
            this.zziy((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzQ(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zziC(int n) throws IOException {
        this.zziy(n & 0xFF);
        this.zziy(n >> 8 & 0xFF);
        this.zziy(n >> 16 & 0xFF);
        this.zziy(n >> 24 & 0xFF);
    }

    public void zzR(long l) throws IOException {
        this.zziy((int)l & 0xFF);
        this.zziy((int)(l >> 8) & 0xFF);
        this.zziy((int)(l >> 16) & 0xFF);
        this.zziy((int)(l >> 24) & 0xFF);
        this.zziy((int)(l >> 32) & 0xFF);
        this.zziy((int)(l >> 40) & 0xFF);
        this.zziy((int)(l >> 48) & 0xFF);
        this.zziy((int)(l >> 56) & 0xFF);
    }

    public static int zziD(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzS(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

