/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzv;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzl
extends Fragment
implements DialogInterface.OnCancelListener {
    private boolean mStarted;
    private boolean zzRa;
    private int zzRb = -1;
    private ConnectionResult zzRc;
    private final Handler zzRd = new Handler(Looper.getMainLooper());
    private final SparseArray<zza> zzRe = new SparseArray();

    public static zzl zza(FragmentActivity fragmentActivity) {
        zzl zzl2;
        zzv.zzbI("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzl2 = (zzl)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (zzl2 == null || zzl2.isRemoving()) {
            zzl2 = new zzl();
            fragmentManager.beginTransaction().add((Fragment)zzl2, "GmsSupportLifecycleFragment").commit();
            fragmentManager.executePendingTransactions();
        }
        return zzl2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzv.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzv.zza(this.zzRe.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzRe.put(n, (Object)zza2);
        if (this.mStarted && !this.zzRa) {
            googleApiClient.connect();
        }
    }

    public void zzax(int n) {
        zza zza2 = (zza)this.zzRe.get(n);
        this.zzRe.remove(n);
        if (zza2 != null) {
            zza2.zzlh();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzRb, new ConnectionResult(13, null));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzRa = savedInstanceState.getBoolean("resolving_error", false);
            this.zzRb = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzRb >= 0) {
                this.zzRc = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzRa);
        if (this.zzRb >= 0) {
            outState.putInt("failed_client_id", this.zzRb);
            outState.putInt("failed_status", this.zzRc.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzRc.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzRa) {
            for (int i = 0; i < this.zzRe.size(); ++i) {
                zza zza2 = (zza)this.zzRe.valueAt(i);
                zza2.zzRg.connect();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zzlg();
        } else {
            this.zza(this.zzRb, this.zzRc);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzRe.size(); ++i) {
            zza zza2 = (zza)this.zzRe.valueAt(i);
            zza2.zzRg.disconnect();
        }
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzRe.size(); ++i) {
            zza zza2 = (zza)this.zzRe.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzRe.get(n);
        if (zza2 != null) {
            this.zzax(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzRh;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzlg();
    }

    private void zzlg() {
        this.zzRa = false;
        this.zzRb = -1;
        this.zzRc = null;
        for (int i = 0; i < this.zzRe.size(); ++i) {
            zza zza2 = (zza)this.zzRe.valueAt(i);
            zza2.zzRg.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzRf;
        public final GoogleApiClient zzRg;
        public final GoogleApiClient.OnConnectionFailedListener zzRh;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzRf = n;
            this.zzRg = googleApiClient;
            this.zzRh = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzl.this.zzRd.post((Runnable)new zzb(this.zzRf, result));
        }

        public void zzlh() {
            this.zzRg.unregisterConnectionFailedListener(this);
            this.zzRg.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append("#").print(this.zzRf);
            writer.append(" ");
            this.zzRg.dump(prefix, fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzRj;
        private final ConnectionResult zzRk;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzRj = n;
            this.zzRk = connectionResult;
        }

        @Override
        public void run() {
            if (!zzl.this.mStarted || zzl.this.zzRa) {
                return;
            }
            zzl.this.zzRa = true;
            zzl.this.zzRb = this.zzRj;
            zzl.this.zzRc = this.zzRk;
            if (this.zzRk.hasResolution()) {
                try {
                    int n = zzl.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzl.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzRk.startResolutionForResult((Activity)zzl.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzl.this.zzlg();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzRk.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzRk.getErrorCode(), (Activity)zzl.this.getActivity(), zzl.this, 2, zzl.this);
            } else {
                zzl.this.zza(this.zzRj, this.zzRk);
            }
        }
    }
}

