/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzic;

public final class zzhd
extends Drawable
implements Drawable.Callback {
    private int zzSs = 0;
    private long zzGX;
    private int mFrom;
    private int zzSt;
    private int zzSu = 255;
    private int zzSv;
    private int zzSw = 0;
    private boolean zzSl = true;
    private boolean zzSx;
    private zzb zzSy;
    private Drawable zzSz;
    private Drawable zzSA;
    private boolean zzSB;
    private boolean zzSC;
    private boolean zzSD;
    private int zzSE;

    public zzhd(Drawable drawable, Drawable drawable2) {
        this(null);
        if (drawable == null) {
            drawable = zza.zzSF;
        }
        this.zzSz = drawable;
        drawable.setCallback((Drawable.Callback)this);
        this.zzSy.zzSI |= drawable.getChangingConfigurations();
        if (drawable2 == null) {
            drawable2 = zza.zzSF;
        }
        this.zzSA = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzSy.zzSI |= drawable2.getChangingConfigurations();
    }

    zzhd(zzb zzb2) {
        this.zzSy = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzic.zzne() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzic.zzne() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzic.zzne() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzSy.zzSH | this.zzSy.zzSI;
    }

    public void setAlpha(int alpha) {
        if (this.zzSw == this.zzSu) {
            this.zzSw = alpha;
        }
        this.zzSu = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzSz.setColorFilter(cf);
        this.zzSA.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzSz.getIntrinsicWidth(), this.zzSA.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzSz.getIntrinsicHeight(), this.zzSA.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzSz.setBounds(bounds);
        this.zzSA.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzSy.zzSH = this.getChangingConfigurations();
            return this.zzSy;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzSD) {
            this.zzSE = Drawable.resolveOpacity((int)this.zzSz.getOpacity(), (int)this.zzSA.getOpacity());
            this.zzSD = true;
        }
        return this.zzSE;
    }

    public boolean canConstantState() {
        if (!this.zzSB) {
            this.zzSC = this.zzSz.getConstantState() != null && this.zzSA.getConstantState() != null;
            this.zzSB = true;
        }
        return this.zzSC;
    }

    public Drawable mutate() {
        if (!this.zzSx && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzSz.mutate();
            this.zzSA.mutate();
            this.zzSx = true;
        }
        return this;
    }

    public Drawable zzlA() {
        return this.zzSA;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzSt = this.zzSu;
        this.zzSw = 0;
        this.zzSv = durationMillis;
        this.zzSs = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzSs) {
            case 1: {
                this.zzGX = SystemClock.uptimeMillis();
                bl = false;
                this.zzSs = 2;
                break;
            }
            case 2: {
                if (this.zzGX < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzGX) / (float)this.zzSv;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzSs = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzSw = (int)((float)this.mFrom + (float)(this.zzSt - this.mFrom) * f);
            }
        }
        int n = this.zzSw;
        boolean bl3 = this.zzSl;
        Drawable drawable = this.zzSz;
        Drawable drawable2 = this.zzSA;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable.draw(canvas);
            }
            if (n == this.zzSu) {
                drawable2.setAlpha(this.zzSu);
                drawable2.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable.setAlpha(this.zzSu - n);
        }
        drawable.draw(canvas);
        if (bl3) {
            drawable.setAlpha(this.zzSu);
        }
        if (n > 0) {
            drawable2.setAlpha(n);
            drawable2.draw(canvas);
            drawable2.setAlpha(this.zzSu);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzhd$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzhd$zza zzSF = new com.google.android.gms.internal.zzhd$zza();
        private static final zza zzSG = new zza();

        private com.google.android.gms.internal.zzhd$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzSG;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzSF;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzSH;
        int zzSI;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzSH = zzb2.zzSH;
                this.zzSI = zzb2.zzSI;
            }
        }

        public Drawable newDrawable() {
            return new zzhd(this);
        }

        public int getChangingConfigurations() {
            return this.zzSH;
        }
    }
}

