/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzp
extends Fragment
implements DialogInterface.OnCancelListener {
    private boolean mStarted;
    private boolean zzaaJ;
    private int zzaaK = -1;
    private ConnectionResult zzaaL;
    private final Handler zzaaM = new Handler(Looper.getMainLooper());
    private final SparseArray<zza> zzaaN = new SparseArray();

    public static zzp zza(FragmentActivity fragmentActivity) {
        zzp zzp2;
        zzx.zzch("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzp2 = (zzp)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (zzp2 == null || zzp2.isRemoving()) {
            return null;
        }
        return zzp2;
    }

    public static zzp zzb(FragmentActivity fragmentActivity) {
        zzp zzp2 = zzp.zza(fragmentActivity);
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        if (zzp2 == null) {
            zzp2 = new zzp();
            fragmentManager.beginTransaction().add((Fragment)zzp2, "GmsSupportLifecycleFragment").commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return zzp2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzaaN.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzaaN.put(n, (Object)zza2);
        if (this.mStarted && !this.zzaaJ) {
            googleApiClient.connect();
        }
    }

    public void zzbi(int n) {
        zza zza2 = (zza)this.zzaaN.get(n);
        this.zzaaN.remove(n);
        if (zza2 != null) {
            zza2.zznK();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzaaK, new ConnectionResult(13, null));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzaaJ = savedInstanceState.getBoolean("resolving_error", false);
            this.zzaaK = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzaaK >= 0) {
                this.zzaaL = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzaaJ);
        if (this.zzaaK >= 0) {
            outState.putInt("failed_client_id", this.zzaaK);
            outState.putInt("failed_status", this.zzaaL.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzaaL.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzaaJ) {
            for (int i = 0; i < this.zzaaN.size(); ++i) {
                zza zza2 = (zza)this.zzaaN.valueAt(i);
                zza2.zzaaP.connect();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode != -1) break;
                bl = true;
            }
        }
        if (bl) {
            this.zznJ();
        } else {
            this.zza(this.zzaaK, this.zzaaL);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzaaN.size(); ++i) {
            zza zza2 = (zza)this.zzaaN.valueAt(i);
            zza2.zzaaP.disconnect();
        }
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzaaN.size(); ++i) {
            zza zza2 = (zza)this.zzaaN.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzaaN.get(n);
        if (zza2 != null) {
            this.zzbi(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzaaQ;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zznJ();
    }

    private void zznJ() {
        this.zzaaJ = false;
        this.zzaaK = -1;
        this.zzaaL = null;
        for (int i = 0; i < this.zzaaN.size(); ++i) {
            zza zza2 = (zza)this.zzaaN.valueAt(i);
            zza2.zzaaP.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzaaO;
        public final GoogleApiClient zzaaP;
        public final GoogleApiClient.OnConnectionFailedListener zzaaQ;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzaaO = n;
            this.zzaaP = googleApiClient;
            this.zzaaQ = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzp.this.zzaaM.post((Runnable)new zzb(this.zzaaO, result));
        }

        public void zznK() {
            this.zzaaP.unregisterConnectionFailedListener(this);
            this.zzaaP.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append(prefix).append("GoogleApiClient #").print(this.zzaaO);
            writer.println(":");
            this.zzaaP.dump(prefix + "  ", fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzaaS;
        private final ConnectionResult zzaaT;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzaaS = n;
            this.zzaaT = connectionResult;
        }

        @Override
        public void run() {
            if (!zzp.this.mStarted || zzp.this.zzaaJ) {
                return;
            }
            zzp.this.zzaaJ = true;
            zzp.this.zzaaK = this.zzaaS;
            zzp.this.zzaaL = this.zzaaT;
            if (this.zzaaT.hasResolution()) {
                try {
                    int n = zzp.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzp.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzaaT.startResolutionForResult((Activity)zzp.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzp.this.zznJ();
                }
            } else if (GooglePlayServicesUtil.isUserRecoverableError(this.zzaaT.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzaaT.getErrorCode(), (Activity)zzp.this.getActivity(), zzp.this, 2, zzp.this);
            } else {
                zzp.this.zza(this.zzaaS, this.zzaaT);
            }
        }
    }
}

