/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmx;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzadG = new Object();
    private static HashSet<Uri> zzadH = new HashSet();
    private static ImageManager zzadI;
    private static ImageManager zzadJ;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzadK;
    private final zzb zzadL;
    private final zzlv zzadM;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzadN;
    private final Map<Uri, ImageReceiver> zzadO;
    private final Map<Uri, Long> zzadP;

    public static ImageManager create(Context context) {
        return ImageManager.zzb(context, false);
    }

    public static ImageManager zzb(Context context, boolean bl) {
        if (bl) {
            if (zzadJ == null) {
                zzadJ = new ImageManager(context, true);
            }
            return zzadJ;
        }
        if (zzadI == null) {
            zzadI = new ImageManager(context, false);
        }
        return zzadI;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzadK = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.zzadL = new zzb(this.mContext);
            if (zzmx.zzqx()) {
                this.zzoB();
            }
        } else {
            this.zzadL = null;
        }
        this.zzadM = new zzlv();
        this.zzadN = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzadO = new HashMap<Uri, ImageReceiver>();
        this.zzadP = new HashMap<Uri, Long>();
    }

    private void zzoB() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new zze(this.zzadL));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int resId) {
        zza.zzb zzb2 = new zza.zzb(imageView, resId);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzby(defaultResId);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        zza.zzc zzc2 = new zza.zzc(listener, uri);
        zzc2.zzby(defaultResId);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzb.zzci((String)"ImageManager.loadImage() must be called in the main thread");
        zzd zzd2 = new zzd(zza2);
        zzd2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzadL == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzadL.get(zza2);
        return bitmap;
    }

    private static final class zza {
        static int zza(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class zzb
    extends zzmg<zza.zza, Bitmap> {
        public zzb(Context context) {
            super(zzb.zzaj(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        private static int zzaj(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl && zzmx.zzqu() ? zza.zza(activityManager) : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.zza((zza.zza)x0, (Bitmap)x1);
        }

        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.zza(x0, (zza.zza)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class zze
    implements ComponentCallbacks2 {
        private final zzb zzadL;

        public zze(zzb zzb2) {
            this.zzadL = zzb2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.zzadL.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.zzadL.evictAll();
            } else if (level >= 20) {
                this.zzadL.trimToSize(this.zzadL.size() / 2);
            }
        }
    }

    private final class zzf
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zzoS;
        private boolean zzadU;

        public zzf(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzadU = bl;
            this.zzoS = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzb.zzci((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzadL != null) {
                if (this.zzadU) {
                    ImageManager.this.zzadL.evictAll();
                    System.gc();
                    this.zzadU = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzadL.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzadO.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zzoS.countDown();
            Object object = zzadG;
            synchronized (object) {
                zzadH.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzadQ;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzadP.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzadM, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzadN.remove(zza2);
            }
        }
    }

    private final class zzc
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzadS;

        public zzc(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzadS = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzcj((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzadS != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzadS.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzadS.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zzf(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzadQ;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzadQ = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzci((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzadQ.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzb.zzci((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzadQ.remove(zza2);
        }

        public void zzoE() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzadK.execute(new zzc(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzd
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzadT;

        public zzd(com.google.android.gms.common.images.zza zza2) {
            this.zzadT = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzb.zzci((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzadN.get(this.zzadT));
            if (imageReceiver != null) {
                ImageManager.this.zzadN.remove(this.zzadT);
                imageReceiver.zzc(this.zzadT);
            }
            zza.zza zza2 = this.zzadT.zzadV;
            if (zza2.uri == null) {
                this.zzadT.zza(ImageManager.this.mContext, ImageManager.this.zzadM, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzadT.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzadP.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzadT.zza(ImageManager.this.mContext, ImageManager.this.zzadM, true);
                    return;
                }
                ImageManager.this.zzadP.remove(zza2.uri);
            }
            this.zzadT.zza(ImageManager.this.mContext, ImageManager.this.zzadM);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzadO.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzadO.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzadT);
            if (!(this.zzadT instanceof zza.zzc)) {
                ImageManager.this.zzadN.put(this.zzadT, imageReceiver);
            }
            Object object = zzadG;
            synchronized (object) {
                boolean bl = zzadH.contains(zza2.uri);
                if (!bl) {
                    zzadH.add(zza2.uri);
                    imageReceiver.zzoE();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

