/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzmx;

public final class zzls
extends Drawable
implements Drawable.Callback {
    private int zzaeh = 0;
    private long zzNY;
    private int mFrom;
    private int zzaei;
    private int zzaej = 255;
    private int zzaek;
    private int zzael = 0;
    private boolean zzaea = true;
    private boolean zzaem;
    private zzb zzaen;
    private Drawable zzaeo;
    private Drawable zzaep;
    private boolean zzaeq;
    private boolean zzaer;
    private boolean zzaes;
    private int zzaet;

    public zzls(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzaeu;
        }
        this.zzaeo = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaen.zzaex |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzaeu;
        }
        this.zzaep = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaen.zzaex |= drawable3.getChangingConfigurations();
    }

    zzls(zzb zzb2) {
        this.zzaen = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzmx.zzqu() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzmx.zzqu() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzmx.zzqu() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaen.zzaew | this.zzaen.zzaex;
    }

    public void setAlpha(int alpha) {
        if (this.zzael == this.zzaej) {
            this.zzael = alpha;
        }
        this.zzaej = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzaeo.setColorFilter(cf);
        this.zzaep.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzaeo.getIntrinsicWidth(), this.zzaep.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzaeo.getIntrinsicHeight(), this.zzaep.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzaeo.setBounds(bounds);
        this.zzaep.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaen.zzaew = this.getChangingConfigurations();
            return this.zzaen;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzaes) {
            this.zzaet = Drawable.resolveOpacity((int)this.zzaeo.getOpacity(), (int)this.zzaep.getOpacity());
            this.zzaes = true;
        }
        return this.zzaet;
    }

    public boolean canConstantState() {
        if (!this.zzaeq) {
            this.zzaer = this.zzaeo.getConstantState() != null && this.zzaep.getConstantState() != null;
            this.zzaeq = true;
        }
        return this.zzaer;
    }

    public Drawable mutate() {
        if (!this.zzaem && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaeo.mutate();
            this.zzaep.mutate();
            this.zzaem = true;
        }
        return this;
    }

    public Drawable zzoF() {
        return this.zzaep;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzaei = this.zzaej;
        this.zzael = 0;
        this.zzaek = durationMillis;
        this.zzaeh = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaeh) {
            case 1: {
                this.zzNY = SystemClock.uptimeMillis();
                bl = false;
                this.zzaeh = 2;
                break;
            }
            case 2: {
                if (this.zzNY < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzNY) / (float)this.zzaek;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzaeh = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzael = (int)((float)this.mFrom + (float)(this.zzaei - this.mFrom) * f);
            }
        }
        int n = this.zzael;
        boolean bl3 = this.zzaea;
        Drawable drawable2 = this.zzaeo;
        Drawable drawable3 = this.zzaep;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzaej) {
                drawable3.setAlpha(this.zzaej);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzaej - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzaej);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzaej);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzls$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzls$zza zzaeu = new com.google.android.gms.internal.zzls$zza();
        private static final zza zzaev = new zza();

        private com.google.android.gms.internal.zzls$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzaev;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzaeu;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzaew;
        int zzaex;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzaew = zzb2.zzaew;
                this.zzaex = zzb2.zzaex;
            }
        }

        public Drawable newDrawable() {
            return new zzls(this);
        }

        public int getChangingConfigurations() {
            return this.zzaew;
        }
    }
}

