/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

public final class Size {
    private final int zzov;
    private final int zzow;

    public Size(int width, int height) {
        this.zzov = width;
        this.zzow = height;
    }

    public int getWidth() {
        return this.zzov;
    }

    public int getHeight() {
        return this.zzow;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size size = (Size)obj;
            return this.zzov == size.zzov && this.zzow == size.zzow;
        }
        return false;
    }

    public String toString() {
        return this.zzov + "x" + this.zzow;
    }

    private static NumberFormatException zzcw(String string2) {
        throw new NumberFormatException("Invalid Size: \"" + string2 + "\"");
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        if (string2 == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        int n = string2.indexOf(42);
        if (n < 0) {
            n = string2.indexOf(120);
        }
        if (n < 0) {
            throw Size.zzcw(string2);
        }
        try {
            return new Size(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw Size.zzcw(string2);
        }
    }

    public int hashCode() {
        return this.zzow ^ (this.zzov << 16 | this.zzov >>> 16);
    }
}

