/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzor;

public abstract class zznu
extends zzoq
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean zzalQ;
    private ConnectionResult zzalR;
    private int zzalS = -1;
    private final Handler zzalT = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzaln;

    protected zznu(zzor zzor2) {
        this(zzor2, GoogleApiAvailability.getInstance());
    }

    zznu(zzor zzor2, GoogleApiAvailability googleApiAvailability) {
        super(zzor2);
        this.zzaln = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.zzalS);
        this.zzrF();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.zzalQ = bundle.getBoolean("resolving_error", false);
            if (this.zzalQ) {
                this.zzalS = bundle.getInt("failed_client_id", -1);
                this.zzalR = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.zzalQ);
        if (this.zzalQ) {
            bundle.putInt("failed_client_id", this.zzalS);
            bundle.putInt("failed_status", this.zzalR.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.zzalR.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.zzaln.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.zzalR.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.zzalR = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzrF();
        } else {
            this.zza(this.zzalR, this.zzalS);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzrA();

    protected void zzrF() {
        this.zzalS = -1;
        this.zzalQ = false;
        this.zzalR = null;
        this.zzrA();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.zzalQ) {
            this.zzalQ = true;
            this.zzalS = n;
            this.zzalR = connectionResult;
            this.zzalT.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zznu.this.mStarted) {
                return;
            }
            if (zznu.this.zzalR.hasResolution()) {
                zznu.this.zzaop.startActivityForResult(GoogleApiActivity.zzb((Context)zznu.this.getActivity(), zznu.this.zzalR.getResolution(), zznu.this.zzalS, false), 1);
            } else if (zznu.this.zzaln.isUserResolvableError(zznu.this.zzalR.getErrorCode())) {
                zznu.this.zzaln.zza(zznu.this.getActivity(), zznu.this.zzaop, zznu.this.zzalR.getErrorCode(), 2, zznu.this);
            } else if (zznu.this.zzalR.getErrorCode() == 18) {
                final Dialog dialog = zznu.this.zzaln.zza(zznu.this.getActivity(), zznu.this);
                zznu.this.zzaln.zza(zznu.this.getActivity().getApplicationContext(), new zzol.zza(){

                    @Override
                    public void zzrG() {
                        zznu.this.zzrF();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zznu.this.zza(zznu.this.zzalR, zznu.this.zzalS);
            }
        }
    }
}

