/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzvy;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzqb
implements zzqe {
    private final zzqf tm;
    private final Lock th;
    private final Context mContext;
    private final com.google.android.gms.common.zzc tp;
    private ConnectionResult tq;
    private int tr;
    private int ts = 0;
    private int tt;
    private final Bundle tu = new Bundle();
    private final Set<Api.zzc> tv = new HashSet<Api.zzc>();
    private zzvx tw;
    private int tx;
    private boolean ty;
    private boolean tz;
    private zzq tA;
    private boolean tB;
    private boolean tC;
    private final zzg tD;
    private final Map<Api<?>, Integer> tE;
    private final Api.zza<? extends zzvx, zzvy> rY;
    private ArrayList<Future<?>> tF = new ArrayList();

    public zzqb(zzqf zzqf2, zzg zzg2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzvx, zzvy> zza2, Lock lock, Context context) {
        this.tm = zzqf2;
        this.tD = zzg2;
        this.tE = map;
        this.tp = zzc2;
        this.rY = zza2;
        this.th = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.tm.un.clear();
        this.ty = false;
        this.tq = null;
        this.ts = 0;
        this.tx = 2;
        this.tz = false;
        this.tB = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.tE.keySet()) {
            Api.zze zze2 = this.tm.tY.get(api.zzanp());
            int n = this.tE.get(api);
            bl |= api.zzanm().getPriority() == 1;
            if (zze2.zzafk()) {
                this.ty = true;
                if (n < this.tx) {
                    this.tx = n;
                }
                if (n != 0) {
                    this.tv.add(api.zzanp());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.ty = false;
        }
        if (this.ty) {
            this.tD.zzc(this.tm.sX.getSessionId());
            zze zze3 = new zze();
            this.tw = this.rY.zza(this.mContext, this.tm.sX.getLooper(), this.tD, this.tD.zzasl(), zze3, zze3);
        }
        this.tt = this.tm.tY.size();
        this.tF.add(zzqg.zzapz().submit(new zzb(hashMap)));
    }

    private boolean zzapj() {
        --this.tt;
        if (this.tt > 0) {
            return false;
        }
        if (this.tt < 0) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.tm.sX.zzapv());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        if (this.tq != null) {
            this.tm.uq = this.tr;
            this.zzg(this.tq);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzfg(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zzatd();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzbzv();
            ConnectionResult connectionResult2 = resolveAccountResponse.zzatd();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzg(connectionResult2);
                return;
            }
            this.tz = true;
            this.tA = resolveAccountResponse.zzatc();
            this.tB = resolveAccountResponse.zzate();
            this.tC = resolveAccountResponse.zzatf();
            this.zzapk();
        } else if (this.zzf(connectionResult)) {
            this.zzapn();
            this.zzapk();
        } else {
            this.zzg(connectionResult);
        }
    }

    private void zzapk() {
        if (this.tt != 0) {
            return;
        }
        if (!this.ty || this.tz) {
            this.zzapl();
        }
    }

    private void zzapl() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.ts = 1;
        this.tt = this.tm.tY.size();
        for (Api.zzc<?> zzc2 : this.tm.tY.keySet()) {
            if (this.tm.un.containsKey(zzc2)) {
                if (!this.zzapj()) continue;
                this.zzapm();
                continue;
            }
            arrayList.add(this.tm.tY.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.tF.add(zzqg.zzapz().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzfg(1)) {
            return;
        }
        if (bundle != null) {
            this.tu.putAll(bundle);
        }
        if (this.zzapj()) {
            this.zzapm();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzfg(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzapj()) {
            this.zzapm();
        }
    }

    private void zzapm() {
        this.tm.zzapx();
        zzqg.zzapz().execute(new Runnable(){

            @Override
            public void run() {
                zzqb.this.tp.zzbp(zzqb.this.mContext);
            }
        });
        if (this.tw != null) {
            if (this.tB) {
                this.tw.zza(this.tA, this.tC);
            }
            this.zzbl(false);
        }
        for (Api.zzc<?> zzc2 : this.tm.un.keySet()) {
            Api.zze zze2 = this.tm.tY.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.tu.isEmpty() ? null : this.tu;
        this.tm.ur.zzm(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpr.zza<R, A>> T zzc(T t) {
        this.tm.sX.tS.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zzd(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzapo();
        this.zzbl(true);
        this.tm.zzi(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzg(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzanm().getPriority(), n, connectionResult)) {
            this.tq = connectionResult;
            this.tr = n2;
        }
        this.tm.un.put(api.zzanp(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zze(connectionResult)) {
            return false;
        }
        return this.tq == null || n < this.tr;
    }

    private boolean zze(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.tp.zzfa(connectionResult.getErrorCode()) != null;
    }

    private void zzapn() {
        this.ty = false;
        this.tm.sX.tZ = Collections.emptySet();
        for (Api.zzc zzc2 : this.tv) {
            if (this.tm.un.containsKey(zzc2)) continue;
            this.tm.un.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzf(ConnectionResult connectionResult) {
        return this.tx == 2 || this.tx == 1 && !connectionResult.hasResolution();
    }

    private void zzg(ConnectionResult connectionResult) {
        this.zzapo();
        this.zzbl(!connectionResult.hasResolution());
        this.tm.zzi(connectionResult);
        this.tm.ur.zzd(connectionResult);
    }

    private void zzbl(boolean bl) {
        if (this.tw != null) {
            if (this.tw.isConnected() && bl) {
                this.tw.zzbzk();
            }
            this.tw.disconnect();
            this.tA = null;
        }
    }

    private void zzapo() {
        for (Future<?> future : this.tF) {
            future.cancel(true);
        }
        this.tF.clear();
    }

    private Set<Scope> zzapp() {
        if (this.tD == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.tD.zzasf());
        Map<Api<?>, zzg.zza> map = this.tD.zzash();
        for (Api<?> api : map.keySet()) {
            if (this.tm.un.containsKey(api.zzanp())) continue;
            hashSet.addAll(map.get(api).dY);
        }
        return hashSet;
    }

    private boolean zzfg(int n) {
        if (this.ts != n) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.tm.sX.zzapv());
            String string2 = String.valueOf(this);
            Log.i((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.tt;
            Log.i((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzfh(this.ts));
            String string4 = String.valueOf(this.zzfh(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzfh(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzqb> tH;

        zzd(zzqb zzqb2) {
            this.tH = new WeakReference<zzqb>(zzqb2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzqb zzqb2 = (zzqb)this.tH.get();
            if (zzqb2 == null) {
                return;
            }
            zzqb2.tm.zza(new zzqf.zza(zzqb2){

                @Override
                public void zzapi() {
                    zzqb2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements zzd.zzf {
        private final WeakReference<zzqb> tH;
        private final Api<?> pD;
        private final int sV;

        public zza(zzqb zzqb2, Api<?> api, int n) {
            this.tH = new WeakReference<zzqb>(zzqb2);
            this.pD = api;
            this.sV = n;
        }

        public void zzh(@NonNull ConnectionResult connectionResult) {
            zzqb zzqb2 = (zzqb)this.tH.get();
            if (zzqb2 == null) {
                return;
            }
            zzab.zza((Looper.myLooper() == ((zzqb)zzqb2).tm.sX.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzqb2.th.lock();
            try {
                if (!zzqb2.zzfg(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzqb2.zzb(connectionResult, this.pD, this.sV);
                }
                if (zzqb2.zzapj()) {
                    zzqb2.zzapk();
                }
            }
            finally {
                zzqb2.th.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzqb.this.tw.zza(new zzd(zzqb.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzqb.this.th.lock();
            try {
                if (zzqb.this.zzf(connectionResult)) {
                    zzqb.this.zzapn();
                    zzqb.this.zzapk();
                } else {
                    zzqb.this.zzg(connectionResult);
                }
            }
            finally {
                zzqb.this.th.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> tM;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.tM = arrayList;
        }

        @Override
        @WorkerThread
        public void zzapi() {
            ((zzqb)zzqb.this).tm.sX.tZ = zzqb.this.zzapp();
            for (Api.zze zze2 : this.tM) {
                zze2.zza(zzqb.this.tA, ((zzqb)zzqb.this).tm.sX.tZ);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> tI;

        public zzb(Map<Api.zze, zza> map) {
            this.tI = map;
        }

        @Override
        @WorkerThread
        public void zzapi() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.tI.keySet()) {
                if (object.zzanr()) {
                    bl2 = true;
                    if (this.tI.get(object).sV != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzqb.this.tp.isGooglePlayServicesAvailable(zzqb.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzqb.this.tm.zza(new zzqf.zza(zzqb.this){

                    @Override
                    public void zzapi() {
                        zzqb.this.zzg(connectionResult);
                    }
                });
                return;
            }
            if (zzqb.this.ty) {
                zzqb.this.tw.connect();
            }
            for (Api.zze zze2 : this.tI.keySet()) {
                final zzd.zzf zzf2 = this.tI.get(zze2);
                if (zze2.zzanr() && n != 0) {
                    zzqb.this.tm.zza(new zzqf.zza(zzqb.this){

                        @Override
                        public void zzapi() {
                            zzf2.zzh(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzqb.this.th.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzapi();
            }
            catch (RuntimeException runtimeException) {
                zzqb.this.tm.zza(runtimeException);
            }
            finally {
                zzqb.this.th.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzapi();
    }
}

