/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzpu;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqb;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzvx;
import com.google.android.gms.internal.zzvy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzqf
implements zzqm {
    private final Lock th;
    private final Condition ul;
    private final Context mContext;
    private final zzc tp;
    private final zzb um;
    final Map<Api.zzc<?>, Api.zze> tY;
    final Map<Api.zzc<?>, ConnectionResult> un = new HashMap();
    final zzg tD;
    final Map<Api<?>, Integer> tE;
    final Api.zza<? extends zzvx, zzvy> rY;
    private volatile zzqe uo;
    private ConnectionResult up = null;
    int uq;
    final zzqd sX;
    final zzqm.zza ur;

    public zzqf(Context context, zzqd zzqd2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzvx, zzvy> zza2, ArrayList<zzpu> arrayList, zzqm.zza zza3) {
        this.mContext = context;
        this.th = lock;
        this.tp = zzc2;
        this.tY = map;
        this.tD = zzg2;
        this.tE = map2;
        this.rY = zza2;
        this.sX = zzqd2;
        this.ur = zza3;
        for (zzpu zzpu2 : arrayList) {
            zzpu2.zza(this);
        }
        this.um = new zzb(looper);
        this.ul = lock.newCondition();
        this.uo = new zzqc(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzpr.zza<R, A>> T zzc(@NonNull T t) {
        t.zzaot();
        return this.uo.zzc(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzpr.zza<? extends Result, A>> T zzd(@NonNull T t) {
        t.zzaot();
        return this.uo.zzd(t);
    }

    @Override
    public void connect() {
        this.uo.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.ul.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.qR;
        }
        if (this.up != null) {
            return this.up;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.ul.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.qR;
        }
        if (this.up != null) {
            return this.up;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.uo.disconnect();
        if (bl) {
            this.un.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzanp();
        if (this.tY.containsKey(zzc2)) {
            if (this.tY.get(zzc2).isConnected()) {
                return ConnectionResult.qR;
            }
            if (this.un.containsKey(zzc2)) {
                return this.un.get(zzc2);
            }
        }
        return null;
    }

    void zzapw() {
        this.th.lock();
        try {
            this.uo = new zzqb(this, this.tD, this.tE, this.tp, this.rY, this.th, this.mContext);
            this.uo.begin();
            this.ul.signalAll();
        }
        finally {
            this.th.unlock();
        }
    }

    void zzapx() {
        this.th.lock();
        try {
            this.sX.zzapt();
            this.uo = new zzqa(this);
            this.uo.begin();
            this.ul.signalAll();
        }
        finally {
            this.th.unlock();
        }
    }

    void zzi(ConnectionResult connectionResult) {
        this.th.lock();
        try {
            this.up = connectionResult;
            this.uo = new zzqc(this);
            this.uo.begin();
            this.ul.signalAll();
        }
        finally {
            this.th.unlock();
        }
    }

    void zzapy() {
        for (Api.zze zze2 : this.tY.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.uo instanceof zzqa;
    }

    @Override
    public boolean isConnecting() {
        return this.uo instanceof zzqb;
    }

    @Override
    public boolean zza(zzqy zzqy2) {
        return false;
    }

    @Override
    public void zzaoc() {
    }

    @Override
    public void zzaoy() {
        if (this.isConnected()) {
            ((zzqa)this.uo).zzaph();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.th.lock();
        try {
            this.uo.zza(connectionResult, api, n);
        }
        finally {
            this.th.unlock();
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        this.th.lock();
        try {
            this.uo.onConnected(bundle);
        }
        finally {
            this.th.unlock();
        }
    }

    public void onConnectionSuspended(int n) {
        this.th.lock();
        try {
            this.uo.onConnectionSuspended(n);
        }
        finally {
            this.th.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.um.obtainMessage(1, zza2);
        this.um.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.um.obtainMessage(2, runtimeException);
        this.um.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.uo);
        for (Api<?> api : this.tE.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.tY.get(api.zzanp());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzqe us;

        protected zza(zzqe zzqe2) {
            this.us = zzqe2;
        }

        public final void zzd(zzqf zzqf2) {
            zzqf2.th.lock();
            try {
                if (zzqf2.uo != this.us) {
                    return;
                }
                this.zzapi();
            }
            finally {
                zzqf2.th.unlock();
            }
        }

        protected abstract void zzapi();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzd(zzqf.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

