/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzai;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqt;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<O extends Api.ApiOptions> {
    private final Context mContext;
    private final zzre vv;
    private final Api<O> tv;
    private final O vw;
    private final zzpz<O> vx;
    private final Looper zzajn;
    private final int mId;
    private final zzqt vy;
    private final GoogleApiClient vz;
    private final AtomicBoolean vA = new AtomicBoolean(false);
    private final AtomicInteger vB = new AtomicInteger(0);
    private Api.zze vC;

    public zzd(@NonNull Context context, Api<O> api, O o, Looper looper) {
        zzac.zzb((Object)context, (Object)"Null context is not permitted.");
        zzac.zzb(api, (Object)"Api must not be null.");
        zzac.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.tv = api;
        this.vw = o;
        this.zzajn = looper;
        this.vv = new zzre();
        this.vx = zzpz.zza(this.tv, this.vw);
        this.vz = new zzqu(this);
        Pair<zzqt, Integer> pair = zzqt.zza(this.mContext, this);
        this.vy = (zzqt)pair.first;
        this.mId = (Integer)pair.second;
    }

    public zzd(@NonNull Context context, Api<O> api, O o) {
        this(context, api, o, Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper());
    }

    public void release() {
        if (this.vA.getAndSet(true)) {
            return;
        }
        this.vv.release();
        this.vy.zzd(this.mId, this.vB.get() > 0);
    }

    private <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzaqt();
        this.vy.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzro<A, TResult> zzro2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.vy.zza(this, n, zzro2, taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zza(zzro<A, TResult> zzro2) {
        return this.zza(0, zzro2);
    }

    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> zzb(zzro<A, TResult> zzro2) {
        return this.zza(1, zzro2);
    }

    public void zzapu() {
        this.vB.incrementAndGet();
    }

    public void zzapv() {
        if (this.vB.decrementAndGet() == 0 && this.vA.get()) {
            this.vy.zzd(this.mId, false);
        }
    }

    @WorkerThread
    public Api.zze zza(Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        if (!this.zzapw()) {
            if (this.tv.zzapq()) {
                Api.zzh<?, O> zzh2 = this.tv.zzapo();
                this.vC = new zzai(this.mContext, looper, zzh2.zzapt(), connectionCallbacks, onConnectionFailedListener, zzh.zzcd(this.mContext), zzh2.zzr(this.vw));
            } else {
                this.vC = this.tv.zzapn().zza(this.mContext, looper, zzh.zzcd(this.mContext), this.vw, connectionCallbacks, onConnectionFailedListener);
            }
        }
        return this.vC;
    }

    public boolean zzapw() {
        return this.vC != null;
    }

    public zzpz<O> zzapx() {
        return this.vx;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient zzapy() {
        return this.vz;
    }

    public Looper getLooper() {
        return this.zzajn;
    }
}

