/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.google.android.gms.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.ErrorDialogFragment;
import com.google.android.gms.common.SupportErrorDialogFragment;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zzrt;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;

public class GoogleApiAvailability
extends zzc {
    private static final GoogleApiAvailability wR = new GoogleApiAvailability();
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";

    public static GoogleApiAvailability getInstance() {
        return wR;
    }

    GoogleApiAvailability() {
    }

    @MainThread
    public Task<Void> makeGooglePlayServicesAvailable(Activity activity) {
        zzaa.zzhs((String)"makeGooglePlayServicesAvailable must be called from the main thread");
        int n = this.isGooglePlayServicesAvailable((Context)activity);
        if (n == 0) {
            return Tasks.forResult(null);
        }
        zzrt zzrt2 = zzrt.zzu(activity);
        zzrt2.zzj(new ConnectionResult(n, null));
        return zzrt2.getTask();
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2) {
        return this.getErrorDialog(activity, n, n2, null);
    }

    public Dialog getErrorDialog(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zzb((Context)activity, n, "d");
        return this.zza((Context)activity, n, zzh.zza(activity, intent, n2), onCancelListener);
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2) {
        return this.showErrorDialogFragment(activity, n, n2, null);
    }

    public boolean zza(Activity activity, @NonNull zzrp zzrp2, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Intent intent = this.zzb((Context)activity, n, "d");
        Dialog dialog = this.zza((Context)activity, n, zzh.zza(zzrp2, intent, n2), onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public boolean showErrorDialogFragment(Activity activity, int n, int n2, DialogInterface.OnCancelListener onCancelListener) {
        Dialog dialog = this.getErrorDialog(activity, n, n2, onCancelListener);
        if (dialog == null) {
            return false;
        }
        this.zza(activity, dialog, "GooglePlayServicesErrorDialog", onCancelListener);
        return true;
    }

    public void showErrorNotification(Context context, int n) {
        this.zza(context, n, null);
    }

    public void zza(Context context, int n, String string2) {
        PendingIntent pendingIntent = this.zza(context, n, 0, "n");
        this.zza(context, n, string2, pendingIntent);
    }

    public void showErrorNotification(Context context, ConnectionResult connectionResult) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        this.zza(context, connectionResult.getErrorCode(), null, pendingIntent);
    }

    public void zza(Context context, ConnectionResult connectionResult, int n) {
        PendingIntent pendingIntent = this.getErrorResolutionPendingIntent(context, connectionResult);
        if (pendingIntent != null) {
            this.zza(context, connectionResult.getErrorCode(), null, GoogleApiActivity.zza(context, pendingIntent, n));
        }
    }

    public Dialog zza(Activity activity, DialogInterface.OnCancelListener onCancelListener) {
        ProgressBar progressBar = new ProgressBar((Context)activity, null, 16842874);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(0);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setView((View)progressBar);
        builder.setMessage((CharSequence)zzg.zzi((Context)activity, 18));
        builder.setPositiveButton((CharSequence)"", null);
        AlertDialog alertDialog = builder.create();
        this.zza(activity, (Dialog)alertDialog, "GooglePlayServicesUpdatingDialog", onCancelListener);
        return alertDialog;
    }

    @Nullable
    public zzrj zza(Context context, zzrj.zza zza2) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        zzrj zzrj2 = new zzrj(zza2);
        context.registerReceiver((BroadcastReceiver)zzrj2, intentFilter);
        zzrj2.setContext(context);
        if (!this.zzs(context, GOOGLE_PLAY_SERVICES_PACKAGE)) {
            zza2.zzarr();
            zzrj2.unregister();
            return null;
        }
        return zzrj2;
    }

    public int isGooglePlayServicesAvailable(Context context) {
        return super.isGooglePlayServicesAvailable(context);
    }

    public final boolean isUserResolvableError(int n) {
        return super.isUserResolvableError(n);
    }

    @Deprecated
    @Nullable
    public Intent zzfp(int n) {
        return super.zzfp(n);
    }

    @Nullable
    public Intent zzb(Context context, int n, @Nullable String string2) {
        return super.zzb(context, n, string2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, int n, int n2) {
        return super.getErrorResolutionPendingIntent(context, n, n2);
    }

    @Nullable
    public PendingIntent getErrorResolutionPendingIntent(Context context, ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return connectionResult.getResolution();
        }
        return this.getErrorResolutionPendingIntent(context, connectionResult.getErrorCode(), 0);
    }

    @Nullable
    public PendingIntent zza(Context context, int n, int n2, @Nullable String string2) {
        return super.zza(context, n, n2, string2);
    }

    @Nullable
    public String getOpenSourceSoftwareLicenseInfo(Context context) {
        return super.getOpenSourceSoftwareLicenseInfo(context);
    }

    public int zzbk(Context context) {
        return super.zzbk(context);
    }

    public boolean zzd(Context context, int n) {
        return super.zzd(context, n);
    }

    public final String getErrorString(int n) {
        return super.getErrorString(n);
    }

    @TargetApi(value=14)
    Dialog zza(Context context, int n, zzh zzh2, DialogInterface.OnCancelListener onCancelListener) {
        String string2;
        Object object;
        if (n == 0) {
            return null;
        }
        AlertDialog.Builder builder = null;
        if (zzs.zzayq()) {
            object = new TypedValue();
            context.getTheme().resolveAttribute(16843529, object, true);
            string2 = context.getResources().getResourceEntryName(object.resourceId);
            if ("Theme.Dialog.Alert".equals(string2)) {
                builder = new AlertDialog.Builder(context, 5);
            }
        }
        if (builder == null) {
            builder = new AlertDialog.Builder(context);
        }
        builder.setMessage((CharSequence)zzg.zzi(context, n));
        if (onCancelListener != null) {
            builder.setOnCancelListener(onCancelListener);
        }
        if ((object = zzg.zzk(context, n)) != null) {
            builder.setPositiveButton((CharSequence)object, (DialogInterface.OnClickListener)zzh2);
        }
        if ((string2 = zzg.zzg(context, n)) != null) {
            builder.setTitle((CharSequence)string2);
        }
        return builder.create();
    }

    @TargetApi(value=11)
    void zza(Activity activity, Dialog dialog, String string2, DialogInterface.OnCancelListener onCancelListener) {
        boolean bl;
        try {
            bl = activity instanceof FragmentActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        if (bl) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportErrorDialogFragment supportErrorDialogFragment = SupportErrorDialogFragment.newInstance(dialog, onCancelListener);
            supportErrorDialogFragment.show(fragmentManager, string2);
        } else if (zzs.zzayn()) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            ErrorDialogFragment errorDialogFragment = ErrorDialogFragment.newInstance(dialog, onCancelListener);
            errorDialogFragment.show(fragmentManager, string2);
        } else {
            throw new RuntimeException("This Activity does not support Fragments.");
        }
    }

    @TargetApi(value=20)
    void zza(Context context, int n, String string2, PendingIntent pendingIntent) {
        int n2;
        Notification notification;
        Notification.Builder builder;
        if (n == 18) {
            this.zzbl(context);
            return;
        }
        if (pendingIntent == null) {
            if (n == 6) {
                Log.w((String)"GoogleApiAvailability", (String)"Missing resolution for ConnectionResult.RESOLUTION_REQUIRED. Call GoogleApiAvailability#showErrorNotification(Context, ConnectionResult) instead.");
            }
            return;
        }
        String string3 = zzg.zzh(context, n);
        String string4 = zzg.zzj(context, n);
        Resources resources = context.getResources();
        if (zzi.zzci((Context)context)) {
            zzaa.zzbs((boolean)zzs.zzayv());
            builder = new Notification.Builder(context).setSmallIcon(context.getApplicationInfo().icon).setPriority(2).setAutoCancel(true).setContentTitle((CharSequence)string3).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string4)).addAction(R.drawable.common_full_open_on_phone, (CharSequence)resources.getString(R.string.common_open_on_phone), pendingIntent);
            notification = builder.build();
        } else {
            builder = new NotificationCompat.Builder(context).setSmallIcon(17301642).setTicker((CharSequence)resources.getString(R.string.common_google_play_services_notification_ticker)).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string3).setContentText((CharSequence)string4).setLocalOnly(true).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string4));
            notification = builder.build();
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n2 = 10436;
                zze.xf.set(false);
                break;
            }
            default: {
                n2 = 39789;
            }
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (string2 == null) {
            notificationManager.notify(n2, notification);
        } else {
            notificationManager.notify(string2, n2, notification);
        }
    }

    void zzbl(Context context) {
        zza zza2 = new zza(context);
        zza2.sendEmptyMessageDelayed(1, 120000L);
    }

    @SuppressLint(value={"HandlerLeak"})
    private class zza
    extends Handler {
        private final Context zzatc;

        public zza(Context context) {
            super(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
            this.zzatc = context.getApplicationContext();
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int n = GoogleApiAvailability.this.isGooglePlayServicesAvailable(this.zzatc);
                    if (!GoogleApiAvailability.this.isUserResolvableError(n)) break;
                    GoogleApiAvailability.this.showErrorNotification(this.zzatc, n);
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiAvailability", (String)new StringBuilder(50).append("Don't know how to handle this message: ").append(n).toString());
                }
            }
        }
    }
}

