/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzxo;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> xE = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = xE;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : xE) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzarc() {
        Set<GoogleApiClient> set = xE;
        synchronized (set) {
            return xE;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzrr<L> zzs(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzsa zzsa2) {
        throw new UnsupportedOperationException();
    }

    public void zzard() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzsf zzsf2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzsf zzsf2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account gj;
        private final Set<Scope> xF = new HashSet<Scope>();
        private final Set<Scope> xG = new HashSet<Scope>();
        private int xH;
        private View xI;
        private String hu;
        private String xJ;
        private final Map<Api<?>, zzf.zza> xK = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> xL = new ArrayMap();
        private zzrn xM;
        private int xN = -1;
        private OnConnectionFailedListener xO;
        private Looper zzajy;
        private GoogleApiAvailability xP = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzxp, zzxq> xQ = zzxo.hh;
        private final ArrayList<ConnectionCallbacks> xR = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> xS = new ArrayList();
        private boolean xT = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzajy = context.getMainLooper();
            this.hu = context.getPackageName();
            this.xJ = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzaa.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.xR.add(connectionCallbacks);
            zzaa.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.xS.add(onConnectionFailedListener);
        }

        public Builder setHandler(@NonNull Handler handler) {
            zzaa.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzajy = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzaa.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.xR.add(connectionCallbacks);
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzaa.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.xS.add(onConnectionFailedListener);
            return this;
        }

        public Builder setViewForPopups(@NonNull View view) {
            zzaa.zzb((Object)view, (Object)"View must not be null");
            this.xI = view;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            zzaa.zzb((Object)scope, (Object)"Scope must not be null");
            this.xF.add(scope);
            return this;
        }

        public Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzaa.zzb(api, (Object)"Api must not be null");
            this.xL.put(api, null);
            List<Scope> list = api.zzaqs().zzp(null);
            this.xG.addAll(list);
            this.xF.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzaa.zzb(api, (Object)"Api must not be null");
            this.xL.put(api, null);
            this.zza(api, null, 1, scopeArray);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzaa.zzb(api, (Object)"Api must not be null");
            zzaa.zzb(o, (Object)"Null options are not permitted for this Api");
            this.xL.put(api, o);
            List<Scope> list = api.zzaqs().zzp(o);
            this.xG.addAll(list);
            this.xF.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzaa.zzb(api, (Object)"Api must not be null");
            zzaa.zzb(o, (Object)"Null options are not permitted for this Api");
            this.xL.put(api, o);
            this.zza(api, o, 1, scopeArray);
            return this;
        }

        public Builder setAccountName(String string2) {
            this.gj = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int n) {
            this.xH = n;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.zza(new zzrn((Activity)fragmentActivity), n, onConnectionFailedListener);
        }

        private Builder zza(@NonNull zzrn zzrn2, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            zzaa.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            this.xN = n;
            this.xO = onConnectionFailedListener;
            this.xM = zzrn2;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public zzf zzarf() {
            zzxq zzxq2 = zzxq.aDl;
            if (this.xL.containsKey(zzxo.API)) {
                zzxq2 = (zzxq)this.xL.get(zzxo.API);
            }
            return new zzf(this.gj, this.xF, this.xK, this.xH, this.xI, this.hu, this.xJ, zzxq2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            zzaa.zzb((!this.xL.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzarg();
            Set set = xE;
            synchronized (set) {
                xE.add(googleApiClient);
            }
            if (this.xN >= 0) {
                this.zzf(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzarg() {
            zzf zzf2 = this.zzarf();
            Api<?> object = null;
            Api<?> object2 = null;
            Map<Api<?>, zzf.zza> map = zzf2.zzavr();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzqr> arrayList = new ArrayList<zzqr>();
            for (Api<?> object3 : this.xL.keySet()) {
                zzag<Object> zzag2;
                Api.zzd zzd2;
                Api.ApiOptions apiOptions = this.xL.get(object3);
                int n = 0;
                if (map.get(object3) != null) {
                    n = map.get(object3).DN ? 1 : 2;
                }
                arrayMap.put(object3, n);
                zzqr zzqr2 = new zzqr(object3, n);
                arrayList.add(zzqr2);
                if (object3.zzaqw()) {
                    zzd2 = object3.zzaqu();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzag2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzajy, zzf2, (ConnectionCallbacks)zzqr2, (OnConnectionFailedListener)zzqr2);
                } else {
                    zzd2 = object3.zzaqt();
                    if (zzd2.getPriority() == 1) {
                        object2 = object3;
                    }
                    zzag2 = Builder.zza(zzd2, (Object)apiOptions, this.mContext, this.zzajy, zzf2, (ConnectionCallbacks)zzqr2, (OnConnectionFailedListener)zzqr2);
                }
                arrayMap2.put(object3.zzaqv(), zzag2);
                if (!zzag2.zzajc()) continue;
                if (object != null) {
                    zzd2 = String.valueOf(object3.getName());
                    String string2 = String.valueOf(object.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(zzd2).length() + String.valueOf(string2).length()).append((String)((Object)zzd2)).append(" cannot be used with ").append(string2).toString());
                }
                object = object3;
            }
            if (object != null) {
                if (object2 != null) {
                    String string3 = String.valueOf(object.getName());
                    String string4 = String.valueOf(object2.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(" cannot be used with ").append(string4).toString());
                }
                zzaa.zza((this.gj == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{object.getName()});
                zzaa.zza((boolean)this.xF.equals(this.xG), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{object.getName()});
            }
            int n = zzrd.zza(arrayMap2.values(), true);
            return new zzrd(this.mContext, new ReentrantLock(), this.zzajy, zzf2, this.xP, this.xQ, (Map<Api<?>, Integer>)arrayMap, (List<ConnectionCallbacks>)this.xR, (List<OnConnectionFailedListener>)this.xS, (Map<Api.zzc<?>, Api.zze>)arrayMap2, this.xN, n, arrayList, false);
        }

        private void zzf(GoogleApiClient googleApiClient) {
            zzqm.zza(this.xM).zza(this.xN, googleApiClient, this.xO);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException(new StringBuilder(90).append("Invalid resolution mode: '").append(n).append("', use a constant from GoogleApiClient.ResolutionMode").toString());
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzaqs().zzp(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.xK.put(api, new zzf.zza(hashSet, bl));
        }

        private static <C extends Api.zze, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
        }

        private static <C extends Api.zzg, O> zzag zza(Api.zzh<C, O> zzh2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return new zzag(context, looper, zzh2.zzaqz(), connectionCallbacks, onConnectionFailedListener, zzf2, zzh2.zzr(object));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

