/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzsc;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzaa.zzb((Object)status, (Object)"Result must not be null");
        zzsc zzsc2 = new zzsc(Looper.getMainLooper());
        zzsc2.zzc(status);
        return zzsc2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzaa.zzb((Object)status, (Object)"Result must not be null");
        zzsc zzsc2 = new zzsc(googleApiClient);
        zzsc2.zzc(status);
        return zzsc2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzaa.zzb(r, (Object)"Result must not be null");
        zzaa.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzc(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzaa.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzc(r);
        return new zzru(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzaa.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zzc(r);
        return new zzru(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzsc zzsc2 = new zzsc(Looper.getMainLooper());
        zzsc2.cancel();
        return zzsc2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzaa.zzb(r, (Object)"Result must not be null");
        zzaa.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzqq<R> {
        private final R xU;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.xU = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.xU.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.xU;
        }
    }

    private static final class zzb<R extends Result>
    extends zzqq<R> {
        private final R xV;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.xV = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.xV;
        }
    }

    private static final class zzc<R extends Result>
    extends zzqq<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

