/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.tasks.TaskCompletionSource;

public abstract class zzqj {
    public final int nV;

    public zzqj(int n) {
        this.nV = n;
    }

    public abstract void zza(zzrh.zza<?> var1) throws DeadObjectException;

    public abstract void zzy(@NonNull Status var1);

    public abstract void zza(@NonNull zzqv var1, boolean var2);

    public static final class zzd<TResult>
    extends zzqj {
        private final zzse<Api.zzb, TResult> yk;
        private final TaskCompletionSource<TResult> yg;
        private final zzsb yl;
        private static final Status ym = new Status(8, "Connection to Google Play services was lost while executing the API call.");

        public zzd(int n, zzse<Api.zzb, TResult> zzse2, TaskCompletionSource<TResult> taskCompletionSource, zzsb zzsb2) {
            super(n);
            this.yg = taskCompletionSource;
            this.yk = zzse2;
            this.yl = zzsb2;
        }

        @Override
        public void zza(zzrh.zza<?> zza2) throws DeadObjectException {
            try {
                this.yk.zzb(zza2.getClient(), this.yg);
            }
            catch (DeadObjectException deadObjectException) {
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zzy(ym);
            }
        }

        @Override
        public void zzy(@NonNull Status status) {
            this.yg.trySetException(this.yl.zzz(status));
        }

        @Override
        public void zza(@NonNull zzqv zzqv2, boolean bl) {
            zzqv2.zza(this.yg, bl);
        }
    }

    public static final class zze
    extends zza {
        public final zzrr.zzb<?> yn;

        public zze(zzrr.zzb<?> zzb2, TaskCompletionSource<Void> taskCompletionSource) {
            super(4, taskCompletionSource);
            this.yn = zzb2;
        }

        @Override
        public void zzb(zzrh.zza<?> zza2) throws DeadObjectException {
            zzrx zzrx2 = zza2.zzatn().remove(this.yn);
            if (zzrx2 != null) {
                zzrx2.yj.zzc(zza2.getClient(), (TaskCompletionSource<Void>)this.yg);
                zzrx2.yi.zzaua();
            } else {
                Log.wtf((String)"UnregisterListenerTask", (String)"Received call to unregister a listener without a matching registration call.", (Throwable)new Exception());
                this.yg.trySetException((Exception)new com.google.android.gms.common.api.zza(Status.yb));
            }
        }
    }

    public static final class zzc
    extends zza {
        public final zzrw<Api.zzb> yi;
        public final zzsh<Api.zzb> yj;

        public zzc(zzrx zzrx2, TaskCompletionSource<Void> taskCompletionSource) {
            super(3, taskCompletionSource);
            this.yi = zzrx2.yi;
            this.yj = zzrx2.yj;
        }

        @Override
        public void zzb(zzrh.zza<?> zza2) throws DeadObjectException {
            this.yi.zza(zza2.getClient(), (TaskCompletionSource<Void>)this.yg);
            if (this.yi.zzatz() != null) {
                zza2.zzatn().put(this.yi.zzatz(), new zzrx(this.yi, this.yj));
            }
        }
    }

    private static abstract class zza
    extends zzqj {
        protected final TaskCompletionSource<Void> yg;

        public zza(int n, TaskCompletionSource<Void> taskCompletionSource) {
            super(n);
            this.yg = taskCompletionSource;
        }

        @Override
        public void zzy(@NonNull Status status) {
            this.yg.trySetException((Exception)new com.google.android.gms.common.api.zza(status));
        }

        @Override
        public void zza(@NonNull zzqv zzqv2, boolean bl) {
        }

        @Override
        public final void zza(zzrh.zza<?> zza2) throws DeadObjectException {
            try {
                this.zzb(zza2);
            }
            catch (DeadObjectException deadObjectException) {
                this.zza((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zza(remoteException);
            }
        }

        protected abstract void zzb(zzrh.zza<?> var1) throws RemoteException;

        private void zza(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.zzy(status);
        }
    }

    public static class zzb<A extends zzqo.zza<? extends Result, Api.zzb>>
    extends zzqj {
        protected final A yh;

        public zzb(int n, A a) {
            super(n);
            this.yh = a;
        }

        @Override
        public void zza(zzrh.zza<?> zza2) throws DeadObjectException {
            ((zzqo.zza)this.yh).zzb((Api.zze)zza2.getClient());
        }

        @Override
        public void zzy(@NonNull Status status) {
            ((zzqo.zza)this.yh).zzaa(status);
        }

        @Override
        public void zza(@NonNull zzqv zzqv2, boolean bl) {
            zzqv2.zza((zzqq<? extends Result>)this.yh, bl);
        }
    }
}

