/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.internal.zzrp;

public abstract class zzqp
extends zzro
implements DialogInterface.OnCancelListener {
    protected boolean mStarted;
    protected boolean yz;
    private ConnectionResult yA;
    private int yB = -1;
    private final Handler yC = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability xP;

    protected zzqp(zzrp zzrp2) {
        this(zzrp2, GoogleApiAvailability.getInstance());
    }

    zzqp(zzrp zzrp2, GoogleApiAvailability googleApiAvailability) {
        super(zzrp2);
        this.xP = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), this.yB);
        this.zzarq();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            this.yz = bundle.getBoolean("resolving_error", false);
            if (this.yz) {
                this.yB = bundle.getInt("failed_client_id", -1);
                this.yA = new ConnectionResult(bundle.getInt("failed_status"), (PendingIntent)bundle.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("resolving_error", this.yz);
        if (this.yz) {
            bundle.putInt("failed_client_id", this.yB);
            bundle.putInt("failed_status", this.yA.getErrorCode());
            bundle.putParcelable("failed_resolution", (Parcelable)this.yA.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        switch (n) {
            case 2: {
                int n3 = this.xP.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (this.yA.getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                this.yA = new ConnectionResult(n4, null);
            }
        }
        if (bl) {
            this.zzarq();
        } else {
            this.zza(this.yA, this.yB);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzarm();

    protected void zzarq() {
        this.yB = -1;
        this.yz = false;
        this.yA = null;
        this.zzarm();
    }

    public void zzb(ConnectionResult connectionResult, int n) {
        if (!this.yz) {
            this.yz = true;
            this.yB = n;
            this.yA = connectionResult;
            this.yC.post((Runnable)new zza());
        }
    }

    private class zza
    implements Runnable {
        private zza() {
        }

        @Override
        @MainThread
        public void run() {
            if (!zzqp.this.mStarted) {
                return;
            }
            if (zzqp.this.yA.hasResolution()) {
                zzqp.this.Bf.startActivityForResult(GoogleApiActivity.zzb((Context)zzqp.this.getActivity(), zzqp.this.yA.getResolution(), zzqp.this.yB, false), 1);
            } else if (zzqp.this.xP.isUserResolvableError(zzqp.this.yA.getErrorCode())) {
                zzqp.this.xP.zza(zzqp.this.getActivity(), zzqp.this.Bf, zzqp.this.yA.getErrorCode(), 2, zzqp.this);
            } else if (zzqp.this.yA.getErrorCode() == 18) {
                final Dialog dialog = zzqp.this.xP.zza(zzqp.this.getActivity(), zzqp.this);
                zzqp.this.xP.zza(zzqp.this.getActivity().getApplicationContext(), new zzrj.zza(){

                    @Override
                    public void zzarr() {
                        zzqp.this.zzarq();
                        if (dialog.isShowing()) {
                            dialog.dismiss();
                        }
                    }
                });
            } else {
                zzqp.this.zza(zzqp.this.yA, zzqp.this.yB);
            }
        }
    }
}

